/*
 * Decompiled with CFR 0.152.
 */
package ai.core;

import ai.core.AI;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;

public class ContinuingAI
extends AI {
    public static int DEBUG = 0;
    protected AI m_AI;
    protected boolean m_isThereAComputationGoingOn = false;
    protected GameState m_gameStateUsedForComputation = null;

    public ContinuingAI(AI aI) throws Exception {
        if (!(aI instanceof InterruptibleAI)) {
            throw new Exception("ContinuingAI: ai does not implement InterruptibleAI!");
        }
        this.m_AI = aI;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            if (this.m_gameStateUsedForComputation != null && !this.m_gameStateUsedForComputation.equals(gameState)) {
                if (DEBUG >= 1) {
                    System.out.println("The game state is different from the predicted one (this can happen in non-deterministic games), restarting search.");
                }
                this.m_isThereAComputationGoingOn = false;
                this.m_gameStateUsedForComputation = null;
            }
            if (DEBUG >= 1) {
                System.out.println("ContinuingAI: this cycle we need an action");
            }
            if (!this.m_isThereAComputationGoingOn) {
                ((InterruptibleAI)((Object)this.m_AI)).startNewComputation(n, gameState.clone());
            }
            ((InterruptibleAI)((Object)this.m_AI)).computeDuringOneGameFrame();
            this.m_isThereAComputationGoingOn = false;
            this.m_gameStateUsedForComputation = null;
            return ((InterruptibleAI)((Object)this.m_AI)).getBestActionSoFar();
        }
        if (!this.m_isThereAComputationGoingOn) {
            GameState gameState2 = gameState.clone();
            while (!(gameState2.winner() != -1 || gameState2.gameover() || gameState2.canExecuteAnyAction(0) || gameState2.canExecuteAnyAction(1))) {
                gameState2.cycle();
            }
            if (gameState2.winner() == -1 && !gameState2.gameover() && gameState2.canExecuteAnyAction(n)) {
                if (DEBUG >= 1) {
                    System.out.println("ContinuingAI: this cycle we do not need an action, but we will be next to move");
                }
                this.m_isThereAComputationGoingOn = true;
                this.m_gameStateUsedForComputation = gameState2;
                ((InterruptibleAI)((Object)this.m_AI)).startNewComputation(n, this.m_gameStateUsedForComputation);
                ((InterruptibleAI)((Object)this.m_AI)).computeDuringOneGameFrame();
            } else if (DEBUG >= 1) {
                System.out.println("ContinuingAI: this cycle we do not need an action, but we will not be next to move, so we can do nothing");
            }
        } else {
            if (DEBUG >= 1) {
                System.out.println("ContinuingAI: continuing a computation from a previous frame");
            }
            ((InterruptibleAI)((Object)this.m_AI)).computeDuringOneGameFrame();
        }
        return new PlayerAction();
    }

    @Override
    public void reset() {
        this.m_isThereAComputationGoingOn = false;
        this.m_gameStateUsedForComputation = null;
        this.m_AI.reset();
    }

    @Override
    public AI clone() {
        try {
            return new ContinuingAI(this.m_AI.clone());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.m_AI + ")";
    }

    @Override
    public String statisticsString() {
        return this.m_AI.statisticsString();
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return this.m_AI.getParameters();
    }

    @Override
    public void preGameAnalysis(GameState gameState, long l) throws Exception {
        this.m_AI.preGameAnalysis(gameState, l);
    }
}

