/*
 * Decompiled with CFR 0.152.
 */
package ai.core;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;

public class PseudoContinuingAI
extends AI {
    public static int DEBUG = 0;
    protected AIWithComputationBudget m_AI;
    protected int n_cycles_to_think = 1;
    protected GameState m_farecastedGameState = null;

    public PseudoContinuingAI(AIWithComputationBudget aIWithComputationBudget) {
        this.m_AI = aIWithComputationBudget;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            if (this.m_farecastedGameState != null && !this.m_farecastedGameState.equals(gameState)) {
                if (DEBUG >= 1) {
                    System.out.println("The game state is different from the predicted one (this can happen in non-deterministic games), restarring search.");
                }
                this.n_cycles_to_think = 1;
                this.m_farecastedGameState = null;
            }
            if (DEBUG >= 1) {
                System.out.println("PseudoContinuingAI: n_cycles_to_think = " + this.n_cycles_to_think);
            }
            int n2 = this.m_AI.TIME_BUDGET;
            int n3 = this.m_AI.ITERATIONS_BUDGET;
            if (n2 > 0) {
                this.m_AI.TIME_BUDGET = n2 * this.n_cycles_to_think;
            }
            if (n3 > 0) {
                this.m_AI.ITERATIONS_BUDGET = n3 * this.n_cycles_to_think;
            }
            PlayerAction playerAction = this.m_AI.getAction(n, gameState);
            this.m_AI.TIME_BUDGET = n2;
            this.m_AI.ITERATIONS_BUDGET = n3;
            this.n_cycles_to_think = 1;
            this.m_farecastedGameState = null;
            return playerAction;
        }
        if (this.n_cycles_to_think == 1) {
            GameState gameState2 = gameState.clone();
            while (!(gameState2.winner() != -1 || gameState2.gameover() || gameState2.canExecuteAnyAction(0) || gameState2.canExecuteAnyAction(1))) {
                gameState2.cycle();
            }
            if (gameState2.winner() == -1 && !gameState2.gameover() && gameState2.canExecuteAnyAction(n)) {
                ++this.n_cycles_to_think;
                this.m_farecastedGameState = gameState2;
            }
        } else {
            ++this.n_cycles_to_think;
        }
        return new PlayerAction();
    }

    @Override
    public void reset() {
        this.n_cycles_to_think = 1;
        this.m_AI.reset();
    }

    @Override
    public AI clone() {
        return new PseudoContinuingAI((AIWithComputationBudget)this.m_AI.clone());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.m_AI + ")";
    }

    @Override
    public String statisticsString() {
        return this.m_AI.statisticsString();
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return this.m_AI.getParameters();
    }

    public AIWithComputationBudget getbaseAI() {
        return this.m_AI;
    }
}

