/*
 * Decompiled with CFR 0.152.
 */
package ai.evaluation;

import ai.evaluation.EvaluationFunction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class LanchesterEvaluationFunction
extends EvaluationFunction {
    public static float[] W_BASE = new float[]{0.12900642f, 0.48944974f};
    public static float[] W_RAX = new float[]{0.23108198f, 0.55022866f};
    public static float[] W_WORKER = new float[]{0.18122299f, -0.007851469f};
    public static float[] W_LIGHT = new float[]{1.7496678f, 0.12587242f};
    public static float[] W_RANGE = new float[]{1.679384f, 0.029918374f};
    public static float[] W_HEAVY = new float[]{3.9012442f, 0.1641424f};
    public static float[] W_MINERALS_CARRIED = new float[]{0.35662296f, 0.010614901f};
    public static float[] W_MINERALS_MINED = new float[]{0.30141655f, 0.38643843f};
    public static float order = 1.7f;

    public static float sigmoid(float f) {
        return (float)(1.0 / (1.0 + Math.pow(Math.E, 0.0f - f)));
    }

    @Override
    public float evaluate(int n, int n2, GameState gameState) {
        return 2.0f * LanchesterEvaluationFunction.sigmoid(this.base_score(n, gameState) - this.base_score(n2, gameState)) - 1.0f;
    }

    public float base_score(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        int n2 = 0;
        switch (physicalGameState.getWidth()) {
            case 128: {
                n2 = 1;
            }
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        UnitTypeTable unitTypeTable = gameState.getUnitTypeTable();
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() != n) continue;
            f4 += (float)unit.getResources();
            if (unit.getType() == unitTypeTable.getUnitType("Base")) {
                f2 += W_BASE[n2] * (float)unit.getHitPoints();
                continue;
            }
            if (unit.getType() == unitTypeTable.getUnitType("Barracks")) {
                f2 += W_RAX[n2] * (float)unit.getHitPoints();
                continue;
            }
            if (unit.getType() == unitTypeTable.getUnitType("Worker")) {
                f3 += 1.0f;
                f += W_WORKER[n2] * (float)unit.getHitPoints();
                continue;
            }
            if (unit.getType() == unitTypeTable.getUnitType("Light")) {
                f3 += 1.0f;
                f += W_LIGHT[n2] * (float)unit.getHitPoints() / (float)unit.getMaxHitPoints();
                continue;
            }
            if (unit.getType() == unitTypeTable.getUnitType("Ranged")) {
                f3 += 1.0f;
                f += W_RANGE[n2] * (float)unit.getHitPoints();
                continue;
            }
            if (unit.getType() != unitTypeTable.getUnitType("Heavy")) continue;
            f3 += 1.0f;
            f += W_HEAVY[n2] * (float)unit.getHitPoints() / (float)unit.getMaxHitPoints();
        }
        f = (float)((double)f * Math.pow(f3, order - 1.0f));
        return f += f2 + f4 * W_MINERALS_CARRIED[n2] + (float)gameState.getPlayer(n).getResources() * W_MINERALS_MINED[n2];
    }

    @Override
    public float upperBound(GameState gameState) {
        return 2.0f;
    }
}

