/*
 * Decompiled with CFR 0.152.
 */
package ai.evaluation;

import ai.evaluation.EvaluationFunction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.Unit;

public class SimpleSqrtEvaluationFunction2
extends EvaluationFunction {
    public static float RESOURCE = 20.0f;
    public static float RESOURCE_IN_WORKER = 10.0f;
    public static float UNIT_BONUS_MULTIPLIER = 40.0f;

    @Override
    public float evaluate(int n, int n2, GameState gameState) {
        float f = this.base_score(n, gameState);
        float f2 = this.base_score(n2, gameState);
        if (f == 0.0f && f2 != 0.0f) {
            return -VICTORY;
        }
        if (f != 0.0f && f2 == 0.0f) {
            return VICTORY;
        }
        return f - f2;
    }

    public float base_score(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        float f = (float)gameState.getPlayer(n).getResources() * RESOURCE;
        boolean bl = false;
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() != n) continue;
            bl = true;
            f += (float)unit.getResources() * RESOURCE_IN_WORKER;
            f = (float)((double)f + (double)UNIT_BONUS_MULTIPLIER * ((double)unit.getCost() * Math.sqrt(unit.getHitPoints()) / (double)unit.getMaxHitPoints()));
        }
        if (!bl) {
            return 0.0f;
        }
        return f;
    }

    @Override
    public float upperBound(GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        int n = 0;
        int[] nArray = new int[]{gameState.getPlayer(0).getResources(), gameState.getPlayer(1).getResources()};
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() == -1) {
                n += unit.getResources();
            }
            if (unit.getPlayer() == 0) {
                nArray[0] = nArray[0] + unit.getResources();
                nArray[0] = nArray[0] + unit.getCost();
            }
            if (unit.getPlayer() != 1) continue;
            nArray[1] = nArray[1] + unit.getResources();
            nArray[1] = nArray[1] + unit.getCost();
        }
        return (float)(n + Math.max(nArray[0], nArray[1])) * UNIT_BONUS_MULTIPLIER;
    }
}

