/*
 * Decompiled with CFR 0.152.
 */
package ai.evaluation;

import ai.evaluation.EvaluationFunction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.units.Unit;

public class SimpleSqrtEvaluationFunction3
extends EvaluationFunction {
    public static float RESOURCE = 20.0f;
    public static float RESOURCE_IN_WORKER = 10.0f;
    public static float UNIT_BONUS_MULTIPLIER = 40.0f;

    @Override
    public float evaluate(int n, int n2, GameState gameState) {
        float f;
        float f2 = this.base_score(n, gameState);
        if (f2 + (f = this.base_score(n2, gameState)) == 0.0f) {
            return 0.5f;
        }
        return 2.0f * f2 / (f2 + f) - 1.0f;
    }

    public float base_score(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        float f = (float)gameState.getPlayer(n).getResources() * RESOURCE;
        boolean bl = false;
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() != n) continue;
            bl = true;
            f += (float)unit.getResources() * RESOURCE_IN_WORKER;
            f = (float)((double)f + (double)(UNIT_BONUS_MULTIPLIER * (float)unit.getCost()) * Math.sqrt(unit.getHitPoints() / unit.getMaxHitPoints()));
        }
        if (!bl) {
            return 0.0f;
        }
        return f;
    }

    @Override
    public float upperBound(GameState gameState) {
        return 1.0f;
    }
}

