/*
 * Decompiled with CFR 0.152.
 */
package ai.jni;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.SimpleEvaluationFunction;
import ai.jni.JNIInterface;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import rts.InvalidPlayerActionStats;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.Pair;

public class JNIAI
extends AIWithComputationBudget
implements JNIInterface {
    UnitTypeTable utt = null;
    double reward = 0.0;
    double oldReward = 0.0;
    boolean firstRewardCalculation = true;
    SimpleEvaluationFunction ef = new SimpleEvaluationFunction();
    InvalidPlayerActionStats ipas = null;

    public JNIAI(int n, int n2, UnitTypeTable unitTypeTable) {
        super(n, n2);
        this.utt = unitTypeTable;
    }

    @Override
    public double computeReward(int n, int n2, GameState gameState) throws Exception {
        if (this.firstRewardCalculation) {
            this.oldReward = this.ef.evaluate(n, n2, gameState);
            this.reward = 0.0;
            this.firstRewardCalculation = false;
        } else {
            double d = this.ef.evaluate(n, n2, gameState);
            this.reward = d - this.oldReward;
            this.oldReward = d;
        }
        return this.reward;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState, int[][] nArray) throws Exception {
        Pair<PlayerAction, InvalidPlayerActionStats> pair = PlayerAction.fromActionArrays(nArray, gameState, this.utt, n);
        ((PlayerAction)pair.m_a).fillWithNones(gameState, n, 1);
        this.ipas = (InvalidPlayerActionStats)pair.m_b;
        return (PlayerAction)pair.m_a;
    }

    @Override
    public int[][][] getObservation(int n, GameState gameState) throws Exception {
        return gameState.getMatrixObservation();
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return null;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return null;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        return null;
    }

    @Override
    public String computeInfo(int n, GameState gameState) throws Exception {
        HashMap<String, InvalidPlayerActionStats> hashMap = new HashMap<String, InvalidPlayerActionStats>();
        hashMap.put("invalid_action_stats", this.ipas);
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        return gson.toJson(hashMap);
    }
}

