/*
 * Decompiled with CFR 0.152.
 */
package ai.jni;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.SimpleEvaluationFunction;
import ai.jni.JNIInterface;
import java.io.StringWriter;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class JNILocalAI
extends AIWithComputationBudget
implements JNIInterface {
    UnitTypeTable utt = null;
    double reward = 0.0;
    double oldReward = 0.0;
    boolean firstRewardCalculation = true;
    SimpleEvaluationFunction ef = new SimpleEvaluationFunction();
    int windowSize = 1;
    int currentUnitCounter = 0;
    Unit currentUnit = null;

    public JNILocalAI(int n, int n2, UnitTypeTable unitTypeTable, int n3) {
        super(n, n2);
        this.utt = unitTypeTable;
        this.windowSize = n3;
    }

    @Override
    public double computeReward(int n, int n2, GameState gameState) throws Exception {
        if (this.firstRewardCalculation) {
            this.oldReward = this.ef.evaluate(n, n2, gameState);
            this.reward = 0.0;
            this.firstRewardCalculation = false;
        } else {
            double d = this.ef.evaluate(n, n2, gameState);
            this.reward = d - this.oldReward;
            this.oldReward = d;
        }
        return this.reward;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState, int[][] nArray) throws Exception {
        PlayerAction playerAction = PlayerAction.fromActionArrayForUnit(nArray, gameState, this.utt, n, this.currentUnit);
        playerAction.fillWithNones(gameState, n, 1);
        ++this.currentUnitCounter;
        if (this.currentUnitCounter >= gameState.getPhysicalGameState().getUnits().size()) {
            this.currentUnitCounter = 0;
        }
        return playerAction;
    }

    @Override
    public int[][][] getObservation(int n, GameState gameState) throws Exception {
        this.currentUnit = gameState.getPhysicalGameState().getUnits().get(this.currentUnitCounter);
        return gameState.getUnitObservation(this.currentUnit, this.windowSize);
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return null;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return null;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        return null;
    }

    @Override
    public String computeInfo(int n, GameState gameState) throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.currentUnit.toJSON(stringWriter);
        return String.format("{\"current_unit\": %s}", ((Object)stringWriter).toString());
    }
}

