/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes;

import org.jdom.Element;
import util.XMLWriter;

public class DiscreteCPD {
    public int Xvalues = 0;
    public int Yvalues = 0;
    public int[][] counts;

    public DiscreteCPD(int n, int n2) {
        this.Xvalues = n;
        this.Yvalues = n2;
        this.counts = new int[n][n2];
    }

    public void addObservation(int n, int n2) {
        int[] nArray = this.counts[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] + 1;
    }

    public int[] marginalizedCounts() {
        int[] nArray = new int[this.Yvalues];
        for (int j = 0; j < this.Xvalues; ++j) {
            for (int k = 0; k < this.Yvalues; ++k) {
                int n = k;
                nArray[n] = nArray[n] + this.counts[j][k];
            }
        }
        return nArray;
    }

    public double[] marginalizedDistribution() {
        int n;
        int[] nArray = this.marginalizedCounts();
        double[] dArray = new double[this.Yvalues];
        int n2 = 0;
        for (n = 0; n < this.Yvalues; ++n) {
            n2 += nArray[n];
        }
        for (n = 0; n < this.Yvalues; ++n) {
            dArray[n] = (double)nArray[n] / (double)n2;
        }
        return dArray;
    }

    public double[] marginalizedDistributionLaplace(double d) {
        int n;
        int[] nArray = this.marginalizedCounts();
        double[] dArray = new double[this.Yvalues];
        int n2 = 0;
        for (n = 0; n < this.Yvalues; ++n) {
            n2 += nArray[n];
        }
        for (n = 0; n < this.Yvalues; ++n) {
            dArray[n] = ((double)nArray[n] + d) / ((double)n2 + d * (double)this.Yvalues);
        }
        return dArray;
    }

    public double[] distribution(int n) {
        int n2;
        double[] dArray = new double[this.Yvalues];
        if (n >= this.Xvalues) {
            for (int j = 0; j < this.Yvalues; ++j) {
                dArray[j] = 1.0 / (double)this.Yvalues;
            }
            return dArray;
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.Yvalues; ++n2) {
            n3 += this.counts[n][n2];
        }
        for (n2 = 0; n2 < this.Yvalues; ++n2) {
            dArray[n2] = (double)this.counts[n][n2] / (double)n3;
        }
        return dArray;
    }

    public double[] distributionLaplace(int n, double d) {
        int n2;
        double[] dArray = new double[this.Yvalues];
        if (n >= this.Xvalues) {
            for (int j = 0; j < this.Yvalues; ++j) {
                dArray[j] = 1.0 / (double)this.Yvalues;
            }
            return dArray;
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.Yvalues; ++n2) {
            n3 += this.counts[n][n2];
        }
        for (n2 = 0; n2 < this.Yvalues; ++n2) {
            dArray[n2] = ((double)this.counts[n][n2] + d) / ((double)n3 + d * (double)this.Yvalues);
        }
        return dArray;
    }

    public void save(XMLWriter xMLWriter) throws Exception {
        xMLWriter.tagWithAttributes("DiscreteCPD", "Xvalues=\"" + this.Xvalues + "\" Yvalues=\"" + this.Yvalues + "\"");
        for (int j = 0; j < this.Xvalues; ++j) {
            for (int k = 0; k < this.Yvalues; ++k) {
                xMLWriter.rawXML(this.counts[j][k] + " ");
            }
            xMLWriter.rawXML("\n");
        }
        xMLWriter.tag("/DiscreteCPD");
    }

    public DiscreteCPD(Element element) throws Exception {
        if (!element.getName().equals("DiscreteCPD")) {
            throw new Exception("Head tag is not 'DiscreteCPD'!");
        }
        this.Xvalues = Integer.parseInt(element.getAttributeValue("Xvalues"));
        this.Yvalues = Integer.parseInt(element.getAttributeValue("Yvalues"));
        this.counts = new int[this.Xvalues][this.Yvalues];
        String string = element.getTextTrim();
        String[] stringArray = string.split(" |\n");
        int n = 0;
        for (int j = 0; j < this.Xvalues; ++j) {
            int n2 = 0;
            while (n2 < this.Yvalues) {
                while (stringArray[n].equals("")) {
                    ++n;
                }
                this.counts[j][n2] = Integer.parseInt(stringArray[n]);
                ++n2;
                ++n;
            }
        }
    }
}

