/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes;

import ai.machinelearning.bayes.BayesianModel;
import ai.machinelearning.bayes.TrainingInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;

public class FeatureSelection {
    public static int DEBUG = 0;

    public static double featureSetCrossValidationAccuracy(BayesianModel bayesianModel, List<int[]> list, List<Integer> list2, List<TrainingInstance> list3, List<UnitAction> list4, List<Integer> list5) throws Exception {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int[] nArray : list) {
            int[] nArray2 = new int[list5.size()];
            for (int j = 0; j < list5.size(); ++j) {
                nArray2[j] = nArray[list5.get(j)];
            }
            arrayList.add(nArray2);
        }
        double d = (Double)FeatureSelection.crossValidation((BayesianModel)bayesianModel, list, list2, list3, list4, (int)10).m_a;
        return d;
    }

    public static double featureGainRatio(List<int[]> list, List<Integer> list2, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (int j = 0; j < list.size(); ++j) {
            if (list.get(j)[n] >= n3) {
                n3 = list.get(j)[n] + 1;
            }
            if (list2.get(j) < n4) continue;
            n4 = list2.get(j) + 1;
        }
        int[] nArray = new int[n3];
        List[] listArray = new List[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            listArray[n2] = new ArrayList();
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            int n5;
            int n6 = n5 = list.get(n2)[n];
            nArray[n6] = nArray[n6] + 1;
            listArray[n5].add(list2.get(n2));
        }
        double d = FeatureSelection.entropy(list2, n4);
        double[] dArray = new double[n3];
        for (int j = 0; j < n3; ++j) {
            dArray[j] = nArray[j] > 0 ? FeatureSelection.entropy(listArray[j], n4) : 0.0;
        }
        double d2 = d;
        double d3 = 0.0;
        for (int j = 0; j < n3; ++j) {
            double d4 = (double)nArray[j] / (double)list.size();
            d2 -= d4 * dArray[j];
            if (nArray[j] <= 0) continue;
            d3 -= d4 * Math.log(d4) / Math.log(2.0);
        }
        double d5 = d3 > 0.0 ? d2 / d3 : 0.0;
        return d5;
    }

    public static double entropy(List<Integer> list, int n) {
        int[] nArray = new int[n];
        double d = 0.0;
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2;
            int n3 = n2 = iterator.next().intValue();
            nArray[n3] = nArray[n3] + 1;
            d += 1.0;
        }
        double d2 = 0.0;
        for (int j = 0; j < n; ++j) {
            double d3 = (double)nArray[j] / d;
            if (nArray[j] <= 0) continue;
            d2 += -d3 * Math.log(d3) / Math.log(2.0);
        }
        return d2;
    }

    public static Pair<Double, Double> crossValidation(BayesianModel bayesianModel, List<int[]> list, List<Integer> list2, List<TrainingInstance> list3, List<UnitAction> list4, int n) throws Exception {
        int n2;
        int n3;
        Random random = new Random();
        List[] listArray = new List[n];
        int n4 = list.get(0).length;
        int[] nArray = new int[n4];
        int n5 = 0;
        UnitTypeTable unitTypeTable = list3.get((int)0).gs.getUnitTypeTable();
        for (n3 = 0; n3 < n; ++n3) {
            listArray[n3] = new ArrayList();
        }
        for (n3 = 0; n3 < list.size(); ++n3) {
            int n6 = random.nextInt(n);
            listArray[n6].add(n3);
            for (int j = 0; j < n4; ++j) {
                if (list.get(n3)[j] < nArray[j]) continue;
                nArray[j] = list.get(n3)[j] + 1;
            }
            if (list2.get(n3) < n5) continue;
            n5 = list2.get(n3) + 1;
        }
        if (DEBUG >= 1) {
            System.out.println("Xsizes: " + Arrays.toString(nArray));
        }
        if (DEBUG >= 1) {
            System.out.println("Ysize: " + n5);
        }
        double[] dArray = new double[unitTypeTable.getUnitTypes().size()];
        double[] dArray2 = new double[unitTypeTable.getUnitTypes().size()];
        double[] dArray3 = new double[unitTypeTable.getUnitTypes().size()];
        for (int j = 0; j < n; ++j) {
            int n7;
            Object object;
            if (DEBUG >= 1) {
                System.out.println("Evaluating fold " + (j + 1) + "/" + n + ":");
            }
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<TrainingInstance> arrayList3 = new ArrayList<TrainingInstance>();
            ArrayList<int[]> arrayList4 = new ArrayList<int[]>();
            ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
            ArrayList<TrainingInstance> arrayList6 = new ArrayList<TrainingInstance>();
            for (int k = 0; k < n; ++k) {
                int n8;
                if (k == j) {
                    object = listArray[k].iterator();
                    while (object.hasNext()) {
                        n8 = (Integer)object.next();
                        arrayList4.add(list.get(n8));
                        arrayList5.add(list2.get(n8));
                        arrayList6.add(list3.get(n8));
                    }
                    continue;
                }
                object = listArray[k].iterator();
                while (object.hasNext()) {
                    n8 = (Integer)object.next();
                    arrayList.add(list.get(n8));
                    arrayList2.add(list2.get(n8));
                    arrayList3.add(list3.get(n8));
                }
            }
            if (DEBUG >= 1) {
                System.out.println("  training/test split is " + arrayList.size() + "/" + arrayList4.size());
            }
            bayesianModel.clearTraining();
            bayesianModel.train(arrayList, arrayList2, arrayList3);
            int[] nArray2 = new int[unitTypeTable.getUnitTypes().size()];
            object = new int[unitTypeTable.getUnitTypes().size()];
            double[] dArray4 = new double[unitTypeTable.getUnitTypes().size()];
            double d = 0.0;
            for (int k = 0; k < arrayList4.size(); ++k) {
                int n9;
                Unit unit = ((TrainingInstance)arrayList6.get((int)k)).u;
                List<UnitAction> list5 = unit.getUnitActions(((TrainingInstance)arrayList6.get((int)k)).gs);
                ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
                for (UnitAction unitAction : list5) {
                    if (unitAction.getType() == 5) {
                        unitAction = new UnitAction(5, unitAction.getLocationX() - unit.getX(), unitAction.getLocationY() - unit.getY());
                    }
                    if ((n9 = list4.indexOf(unitAction)) < 0) {
                        throw new Exception("Unknown action: " + unitAction);
                    }
                    arrayList7.add(n9);
                }
                if (list5.size() <= 1) continue;
                d += (double)list5.size();
                Object object2 = bayesianModel.predictDistribution((int[])arrayList4.get(k), (TrainingInstance)arrayList6.get(k));
                object2 = bayesianModel.filterByPossibleActionIndexes((double[])object2, arrayList7);
                int n10 = (Integer)arrayList5.get(k);
                if (!arrayList7.contains(n10)) {
                    System.out.println("Actual action in the dataset is not possible!");
                    continue;
                }
                n9 = -1;
                Collections.shuffle(list5);
                Iterator iterator = arrayList7.iterator();
                while (iterator.hasNext()) {
                    int n11 = (Integer)iterator.next();
                    if (n9 == -1) {
                        n9 = n11;
                        continue;
                    }
                    if (!(object2[n11] > object2[n9])) continue;
                    n9 = n11;
                }
                if (n9 == n10) {
                    int n12 = unit.getType().ID;
                    nArray2[n12] = nArray2[n12] + 1;
                }
                Object object3 = object;
                int n13 = unit.getType().ID;
                object3[n13] = object3[n13] + true;
                double d2 = Math.log((double)object2[n10]);
                if (Double.isInfinite(d2)) {
                    System.out.println(Arrays.toString((double[])object2));
                    System.out.println(arrayList7);
                    System.out.println(n10 + " : " + list4.get(n10));
                    System.exit(1);
                }
                int n14 = unit.getType().ID;
                dArray4[n14] = dArray4[n14] + d2;
            }
            double[] dArray5 = new double[unitTypeTable.getUnitTypes().size()];
            if (DEBUG >= 1) {
                System.out.println("Average possible actions: " + d / (double)arrayList4.size());
            }
            for (n7 = 0; n7 < unitTypeTable.getUnitTypes().size(); ++n7) {
                dArray5[n7] = (double)nArray2[n7] / (double)object[n7];
                if (DEBUG >= 1) {
                    System.out.println("Fold accuracy (" + unitTypeTable.getUnitTypes().get((int)n7).name + "): " + dArray5[n7] + "   (" + nArray2[n7] + "/" + (int)object[n7] + ")");
                }
                int n15 = n7;
                dArray[n15] = dArray[n15] + (double)nArray2[n7];
                int n16 = n7;
                dArray2[n16] = dArray2[n16] + (double)object[n7];
            }
            for (n7 = 0; n7 < unitTypeTable.getUnitTypes().size(); ++n7) {
                if (DEBUG >= 1) {
                    System.out.println("Fold loglikelihood (" + unitTypeTable.getUnitTypes().get((int)n7).name + "): " + dArray4[n7] + " (average: " + dArray4[n7] / (double)object[n7] + ")");
                }
                int n17 = n7;
                dArray3[n17] = dArray3[n17] + dArray4[n7];
            }
        }
        if (DEBUG >= 1) {
            System.out.println(" ---------- ");
        }
        double d = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 < unitTypeTable.getUnitTypes().size(); ++n2) {
            double d5 = dArray[n2] / dArray2[n2];
            if (DEBUG >= 1) {
                System.out.println("Final accuracy (" + unitTypeTable.getUnitTypes().get((int)n2).name + "): " + d5 + "   (" + dArray[n2] + "/" + dArray2[n2] + ")");
            }
            d += dArray[n2];
            d3 += dArray2[n2];
        }
        for (n2 = 0; n2 < unitTypeTable.getUnitTypes().size(); ++n2) {
            if (DEBUG >= 1) {
                System.out.println("Final loglikelihood (" + unitTypeTable.getUnitTypes().get((int)n2).name + "): " + dArray3[n2] + " (average: " + dArray3[n2] / dArray2[n2] + ")");
            }
            d4 += dArray3[n2];
        }
        double d6 = d / d3;
        if (DEBUG >= 1) {
            System.out.println("Final accuracy: " + d6);
        }
        if (DEBUG >= 1) {
            System.out.println("Final loglikelihood: " + d4 + " (average " + d4 / d3 + ")");
        }
        return new Pair<Double, Double>(d6, d4 / d3);
    }
}

