/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes.featuregeneration;

import ai.machinelearning.bayes.TrainingInstance;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.jdom.input.SAXBuilder;
import rts.GameState;
import rts.Trace;
import rts.TraceEntry;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public abstract class FeatureGenerator {
    public static List<Trace> loadTraces(String string) throws Exception {
        ArrayList<Trace> arrayList = new ArrayList<Trace>();
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            String string2 = file2.getAbsolutePath();
            if (!string2.endsWith(".xml")) continue;
            Trace trace = new Trace(new SAXBuilder().build(string2).getRootElement());
            arrayList.add(trace);
        }
        return arrayList;
    }

    public static List<TrainingInstance> generateInstances(List<Trace> list) throws Exception {
        ArrayList<TrainingInstance> arrayList = new ArrayList<TrainingInstance>();
        for (Trace trace : list) {
            GameState gameState = trace.getGameStateAtCycle(trace.getLength());
            int n = gameState.winner();
            for (TraceEntry traceEntry : trace.getEntries()) {
                GameState gameState2 = trace.getGameStateAtCycle(traceEntry.getTime());
                for (Pair<Unit, UnitAction> pair : traceEntry.getActions()) {
                    if (((Unit)pair.m_a).getUnitActions(gameState2).size() <= 1 || ((Unit)pair.m_a).getPlayer() != n) continue;
                    TrainingInstance trainingInstance = new TrainingInstance(gameState2, ((Unit)pair.m_a).getID(), (UnitAction)pair.m_b);
                    arrayList.add(trainingInstance);
                }
            }
        }
        return arrayList;
    }

    public static void writeARFFHeader(List<List<Object>> list, List<String> list2, String string, FileWriter fileWriter) throws Exception {
        fileWriter.write("@relation " + string + "\n");
        int n = list.get(0).size();
        for (int j = 0; j < n; ++j) {
            List<Object> list3 = list.get(0);
            if (list3.get(j) instanceof String) {
                List<Object> list42;
                ArrayList<String> object = new ArrayList<String>();
                for (List<Object> list42 : list) {
                    if (object.contains(list42.get(j))) continue;
                    object.add((String)list42.get(j));
                }
                fileWriter.write("@attribute f" + j + " {");
                boolean bl = true;
                list42 = object.iterator();
                while (list42.hasNext()) {
                    boolean bl2;
                    String string2 = (String)list42.next();
                    if (bl2) {
                        fileWriter.write("'" + string2 + "'");
                        bl2 = false;
                        continue;
                    }
                    fileWriter.write(",'" + string2 + "'");
                }
                fileWriter.write("}\n");
                continue;
            }
            fileWriter.write("@attribute f" + j + " numeric\n");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list2) {
            if (arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        fileWriter.write("@attribute class {");
        boolean bl = true;
        for (String string4 : arrayList) {
            if (bl) {
                fileWriter.write("'" + string4 + "'");
                bl = false;
                continue;
            }
            fileWriter.write(",'" + string4 + "'");
        }
        fileWriter.write("}\n");
        fileWriter.write("@data\n");
    }

    public static void translateToARFF(List<Object> list, String string, FileWriter fileWriter) throws Exception {
        for (Object object : list) {
            if (object instanceof String) {
                fileWriter.write("'" + object + "'");
            } else {
                fileWriter.write(object.toString());
            }
            fileWriter.write(",");
        }
        fileWriter.write("'" + string + "'\n");
    }

    public int[] generateFeaturesAsArray(TrainingInstance trainingInstance) {
        List<Object> list = this.generateFeatures(trainingInstance);
        int[] nArray = new int[list.size()];
        for (int j = 0; j < list.size(); ++j) {
            nArray[j] = (Integer)list.get(j);
        }
        return nArray;
    }

    public abstract List<Object> generateFeatures(TrainingInstance var1);
}

