/*
 * Decompiled with CFR 0.152.
 */
package ai.machinelearning.bayes.featuregeneration;

import ai.machinelearning.bayes.TrainingInstance;
import ai.machinelearning.bayes.featuregeneration.FeatureGenerator;
import java.util.ArrayList;
import java.util.List;
import rts.PhysicalGameState;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class FeatureGeneratorComplex
extends FeatureGenerator {
    @Override
    public List<Object> generateFeatures(TrainingInstance trainingInstance) {
        PhysicalGameState physicalGameState = trainingInstance.gs.getPhysicalGameState();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = trainingInstance.u.getPlayer();
        UnitTypeTable unitTypeTable = trainingInstance.gs.getUnitTypeTable();
        arrayList.add(trainingInstance.gs.getPlayer(n).getResources());
        arrayList.add(trainingInstance.u.getResources());
        arrayList.add(trainingInstance.u.getHitPoints());
        arrayList.add(trainingInstance.u.getAttackRange());
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() == -1) continue;
            if (unit.getPlayer() == n) {
                d += (double)unit.getX();
                d2 += (double)unit.getY();
                ++n2;
                if (!unit.getType().name.equals("Barracks")) continue;
                n4 = 1;
                continue;
            }
            d3 += (double)unit.getX();
            d4 += (double)unit.getY();
            ++n3;
        }
        d /= (double)n2;
        d2 /= (double)n2;
        d3 /= (double)n3;
        d4 /= (double)n3;
        double d5 = Math.atan2(d -= (double)trainingInstance.u.getX(), d2 -= (double)trainingInstance.u.getY());
        double d6 = Math.atan2(d3 -= (double)trainingInstance.u.getX(), d4 -= (double)trainingInstance.u.getY());
        double d7 = 0.7853981633974483;
        d5 += d7 / 2.0;
        d6 += d7 / 2.0;
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        if (d6 < 0.0) {
            d6 += Math.PI * 2;
        }
        int n5 = (int)(d5 / d7);
        int n6 = (int)(d6 / d7);
        arrayList.add(n5);
        arrayList.add(n6);
        arrayList.add(n4);
        int n7 = arrayList.size();
        int[] nArray = new int[]{0, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -3, -2, -1, 1, 2, 3, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, 0};
        int[] nArray2 = new int[]{-3, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3};
        int n8 = trainingInstance.u.getX();
        int n9 = trainingInstance.u.getY();
        int n10 = physicalGameState.getWidth();
        int n11 = physicalGameState.getHeight();
        int n12 = unitTypeTable.getUnitTypes().size();
        for (int j = 0; j < nArray.length; ++j) {
            int n13 = n8 - nArray[j];
            int n14 = n9 - nArray2[j];
            Unit unit = physicalGameState.getUnitAt(n13, n14);
            if (unit != null) {
                if (unit.getPlayer() == n) {
                    arrayList.add(3 + unit.getType().ID);
                    continue;
                }
                arrayList.add(3 + n12 + unit.getType().ID);
                continue;
            }
            if (n13 < 0 || n14 < 0 || n13 >= n10 || n14 >= n11) {
                arrayList.add(2);
                continue;
            }
            if (physicalGameState.getTerrain(n13, n14) == 0) {
                if (trainingInstance.gs.free(n13, n14)) {
                    arrayList.add(0);
                    continue;
                }
                arrayList.add(1);
                continue;
            }
            arrayList.add(2);
        }
        arrayList.add((Integer)arrayList.get(n7 + 8) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 19));
        arrayList.add((Integer)arrayList.get(n7 + 13) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 14));
        arrayList.add((Integer)arrayList.get(n7 + 8) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 14));
        arrayList.add((Integer)arrayList.get(n7 + 14) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 19));
        arrayList.add((Integer)arrayList.get(n7 + 19) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 13));
        arrayList.add((Integer)arrayList.get(n7 + 13) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 8));
        arrayList.add((Integer)arrayList.get(1) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 8));
        arrayList.add((Integer)arrayList.get(1) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 13));
        arrayList.add((Integer)arrayList.get(1) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 14));
        arrayList.add((Integer)arrayList.get(1) * (n12 * 2 + 3) + (Integer)arrayList.get(n7 + 19));
        return arrayList;
    }
}

