/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts;

import ai.evaluation.EvaluationFunction;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;

public abstract class MCTSNode {
    public static Random r = new Random();
    public int type;
    public MCTSNode parent = null;
    public GameState gs = null;
    public int depth = 0;
    public List<PlayerAction> actions = null;
    public List<MCTSNode> children = null;
    public double accum_evaluation = 0.0;
    public int visit_count = 0;
    public int creation_ID = -1;
    public int highest_children_creation_ID = -1;
    public int best_child_so_far = -1;

    public void showNode(int n, int n2, EvaluationFunction evaluationFunction) {
        if (this.children != null) {
            for (int j = 0; j < this.children.size(); ++j) {
                MCTSNode mCTSNode = this.children.get(j);
                for (int k = 0; k < n; ++k) {
                    System.out.print("    ");
                }
                System.out.println("child explored " + mCTSNode.visit_count + " (EF: " + evaluationFunction.evaluate(0, 1, mCTSNode.gs) + ") Avg evaluation: " + mCTSNode.accum_evaluation / (double)mCTSNode.visit_count + " : " + this.actions.get(j));
                if (n >= n2) continue;
                mCTSNode.showNode(n + 1, n2, evaluationFunction);
            }
        }
    }
}

