/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.believestatemcts;

import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.units.Unit;

public interface AIWithBelieveState {
    public void setInitialBelieveState(int var1, GameState var2, PartiallyObservableGameState var3);

    public List<Unit> getBelieveUnits();

    public static double getJaccardIndex(int n, GameState gameState, PartiallyObservableGameState partiallyObservableGameState, List<Unit> list) {
        double d = gameState.getPhysicalGameState().getWidth() + gameState.getPhysicalGameState().getHeight() + 1;
        double d2 = 0.0;
        double d3 = list.size();
        double d4 = 0.0;
        boolean[] blArray = new boolean[list.size()];
        for (Unit unit : gameState.getUnits()) {
            if (unit.getPlayer() != n) continue;
            d4 += 1.0;
            if (partiallyObservableGameState.observable(unit.getX(), unit.getY())) {
                d2 += 1.0;
                d3 += 1.0;
                continue;
            }
            Object object = null;
            double d5 = d;
            int n2 = -1;
            for (int j = 0; j < list.size(); ++j) {
                double d6;
                if (blArray[j]) continue;
                Unit unit2 = list.get(j);
                if (unit2.getID() == unit.getID()) {
                    n2 = j;
                    object = unit2;
                    d5 = Math.abs(unit2.getX() - unit.getX()) + Math.abs(unit2.getY() - unit.getY());
                    break;
                }
                if (unit2.getType() != unit.getType() || !(d5 > (d6 = (double)(Math.abs(unit2.getX() - unit.getX()) + Math.abs(unit2.getY() - unit.getY()))))) continue;
                n2 = j;
                object = unit2;
                d5 = d6;
            }
            if (object == null) continue;
            blArray[n2] = true;
            double d7 = 1.0 - d5 / d;
            d2 += d7;
        }
        double d8 = d2 / (d3 + d4 - d2);
        if (d8 > 1.0) {
            System.out.println("### Jaccard Index bigger than 1.0 ###");
            System.out.println(d2 + " / " + d3 + " + " + d4 + " - " + d2 + "=" + d8);
            System.out.println(gameState.getPhysicalGameState());
            System.out.println(partiallyObservableGameState.getPhysicalGameState());
            for (Unit unit : gameState.getUnits()) {
                if (unit.getPlayer() != n) continue;
                System.out.println("Adding to B " + unit);
                if (!partiallyObservableGameState.observable(unit.getX(), unit.getY())) continue;
                System.out.println("Adding to A " + unit);
            }
        }
        return d8;
    }
}

