/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.believestatemcts;

import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import ai.mcts.MCTSNode;
import ai.mcts.believestatemcts.AIWithBelieveState;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class BS1_NaiveMCTS
extends NaiveMCTS
implements AIWithBelieveState {
    GameState initialGameState = null;
    List<Unit> lastKnownPosition = new LinkedList<Unit>();

    public BS1_NaiveMCTS(UnitTypeTable unitTypeTable) {
        super(unitTypeTable);
    }

    public BS1_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, f4, f5, f6, aI, evaluationFunction, bl);
    }

    public BS1_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, aI, evaluationFunction, bl);
    }

    public BS1_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, int n5, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, n5, aI, evaluationFunction, bl);
    }

    @Override
    public AI clone() {
        return new BS1_NaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.epsilon_l, this.discount_l, this.epsilon_g, this.discount_g, this.epsilon_0, this.discount_0, this.playoutPolicy, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState);
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        if (this.initialGameState != null && gameState.getTime() == 0) {
            this.setInitialBelieveState(n, this.initialGameState.clone(), new PartiallyObservableGameState(this.initialGameState, n));
        }
        if (gameState instanceof PartiallyObservableGameState) {
            gameState = this.sampleWorld(this.player, (PartiallyObservableGameState)gameState);
        }
        this.player = n;
        this.current_iteration = 0;
        this.tree = new NaiveMCTSNode(this.player, 1 - this.player, gameState, null, this.ef.upperBound(gameState), this.current_iteration++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = this.tree.moveGenerator == null ? 0L : Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gameState;
        this.epsilon_l = this.initial_epsilon_l;
        this.epsilon_g = this.initial_epsilon_g;
        this.epsilon_0 = this.initial_epsilon_0;
    }

    @Override
    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        if (this.getTree().children == null) {
            return -1;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = -1;
        for (int j = 0; j < this.getTree().children.size(); ++j) {
            NaiveMCTSNode naiveMCTSNode = (NaiveMCTSNode)this.getTree().children.get(j);
            if (naiveMCTSNode.visit_count > n) {
                arrayList.clear();
                arrayList.add(j);
                n = naiveMCTSNode.visit_count;
                continue;
            }
            if (naiveMCTSNode.visit_count <= n) continue;
            arrayList.add(j);
        }
        if (arrayList.isEmpty()) {
            return -1;
        }
        if (arrayList.size() == 1) {
            return (Integer)arrayList.get(0);
        }
        return MCTSNode.r.nextInt(arrayList.size());
    }

    @Override
    public void reset() {
        this.initialGameState = null;
    }

    @Override
    public void preGameAnalysis(GameState gameState, long l) throws Exception {
        this.initialGameState = gameState.clone();
    }

    @Override
    public void setInitialBelieveState(int n, GameState gameState, PartiallyObservableGameState partiallyObservableGameState) {
        int n2 = 1 - n;
        for (Unit unit : gameState.getUnits()) {
            if (unit.getPlayer() != n2 || unit.getType().canMove || partiallyObservableGameState.observable(unit.getX(), unit.getY())) continue;
            this.lastKnownPosition.add(unit);
        }
    }

    @Override
    public List<Unit> getBelieveUnits() {
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        linkedList.addAll(this.lastKnownPosition);
        return linkedList;
    }

    public GameState sampleWorld(int n, PartiallyObservableGameState partiallyObservableGameState) {
        PartiallyObservableGameState partiallyObservableGameState2 = partiallyObservableGameState.clone();
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Unit unit : this.lastKnownPosition) {
            if (!partiallyObservableGameState.observable(unit.getX(), unit.getY())) {
                partiallyObservableGameState2.getPhysicalGameState().addUnit(unit);
                continue;
            }
            Unit unit2 = partiallyObservableGameState2.getPhysicalGameState().getUnitAt(unit.getX(), unit.getY());
            if (unit2 != null && unit.getType() == unit2.getType()) continue;
            arrayList.add(unit);
        }
        this.lastKnownPosition.removeAll(arrayList);
        return partiallyObservableGameState2;
    }
}

