/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.believestatemcts;

import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import ai.mcts.believestatemcts.AIWithBelieveState;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PlayerAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class BS2_NaiveMCTS
extends NaiveMCTS
implements AIWithBelieveState {
    GameState initialGameState = null;
    List<Unit> lastKnownPosition = new LinkedList<Unit>();
    PartiallyObservableGameState lastObservedGame = null;

    public BS2_NaiveMCTS(UnitTypeTable unitTypeTable) {
        super(unitTypeTable);
    }

    public BS2_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, f4, f5, f6, aI, evaluationFunction, bl);
    }

    public BS2_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, aI, evaluationFunction, bl);
    }

    public BS2_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, int n5, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, n5, aI, evaluationFunction, bl);
    }

    @Override
    public AI clone() {
        return new BS2_NaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.epsilon_l, this.discount_l, this.epsilon_g, this.discount_g, this.epsilon_0, this.discount_0, this.playoutPolicy, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState);
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        if (this.initialGameState != null && gameState.getTime() == 0) {
            this.setInitialBelieveState(n, this.initialGameState.clone(), new PartiallyObservableGameState(this.initialGameState, n));
        }
        if (gameState instanceof PartiallyObservableGameState) {
            this.updateBelieveState(this.player, (PartiallyObservableGameState)gameState);
            gameState = this.sampleWorld(this.player, (PartiallyObservableGameState)gameState);
        }
        this.player = n;
        this.current_iteration = 0;
        this.tree = new NaiveMCTSNode(this.player, 1 - this.player, gameState, null, this.ef.upperBound(gameState), this.current_iteration++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = this.tree.moveGenerator == null ? 0L : Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gameState;
        this.epsilon_l = this.initial_epsilon_l;
        this.epsilon_g = this.initial_epsilon_g;
        this.epsilon_0 = this.initial_epsilon_0;
    }

    @Override
    public void reset() {
        this.initialGameState = null;
    }

    @Override
    public void preGameAnalysis(GameState gameState, long l) throws Exception {
        this.initialGameState = gameState.clone();
    }

    @Override
    public void setInitialBelieveState(int n, GameState gameState, PartiallyObservableGameState partiallyObservableGameState) {
        int n2 = 1 - n;
        for (Unit unit : gameState.getUnits()) {
            if (unit.getPlayer() != n2 || partiallyObservableGameState.observable(unit.getX(), unit.getY())) continue;
            this.lastKnownPosition.add(unit);
        }
        this.lastObservedGame = partiallyObservableGameState;
    }

    @Override
    public List<Unit> getBelieveUnits() {
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        linkedList.addAll(this.lastKnownPosition);
        return linkedList;
    }

    public GameState sampleWorld(int n, PartiallyObservableGameState partiallyObservableGameState) {
        PartiallyObservableGameState partiallyObservableGameState2 = partiallyObservableGameState.clone();
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Unit unit : this.lastKnownPosition) {
            if (partiallyObservableGameState.observable(unit.getX(), unit.getY())) {
                arrayList.add(unit);
                continue;
            }
            partiallyObservableGameState2.getPhysicalGameState().addUnit(unit);
        }
        this.lastKnownPosition.removeAll(arrayList);
        return partiallyObservableGameState2;
    }

    public void updateBelieveState(int n, PartiallyObservableGameState partiallyObservableGameState) {
        int n2;
        Object object;
        int n3 = 1 - n;
        for (Unit unit : this.lastObservedGame.getUnits()) {
            if (unit.getPlayer() != n3 || !partiallyObservableGameState.free(unit.getX(), unit.getY())) continue;
            object = this.lastObservedGame.getActionAssignment(unit);
            if (object != null && ((UnitActionAssignment)object).action.getType() == 1) {
                int n4 = 0;
                n2 = 0;
                if (((UnitActionAssignment)object).action.getDirection() == 0) {
                    n2 = -1;
                }
                if (((UnitActionAssignment)object).action.getDirection() == 1) {
                    n4 = 1;
                }
                if (((UnitActionAssignment)object).action.getDirection() == 2) {
                    n2 = 1;
                }
                if (((UnitActionAssignment)object).action.getDirection() == 3) {
                    n4 = -1;
                }
                if (partiallyObservableGameState.observable(unit.getX() + n4, unit.getY() + n2)) continue;
                this.lastKnownPosition.add(unit.clone());
                continue;
            }
            if (partiallyObservableGameState.observable(unit.getX(), unit.getY()) || this.wasUnderAttack(unit)) continue;
            this.lastKnownPosition.add(unit.clone());
        }
        block1: for (Unit unit : partiallyObservableGameState.getUnits()) {
            if (unit.getPlayer() != n3) continue;
            object = this.lastKnownPosition.iterator();
            while (object.hasNext()) {
                Unit unit2 = (Unit)object.next();
                if (unit2.getID() != unit.getID()) continue;
                this.lastKnownPosition.remove(unit2);
                break;
            }
            if ((object = partiallyObservableGameState.getActionAssignment(unit)) == null || ((UnitActionAssignment)object).action.getType() != 1 && ((UnitActionAssignment)object).action.getType() != 4) continue;
            int n5 = unit.getX();
            n2 = unit.getY();
            if (((UnitActionAssignment)object).action.getDirection() == 0) {
                --n2;
            }
            if (((UnitActionAssignment)object).action.getDirection() == 1) {
                ++n5;
            }
            if (((UnitActionAssignment)object).action.getDirection() == 2) {
                ++n2;
            }
            if (((UnitActionAssignment)object).action.getDirection() == 3) {
                --n5;
            }
            for (Unit unit3 : this.lastKnownPosition) {
                if (unit3.getX() != n5 || unit3.getY() != n2) continue;
                this.lastKnownPosition.remove(unit3);
                continue block1;
            }
        }
        this.lastObservedGame = partiallyObservableGameState.clone();
    }

    public boolean wasUnderAttack(Unit unit) {
        for (UnitActionAssignment unitActionAssignment : this.lastObservedGame.getUnitActions().values()) {
            if (unitActionAssignment.action.getType() != 5 || unitActionAssignment.action.getLocationX() != unit.getX() || unitActionAssignment.action.getLocationY() != unit.getY()) continue;
            return true;
        }
        return false;
    }
}

