/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.believestatemcts;

import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import ai.mcts.MCTSNode;
import ai.mcts.believestatemcts.AIWithBelieveState;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PlayerAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class BS3_NaiveMCTS
extends NaiveMCTS
implements AIWithBelieveState {
    GameState initialGameState = null;
    List<Unit> lastKnownPosition = new LinkedList<Unit>();
    List<Unit> inferedUnits = new LinkedList<Unit>();
    PartiallyObservableGameState lastObservedGame = null;
    boolean[] typeSeen;

    public BS3_NaiveMCTS(UnitTypeTable unitTypeTable) {
        super(unitTypeTable);
    }

    public BS3_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, f4, f5, f6, aI, evaluationFunction, bl);
    }

    public BS3_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, aI, evaluationFunction, bl);
    }

    public BS3_NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, int n5, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2, n3, n4, f, f2, f3, n5, aI, evaluationFunction, bl);
    }

    @Override
    public AI clone() {
        return new BS3_NaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.epsilon_l, this.discount_l, this.epsilon_g, this.discount_g, this.epsilon_0, this.discount_0, this.playoutPolicy, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState);
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        if (this.initialGameState != null && gameState.getTime() == 0) {
            this.setInitialBelieveState(n, this.initialGameState.clone(), new PartiallyObservableGameState(this.initialGameState, n));
        }
        if (gameState instanceof PartiallyObservableGameState) {
            this.updateBelieveState(this.player, (PartiallyObservableGameState)gameState);
            gameState = this.sampleWorld(this.player, (PartiallyObservableGameState)gameState);
        }
        this.player = n;
        this.current_iteration = 0;
        this.tree = new NaiveMCTSNode(this.player, 1 - this.player, gameState, null, this.ef.upperBound(gameState), this.current_iteration++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = this.tree.moveGenerator == null ? 0L : Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gameState;
        this.epsilon_l = this.initial_epsilon_l;
        this.epsilon_g = this.initial_epsilon_g;
        this.epsilon_0 = this.initial_epsilon_0;
    }

    @Override
    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        if (this.getTree().children == null) {
            return -1;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = -1;
        for (int j = 0; j < this.getTree().children.size(); ++j) {
            NaiveMCTSNode naiveMCTSNode = (NaiveMCTSNode)this.getTree().children.get(j);
            if (naiveMCTSNode.visit_count > n) {
                arrayList.clear();
                arrayList.add(j);
                n = naiveMCTSNode.visit_count;
                continue;
            }
            if (naiveMCTSNode.visit_count <= n) continue;
            arrayList.add(j);
        }
        if (arrayList.isEmpty()) {
            return -1;
        }
        if (arrayList.size() == 1) {
            return (Integer)arrayList.get(0);
        }
        System.out.println("Random action from " + arrayList.size());
        return MCTSNode.r.nextInt(arrayList.size());
    }

    @Override
    public void reset() {
        this.initialGameState = null;
    }

    @Override
    public void preGameAnalysis(GameState gameState, long l) throws Exception {
        this.initialGameState = gameState.clone();
    }

    @Override
    public void setInitialBelieveState(int n, GameState gameState, PartiallyObservableGameState partiallyObservableGameState) {
        int n2 = 1 - n;
        this.typeSeen = new boolean[gameState.getUnitTypeTable().getUnitTypes().size()];
        for (Unit unit : gameState.getUnits()) {
            if (unit.getPlayer() != n2 || partiallyObservableGameState.observable(unit.getX(), unit.getY())) continue;
            this.lastKnownPosition.add(unit.clone());
            this.typeSeen[unit.getType().ID] = true;
        }
        this.lastObservedGame = partiallyObservableGameState.clone();
    }

    @Override
    public List<Unit> getBelieveUnits() {
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        linkedList.addAll(this.lastKnownPosition);
        linkedList.addAll(this.inferedUnits);
        return linkedList;
    }

    public GameState sampleWorld(int n, PartiallyObservableGameState partiallyObservableGameState) {
        boolean bl;
        PartiallyObservableGameState partiallyObservableGameState2 = partiallyObservableGameState.clone();
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Unit unit : this.lastKnownPosition) {
            bl = true;
            if (partiallyObservableGameState.observable(unit.getX(), unit.getY())) {
                bl = this.getClosestNotObservableLocationNear(unit.getX(), unit.getY(), partiallyObservableGameState, unit);
            }
            if (bl) {
                try {
                    partiallyObservableGameState2.getPhysicalGameState().addUnit(unit);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("IllegalArgumentException: " + illegalArgumentException.getMessage());
                    System.err.println(partiallyObservableGameState2.getPhysicalGameState());
                    System.err.println("adding unit: " + unit);
                    System.err.println("Last known unit:");
                    System.err.println(this.lastKnownPosition);
                }
                continue;
            }
            arrayList.add(unit);
        }
        this.lastKnownPosition.removeAll(arrayList);
        arrayList.clear();
        for (Unit unit : this.inferedUnits) {
            bl = true;
            if (partiallyObservableGameState.observable(unit.getX(), unit.getY())) {
                this.getClosestNotObservableLocationNear(unit.getX(), unit.getY(), partiallyObservableGameState, unit);
            }
            if (bl) {
                try {
                    partiallyObservableGameState2.getPhysicalGameState().addUnit(unit);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("IllegalArgumentException: " + illegalArgumentException.getMessage());
                    System.err.println(partiallyObservableGameState2.getPhysicalGameState());
                    System.err.println("adding unit: " + unit);
                    System.err.println("Infered units:");
                    System.err.println(this.inferedUnits);
                }
                continue;
            }
            arrayList.add(unit);
        }
        this.inferedUnits.removeAll(arrayList);
        return partiallyObservableGameState2;
    }

    public void updateBelieveState(int n, PartiallyObservableGameState partiallyObservableGameState) {
        Object object;
        int n2 = 1 - n;
        for (Unit unit : this.lastObservedGame.getUnits()) {
            if (unit.getPlayer() != n2 || !partiallyObservableGameState.free(unit.getX(), unit.getY())) continue;
            object = this.lastObservedGame.getActionAssignment(unit);
            if (object != null && ((UnitActionAssignment)object).action.getType() == 1) {
                int n3 = 0;
                int n4 = 0;
                if (((UnitActionAssignment)object).action.getDirection() == 0) {
                    n4 = -1;
                }
                if (((UnitActionAssignment)object).action.getDirection() == 1) {
                    n3 = 1;
                }
                if (((UnitActionAssignment)object).action.getDirection() == 2) {
                    n4 = 1;
                }
                if (((UnitActionAssignment)object).action.getDirection() == 3) {
                    n3 = -1;
                }
                if (partiallyObservableGameState.observable(unit.getX() + n3, unit.getY() + n4)) continue;
                this.lastKnownPosition.add(unit.clone());
                continue;
            }
            if (partiallyObservableGameState.observable(unit.getX(), unit.getY()) || this.wasUnderAttack(unit)) continue;
            this.lastKnownPosition.add(unit.clone());
        }
        block1: for (Unit unit : partiallyObservableGameState.getUnits()) {
            boolean bl;
            Object object2;
            if (unit.getPlayer() != n2) continue;
            if (!this.typeSeen[unit.getType().ID]) {
                this.typeSeen[unit.getType().ID] = true;
                object = unit.getType().producedBy.get(0);
                if (!this.typeSeen[((UnitType)object).ID]) {
                    object2 = new Unit(n2, (UnitType)object, 0, 0, 0);
                    boolean bl2 = this.getClosestNotObservableLocationNear(unit.getX(), unit.getY(), partiallyObservableGameState, (Unit)object2);
                    if (bl2) {
                        this.inferedUnits.add((Unit)object2);
                    }
                }
            }
            object = new ArrayList();
            object2 = this.inferedUnits.iterator();
            while (object2.hasNext()) {
                Unit unit2 = object2.next();
                if (unit.getType() != unit2.getType()) continue;
                object.add(unit2);
            }
            this.inferedUnits.removeAll((Collection<?>)object);
            if (!this.lastObservedGame.observable(unit.getX(), unit.getY()) || !this.wasVisibleOpponentMovingTo(n2, unit.getX(), unit.getY())) {
                object2 = null;
                for (Unit unit3 : this.lastKnownPosition) {
                    if (unit3.getID() != unit.getID()) continue;
                    object2 = unit3;
                    break;
                }
                if (object2 != null) {
                    this.lastKnownPosition.remove(object2);
                }
            }
            if ((object2 = partiallyObservableGameState.getActionAssignment(unit)) == null || ((UnitActionAssignment)object2).action.getType() != 1 && ((UnitActionAssignment)object2).action.getType() != 4) continue;
            int n5 = unit.getX();
            int n6 = unit.getY();
            if (((UnitActionAssignment)object2).action.getDirection() == 0) {
                --n6;
            }
            if (((UnitActionAssignment)object2).action.getDirection() == 1) {
                ++n5;
            }
            if (((UnitActionAssignment)object2).action.getDirection() == 2) {
                ++n6;
            }
            if (((UnitActionAssignment)object2).action.getDirection() == 3) {
                --n5;
            }
            for (Unit unit4 : this.lastKnownPosition) {
                if (unit4.getX() != n5 || unit4.getY() != n6) continue;
                bl = this.getClosestNotObservableLocationNear(unit4.getX(), unit4.getY(), partiallyObservableGameState, unit4);
                if (bl) break;
                this.lastKnownPosition.remove(unit4);
                break;
            }
            for (Unit unit4 : this.inferedUnits) {
                if (unit4.getX() != n5 || unit4.getY() != n6) continue;
                bl = this.getClosestNotObservableLocationNear(unit4.getX(), unit4.getY(), partiallyObservableGameState, unit4);
                if (bl) continue block1;
                this.inferedUnits.remove(unit4);
                continue block1;
            }
        }
        this.lastObservedGame = partiallyObservableGameState.clone();
    }

    public boolean wasVisibleOpponentMovingTo(int n, int n2, int n3) {
        if (!this.lastObservedGame.free(n2, n3)) {
            return true;
        }
        for (Unit unit : this.lastObservedGame.getUnits()) {
            UnitActionAssignment unitActionAssignment;
            if (unit.getPlayer() != n || (unitActionAssignment = this.lastObservedGame.getActionAssignment(unit)) == null || unitActionAssignment.action.getType() != 1) continue;
            int n4 = 0;
            int n5 = 0;
            if (unitActionAssignment.action.getDirection() == 0) {
                n5 = -1;
            }
            if (unitActionAssignment.action.getDirection() == 1) {
                n4 = 1;
            }
            if (unitActionAssignment.action.getDirection() == 2) {
                n5 = 1;
            }
            if (unitActionAssignment.action.getDirection() == 3) {
                n4 = -1;
            }
            if (unit.getX() + n4 != n2 || unit.getY() + n5 != n3) continue;
            return true;
        }
        return false;
    }

    public boolean wasUnderAttack(Unit unit) {
        for (UnitActionAssignment unitActionAssignment : this.lastObservedGame.getUnitActions().values()) {
            if (unitActionAssignment.action.getType() != 5 || unitActionAssignment.action.getLocationX() != unit.getX() || unitActionAssignment.action.getLocationY() != unit.getY()) continue;
            return true;
        }
        return false;
    }

    public boolean getClosestNotObservableLocationNear(int n, int n2, PartiallyObservableGameState partiallyObservableGameState, Unit unit) {
        int n3 = n;
        int n4 = n2;
        int n5 = 1;
        int n6 = 0;
        boolean bl = true;
        int n7 = 0;
        int n8 = 1;
        int n9 = Math.max(partiallyObservableGameState.getPhysicalGameState().getWidth(), partiallyObservableGameState.getPhysicalGameState().getHeight());
        while (n5 < n9) {
            if (n3 >= 0 && n3 < partiallyObservableGameState.getPhysicalGameState().getWidth() && n4 >= 0 && n4 < partiallyObservableGameState.getPhysicalGameState().getHeight() && !partiallyObservableGameState.observable(n3, n4) && partiallyObservableGameState.free(n3, n4) && this.believeFree(n3, n4)) {
                unit.setX(n3);
                unit.setY(n4);
                return true;
            }
            n3 += n7;
            n4 += n8;
            if (++n6 != n5) continue;
            n6 = 0;
            if (!bl) {
                ++n5;
            }
            boolean bl2 = bl = !bl;
            if (n7 == 0) {
                n7 = n8;
                n8 = 0;
                continue;
            }
            n8 = -n7;
            n7 = 0;
        }
        return false;
    }

    public boolean believeFree(int n, int n2) {
        for (Unit unit : this.lastKnownPosition) {
            if (unit.getX() != n || unit.getY() != n2) continue;
            return false;
        }
        for (Unit unit : this.inferedUnits) {
            if (unit.getX() != n || unit.getY() != n2) continue;
            return false;
        }
        return true;
    }
}

