/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.informedmcts;

import ai.mcts.MCTSNode;
import ai.mcts.informedmcts.InformedUnitActionTableEntry;
import ai.stochastic.UnitActionProbabilityDistribution;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;
import util.Sampler;

public class InformedNaiveMCTSNode
extends MCTSNode {
    public static final int E_GREEDY = 0;
    public static final int UCB1 = 1;
    public static int DEBUG = 0;
    public static float C = 0.05f;
    boolean hasMoreActions = true;
    public PlayerActionGenerator moveGenerator = null;
    HashMap<BigInteger, InformedNaiveMCTSNode> childrenMap = new LinkedHashMap<BigInteger, InformedNaiveMCTSNode>();
    public List<InformedUnitActionTableEntry> unitActionTable = null;
    double evaluation_bound;
    public BigInteger[] multipliers;
    UnitActionProbabilityDistribution model = null;

    public InformedNaiveMCTSNode(int n, int n2, GameState gameState, UnitActionProbabilityDistribution unitActionProbabilityDistribution, InformedNaiveMCTSNode informedNaiveMCTSNode, double d, int n3) throws Exception {
        this.parent = informedNaiveMCTSNode;
        this.gs = gameState;
        this.model = unitActionProbabilityDistribution;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = d;
        this.creation_ID = n3;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(n) || this.gs.canExecuteAnyAction(n2))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(n)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(this.gs, n);
            this.actions = new ArrayList();
            this.children = new ArrayList();
            this.unitActionTable = new LinkedList<InformedUnitActionTableEntry>();
            this.multipliers = new BigInteger[this.moveGenerator.getChoices().size()];
            BigInteger bigInteger = BigInteger.ONE;
            int n4 = 0;
            for (Pair<Unit, List<UnitAction>> pair : this.moveGenerator.getChoices()) {
                double[] dArray = this.model.predictDistribution((Unit)pair.m_a, this.gs, (List)pair.m_b);
                InformedUnitActionTableEntry informedUnitActionTableEntry = new InformedUnitActionTableEntry((Unit)pair.m_a, (List)pair.m_b, dArray);
                this.unitActionTable.add(informedUnitActionTableEntry);
                this.multipliers[n4] = bigInteger;
                bigInteger = bigInteger.multiply(BigInteger.valueOf(informedUnitActionTableEntry.nactions));
                ++n4;
            }
        } else if (this.gs.canExecuteAnyAction(n2)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(this.gs, n2);
            this.actions = new ArrayList();
            this.children = new ArrayList();
            this.unitActionTable = new LinkedList<InformedUnitActionTableEntry>();
            this.multipliers = new BigInteger[this.moveGenerator.getChoices().size()];
            BigInteger bigInteger = BigInteger.ONE;
            int n5 = 0;
            for (Pair<Unit, List<UnitAction>> pair : this.moveGenerator.getChoices()) {
                double[] dArray = this.model.predictDistribution((Unit)pair.m_a, this.gs, (List)pair.m_b);
                InformedUnitActionTableEntry informedUnitActionTableEntry = new InformedUnitActionTableEntry((Unit)pair.m_a, (List)pair.m_b, dArray);
                this.unitActionTable.add(informedUnitActionTableEntry);
                this.multipliers[n5] = bigInteger;
                bigInteger = bigInteger.multiply(BigInteger.valueOf(informedUnitActionTableEntry.nactions));
                ++n5;
            }
        } else {
            this.type = -1;
            System.err.println("BiasedNaiveMCTSNode: This should not have happened...");
        }
    }

    public InformedNaiveMCTSNode selectLeaf(int n, int n2, float f, float f2, float f3, int n3, int n4, int n5) throws Exception {
        if (this.unitActionTable == null) {
            return this;
        }
        if (this.depth >= n4) {
            return this;
        }
        if (this.children.size() > 0 && r.nextFloat() >= f3) {
            InformedNaiveMCTSNode informedNaiveMCTSNode = null;
            if (n3 == 0) {
                informedNaiveMCTSNode = this.selectFromAlreadySampledEpsilonGreedy(f2);
            } else if (n3 == 1) {
                informedNaiveMCTSNode = this.selectFromAlreadySampledUCB1(C);
            }
            return informedNaiveMCTSNode.selectLeaf(n, n2, f, f2, f3, n3, n4, n5);
        }
        return this.selectLeafUsingLocalMABs(n, n2, f, f2, f3, n3, n4, n5);
    }

    public InformedNaiveMCTSNode selectFromAlreadySampledEpsilonGreedy(float f) throws Exception {
        if (r.nextFloat() >= f) {
            InformedNaiveMCTSNode informedNaiveMCTSNode = null;
            for (MCTSNode mCTSNode : this.children) {
                if (this.type == 0) {
                    if (informedNaiveMCTSNode != null && !(mCTSNode.accum_evaluation / (double)mCTSNode.visit_count > informedNaiveMCTSNode.accum_evaluation / (double)informedNaiveMCTSNode.visit_count)) continue;
                    informedNaiveMCTSNode = (InformedNaiveMCTSNode)mCTSNode;
                    continue;
                }
                if (informedNaiveMCTSNode != null && !(mCTSNode.accum_evaluation / (double)mCTSNode.visit_count < informedNaiveMCTSNode.accum_evaluation / (double)informedNaiveMCTSNode.visit_count)) continue;
                informedNaiveMCTSNode = (InformedNaiveMCTSNode)mCTSNode;
            }
            return informedNaiveMCTSNode;
        }
        InformedNaiveMCTSNode informedNaiveMCTSNode = (InformedNaiveMCTSNode)this.children.get(r.nextInt(this.children.size()));
        return informedNaiveMCTSNode;
    }

    public InformedNaiveMCTSNode selectFromAlreadySampledUCB1(float f) throws Exception {
        InformedNaiveMCTSNode informedNaiveMCTSNode = null;
        double d = 0.0;
        for (MCTSNode mCTSNode : this.children) {
            double d2 = mCTSNode.accum_evaluation / (double)mCTSNode.visit_count;
            double d3 = Math.sqrt(Math.log(this.visit_count) / (double)mCTSNode.visit_count);
            d2 = this.type == 0 ? (this.evaluation_bound + d2) / (2.0 * this.evaluation_bound) : (this.evaluation_bound - d2) / (2.0 * this.evaluation_bound);
            double d4 = (double)f * d2 + d3;
            if (informedNaiveMCTSNode != null && !(d4 > d)) continue;
            informedNaiveMCTSNode = (InformedNaiveMCTSNode)mCTSNode;
            d = d4;
        }
        return informedNaiveMCTSNode;
    }

    public InformedNaiveMCTSNode selectLeafUsingLocalMABs(int n, int n2, float f, float f2, float f3, int n3, int n4, int n5) throws Exception {
        Object exception2;
        LinkedList<double[]> linkedList = new LinkedList<double[]>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (InformedUnitActionTableEntry object22 : this.unitActionTable) {
            int n6;
            exception2 = new double[object22.nactions];
            int n7 = -1;
            double d = 0.0;
            int n8 = 0;
            for (n6 = 0; n6 < object22.nactions; ++n6) {
                if (this.type == 0) {
                    if (n7 == -1 || n8 != 0 && object22.visit_count[n6] == 0 || n8 != 0 && object22.accum_evaluation[n6] / (double)object22.visit_count[n6] > d) {
                        n7 = n6;
                        d = object22.visit_count[n6] > 0 ? object22.accum_evaluation[n6] / (double)object22.visit_count[n6] : 0.0;
                        n8 = object22.visit_count[n6];
                    }
                } else if (n7 == -1 || n8 != 0 && object22.visit_count[n6] == 0 || n8 != 0 && object22.accum_evaluation[n6] / (double)object22.visit_count[n6] < d) {
                    n7 = n6;
                    d = object22.visit_count[n6] > 0 ? object22.accum_evaluation[n6] / (double)object22.visit_count[n6] : 0.0;
                    n8 = object22.visit_count[n6];
                }
                exception2[n6] = (double)f * object22.prior_distribution[n6];
            }
            if (object22.visit_count[n7] != 0) {
                exception2[n7] = (double)(1.0f - f) + (double)f * object22.prior_distribution[n7];
            } else {
                for (n6 = 0; n6 < ((double[])exception2).length; ++n6) {
                    if (object22.visit_count[n6] <= 0) continue;
                    exception2[n6] = 0.0;
                }
            }
            if (DEBUG >= 3) {
                System.out.println("e_l = " + f);
                System.out.println(object22.actions);
                System.out.print("[ ");
                for (n6 = 0; n6 < object22.nactions; ++n6) {
                    System.out.print("(" + object22.visit_count[n6] + "," + object22.accum_evaluation[n6] / (double)object22.visit_count[n6] + ")");
                }
                System.out.println("]");
                System.out.println("Prior = " + Arrays.toString(object22.prior_distribution));
                System.out.println("Final = " + Arrays.toString((double[])exception2));
            }
            linkedList2.add(linkedList.size());
            linkedList.add((double[])exception2);
        }
        ResourceUsage resourceUsage = new ResourceUsage();
        for (Object exception2 : this.gs.getUnits()) {
            UnitAction n10 = this.gs.getUnitAction((Unit)exception2);
            if (n10 == null) continue;
            ResourceUsage unitAction = n10.resourceUsage((Unit)exception2, this.gs.getPhysicalGameState());
            resourceUsage.merge(unitAction);
        }
        PlayerAction playerAction = new PlayerAction();
        BigInteger bigInteger = BigInteger.ZERO;
        playerAction.setResourceUsage(resourceUsage.clone());
        while (!linkedList2.isEmpty()) {
            int informedNaiveMCTSNode = (Integer)linkedList2.remove(r.nextInt(linkedList2.size()));
            try {
                exception2 = this.unitActionTable.get(informedNaiveMCTSNode);
                double[] dArray = (double[])linkedList.get(informedNaiveMCTSNode);
                int informedNaiveMCTSNode2 = Sampler.weighted(dArray);
                UnitAction unitAction = ((InformedUnitActionTableEntry)exception2).actions.get(informedNaiveMCTSNode2);
                ResourceUsage resourceUsage2 = unitAction.resourceUsage(((InformedUnitActionTableEntry)exception2).u, this.gs.getPhysicalGameState());
                if (!playerAction.getResourceUsage().consistentWith(resourceUsage2, this.gs)) {
                    int n9;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (n9 = 0; n9 < dArray.length; ++n9) {
                        arrayList.add(dArray[n9]);
                        arrayList2.add(n9);
                    }
                    do {
                        n9 = arrayList2.indexOf(informedNaiveMCTSNode2);
                        arrayList.remove(n9);
                        arrayList2.remove(n9);
                        informedNaiveMCTSNode2 = (Integer)Sampler.weighted(arrayList, arrayList2);
                        unitAction = ((InformedUnitActionTableEntry)exception2).actions.get(informedNaiveMCTSNode2);
                        resourceUsage2 = unitAction.resourceUsage(((InformedUnitActionTableEntry)exception2).u, this.gs.getPhysicalGameState());
                    } while (!playerAction.getResourceUsage().consistentWith(resourceUsage2, this.gs));
                }
                if (this.gs.getUnit(((InformedUnitActionTableEntry)exception2).u.getID()) == null) {
                    throw new Error("Issuing an action to an inexisting unit!!!");
                }
                playerAction.getResourceUsage().merge(resourceUsage2);
                playerAction.addUnitAction(((InformedUnitActionTableEntry)exception2).u, unitAction);
                bigInteger = bigInteger.add(BigInteger.valueOf(informedNaiveMCTSNode2).multiply(this.multipliers[informedNaiveMCTSNode]));
            }
            catch (Exception exception3) {
                exception3.printStackTrace();
            }
        }
        InformedNaiveMCTSNode informedNaiveMCTSNode = this.childrenMap.get(bigInteger);
        if (informedNaiveMCTSNode == null) {
            this.actions.add(playerAction);
            exception2 = this.gs.cloneIssue(playerAction);
            InformedNaiveMCTSNode informedNaiveMCTSNode2 = new InformedNaiveMCTSNode(n, n2, ((GameState)exception2).clone(), this.model, this, this.evaluation_bound, n5);
            this.childrenMap.put(bigInteger, informedNaiveMCTSNode2);
            this.children.add(informedNaiveMCTSNode2);
            return informedNaiveMCTSNode2;
        }
        return informedNaiveMCTSNode.selectLeaf(n, n2, f, f2, f3, n3, n4, n5);
    }

    public InformedUnitActionTableEntry getActionTableEntry(Unit unit) {
        for (InformedUnitActionTableEntry informedUnitActionTableEntry : this.unitActionTable) {
            if (informedUnitActionTableEntry.u != unit) continue;
            return informedUnitActionTableEntry;
        }
        throw new Error("Could not find Action Table Entry!");
    }

    public void propagateEvaluation(double d, InformedNaiveMCTSNode informedNaiveMCTSNode) {
        this.accum_evaluation += d;
        ++this.visit_count;
        if (informedNaiveMCTSNode != null) {
            int n = this.children.indexOf(informedNaiveMCTSNode);
            PlayerAction playerAction = (PlayerAction)this.actions.get(n);
            for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                InformedUnitActionTableEntry informedUnitActionTableEntry = this.getActionTableEntry((Unit)pair.m_a);
                n = informedUnitActionTableEntry.actions.indexOf(pair.m_b);
                if (n == -1) {
                    System.out.println("Looking for action: " + pair.m_b);
                    System.out.println("Available actions are: " + informedUnitActionTableEntry.actions);
                }
                int n2 = n;
                informedUnitActionTableEntry.accum_evaluation[n2] = informedUnitActionTableEntry.accum_evaluation[n2] + d;
                int n3 = n;
                informedUnitActionTableEntry.visit_count[n3] = informedUnitActionTableEntry.visit_count[n3] + 1;
            }
        }
        if (this.parent != null) {
            ((InformedNaiveMCTSNode)this.parent).propagateEvaluation(d, this);
        }
    }

    public void printUnitActionTable() {
        for (InformedUnitActionTableEntry informedUnitActionTableEntry : this.unitActionTable) {
            System.out.println("Actions for unit " + informedUnitActionTableEntry.u);
            for (int j = 0; j < informedUnitActionTableEntry.nactions; ++j) {
                System.out.println("   " + informedUnitActionTableEntry.actions.get(j) + " visited " + informedUnitActionTableEntry.visit_count[j] + " with average evaluation " + informedUnitActionTableEntry.accum_evaluation[j] / (double)informedUnitActionTableEntry.visit_count[j]);
            }
        }
    }
}

