/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.mlps;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.mlps.MLPSNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class MLPSMCTS
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    public EvaluationFunction ef = null;
    Random r = new Random();
    public AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from = null;
    MLPSNode tree = null;
    int current_iteration = 0;
    public int MAXSIMULATIONTIME = 1024;
    public int MAX_TREE_DEPTH = 10;
    int playerForThisComputation;
    double C = 0.05;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    public long total_time = 0L;

    public MLPSMCTS(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, 10, 0.05, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public MLPSMCTS(int n, int n2, int n3, int n4, double d, AI aI, EvaluationFunction evaluationFunction) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.MAX_TREE_DEPTH = n4;
        this.C = d;
        this.ef = evaluationFunction;
    }

    @Override
    public void reset() {
        this.tree = null;
        this.gs_to_start_from = null;
        this.total_runs = 0L;
        this.total_cycles_executed = 0L;
        this.total_actions_issued = 0L;
        this.total_time = 0L;
        this.current_iteration = 0;
    }

    @Override
    public AI clone() {
        return new MLPSMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.C, this.randomAI, this.ef);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.playerForThisComputation = n;
        this.current_iteration = 0;
        float f = this.ef.upperBound(gameState);
        this.tree = new MLPSNode(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState, null, f, this.current_iteration++);
        if (this.tree.moveGenerator != null) {
            this.max_actions_so_far = Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        }
        this.gs_to_start_from = gameState;
    }

    public void resetSearch() {
        if (DEBUG >= 2) {
            System.out.println("Resetting search...");
        }
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l;
        if (DEBUG >= 2) {
            System.out.println("Search...");
        }
        long l2 = l = System.currentTimeMillis();
        long l3 = 0L;
        while (this.iteration(this.playerForThisComputation)) {
            l2 = System.currentTimeMillis();
            if ((this.TIME_BUDGET < 0 || l2 - l < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++l3 < (long)this.ITERATIONS_BUDGET)) continue;
        }
        this.total_time += l2 - l;
        ++this.total_cycles_executed;
    }

    public boolean iteration(int n) throws Exception {
        MLPSNode mLPSNode;
        if ((mLPSNode = this.tree.selectLeaf(n, 1 - n, this.C, this.MAX_TREE_DEPTH, this.current_iteration++)) != null) {
            GameState gameState = mLPSNode.gs.clone();
            this.simulate(gameState, gameState.getTime() + this.MAXSIMULATIONTIME);
            int n2 = gameState.getTime() - this.gs_to_start_from.getTime();
            double d = (double)this.ef.evaluate(n, 1 - n, gameState) * Math.pow(0.99, (double)n2 / 10.0);
            mLPSNode.propagateEvaluation((float)d, null);
            ++this.total_runs;
        } else {
            System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
            return false;
        }
        return true;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        int n = this.getMostVisitedActionIdx();
        if (n == -1) {
            if (DEBUG >= 1) {
                System.out.println("MLPSMCTS no children selected. Returning an empty asction");
            }
            return new PlayerAction();
        }
        if (DEBUG >= 2) {
            this.tree.showNode(0, 1, this.ef);
        }
        if (DEBUG >= 1) {
            MLPSNode mLPSNode = (MLPSNode)this.tree.children.get(n);
            System.out.println("MLPSMCTS selected children " + this.tree.actions.get(n) + " explored " + mLPSNode.visit_count + " Avg evaluation: " + mLPSNode.accum_evaluation / (double)mLPSNode.visit_count);
        }
        return (PlayerAction)this.tree.actions.get(n);
    }

    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        int n = -1;
        MLPSNode mLPSNode = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        if (this.tree.children == null) {
            return -1;
        }
        for (int j = 0; j < this.tree.children.size(); ++j) {
            MLPSNode mLPSNode2 = (MLPSNode)this.tree.children.get(j);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(j) + " explored " + mLPSNode2.visit_count + " Avg evaluation: " + mLPSNode2.accum_evaluation / (double)mLPSNode2.visit_count);
            }
            if (mLPSNode != null && mLPSNode2.visit_count <= mLPSNode.visit_count) continue;
            mLPSNode = mLPSNode2;
            n = j;
        }
        return n;
    }

    public int getHighestEvaluationActionIdx() {
        ++this.total_actions_issued;
        int n = -1;
        MLPSNode mLPSNode = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int j = 0; j < this.tree.children.size(); ++j) {
            MLPSNode mLPSNode2 = (MLPSNode)this.tree.children.get(j);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(j) + " explored " + mLPSNode2.visit_count + " Avg evaluation: " + mLPSNode2.accum_evaluation / (double)mLPSNode2.visit_count);
            }
            if (mLPSNode != null && !(mLPSNode2.accum_evaluation / (double)mLPSNode2.visit_count > mLPSNode.accum_evaluation / (double)mLPSNode.visit_count)) continue;
            mLPSNode = mLPSNode2;
            n = j;
        }
        return n;
    }

    public void simulate(GameState gameState, int n) throws Exception {
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.randomAI.getAction(0, gameState));
            gameState.issue(this.randomAI.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    public MLPSNode getTree() {
        return this.tree;
    }

    public GameState getGameStateToStartFrom() {
        return this.gs_to_start_from;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + ", " + this.MAX_TREE_DEPTH + ", " + this.C + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public String statisticsString() {
        return "Total runs: " + this.total_runs + ", runs per action: " + (float)this.total_runs / (float)this.total_actions_issued + ", runs per cycle: " + (float)this.total_runs / (float)this.total_cycles_executed + ", averate time per cycle: " + (float)this.total_time / (float)this.total_cycles_executed + ", max branching factor: " + this.max_actions_so_far;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        arrayList.add(new ParameterSpecification("C", Double.TYPE, 0.05));
        arrayList.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int n) {
        this.MAXSIMULATIONTIME = n;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int n) {
        this.MAX_TREE_DEPTH = n;
    }

    public double getC() {
        return this.C;
    }

    public void setC(double d) {
        this.C = d;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI aI) {
        this.randomAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }
}

