/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.mlps;

import ai.mcts.MCTSNode;
import ai.montecarlo.lsi.Sampling;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class MLPSNode
extends MCTSNode {
    public static int DEBUG = 0;
    boolean hasMoreActions = true;
    public PlayerActionGenerator moveGenerator = null;
    HashMap<Long, MLPSNode> childrenMap = new LinkedHashMap<Long, MLPSNode>();
    public List<Sampling.UnitActionTableEntry> unitActionTable = null;
    public List<double[]> UCBExplorationScores = null;
    public List<double[]> UCBExploitationScores = null;
    double evaluation_bound = 0.0;
    int max_nactions = 0;
    public long[] multipliers;

    public MLPSNode(int n, int n2, GameState gameState, MLPSNode mLPSNode, double d, int n3) throws Exception {
        this.parent = mLPSNode;
        this.gs = gameState;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = d;
        this.creation_ID = n3;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(n) || this.gs.canExecuteAnyAction(n2))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(n)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(gameState, n);
            this.actions = new ArrayList();
            this.children = new ArrayList();
            this.unitActionTable = new ArrayList<Sampling.UnitActionTableEntry>();
            this.UCBExplorationScores = new ArrayList<double[]>();
            this.UCBExploitationScores = new ArrayList<double[]>();
            this.multipliers = new long[this.moveGenerator.getChoices().size()];
            long l = 1L;
            int n4 = 0;
            for (Pair<Unit, List<UnitAction>> pair : this.moveGenerator.getChoices()) {
                Sampling.UnitActionTableEntry unitActionTableEntry = new Sampling.UnitActionTableEntry();
                unitActionTableEntry.u = (Unit)pair.m_a;
                unitActionTableEntry.nactions = ((List)pair.m_b).size();
                if (unitActionTableEntry.nactions > this.max_nactions) {
                    this.max_nactions = unitActionTableEntry.nactions;
                }
                unitActionTableEntry.actions = (List)pair.m_b;
                unitActionTableEntry.accum_evaluation = new double[unitActionTableEntry.nactions];
                unitActionTableEntry.visit_count = new int[unitActionTableEntry.nactions];
                for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                    unitActionTableEntry.accum_evaluation[j] = 0.0;
                    unitActionTableEntry.visit_count[j] = 0;
                }
                this.unitActionTable.add(unitActionTableEntry);
                this.UCBExplorationScores.add(new double[unitActionTableEntry.nactions]);
                this.UCBExploitationScores.add(new double[unitActionTableEntry.nactions]);
                this.multipliers[n4] = l;
                l *= (long)unitActionTableEntry.nactions;
                ++n4;
            }
        } else if (this.gs.canExecuteAnyAction(n2)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(gameState, n2);
            this.actions = new ArrayList();
            this.children = new ArrayList();
            this.unitActionTable = new ArrayList<Sampling.UnitActionTableEntry>();
            this.UCBExplorationScores = new ArrayList<double[]>();
            this.UCBExploitationScores = new ArrayList<double[]>();
            this.multipliers = new long[this.moveGenerator.getChoices().size()];
            long l = 1L;
            int n5 = 0;
            for (Pair<Unit, List<UnitAction>> pair : this.moveGenerator.getChoices()) {
                Sampling.UnitActionTableEntry unitActionTableEntry = new Sampling.UnitActionTableEntry();
                unitActionTableEntry.u = (Unit)pair.m_a;
                unitActionTableEntry.nactions = ((List)pair.m_b).size();
                if (unitActionTableEntry.nactions > this.max_nactions) {
                    this.max_nactions = unitActionTableEntry.nactions;
                }
                unitActionTableEntry.actions = (List)pair.m_b;
                unitActionTableEntry.accum_evaluation = new double[unitActionTableEntry.nactions];
                unitActionTableEntry.visit_count = new int[unitActionTableEntry.nactions];
                for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                    unitActionTableEntry.accum_evaluation[j] = 0.0;
                    unitActionTableEntry.visit_count[j] = 0;
                }
                this.unitActionTable.add(unitActionTableEntry);
                this.UCBExplorationScores.add(new double[unitActionTableEntry.nactions]);
                this.UCBExploitationScores.add(new double[unitActionTableEntry.nactions]);
                this.multipliers[n5] = l;
                l *= (long)unitActionTableEntry.nactions;
                ++n5;
            }
        } else {
            this.type = -1;
            System.err.println("MLPSNode: This should not have happened...");
        }
    }

    public double actionExploitationValue(Sampling.UnitActionTableEntry unitActionTableEntry, int n) {
        if (unitActionTableEntry.visit_count[n] == 0) {
            return 0.0;
        }
        double d = unitActionTableEntry.accum_evaluation[n] / (double)unitActionTableEntry.visit_count[n];
        return d;
    }

    public double explorationValue(int n, int n2, int n3) {
        if (n3 == 0) {
            return Double.MAX_VALUE;
        }
        double d = (double)n * Math.sqrt((double)(n + 1) * Math.log(n2) / (double)n3);
        return d;
    }

    public MLPSNode selectLeaf(int n, int n2, double d, int n3, int n4) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.unitActionTable == null) {
            return this;
        }
        if (this.depth >= n3) {
            return this;
        }
        if (DEBUG >= 1) {
            System.out.println("MLPSNode.selectLeaf...");
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int j = 0; j < this.unitActionTable.size(); ++j) {
            int n5;
            object4 = this.unitActionTable.get(j);
            object3 = this.UCBExploitationScores.get(j);
            object2 = this.UCBExplorationScores.get(j);
            for (n5 = 0; n5 < ((Sampling.UnitActionTableEntry)object4).nactions; ++n5) {
                object3[n5] = this.actionExploitationValue((Sampling.UnitActionTableEntry)object4, n5);
                object2[n5] = this.explorationValue(this.max_nactions, this.visit_count, ((Sampling.UnitActionTableEntry)object4).visit_count[n5]);
            }
            if (DEBUG >= 3) {
                System.out.print("[ ");
                for (n5 = 0; n5 < ((Sampling.UnitActionTableEntry)object4).nactions; ++n5) {
                    System.out.print("(" + ((Sampling.UnitActionTableEntry)object4).visit_count[n5] + "," + object3[n5] + "," + (double)object2[n5] + ")");
                }
                System.out.println("]");
            }
            linkedList.add(j);
        }
        ResourceUsage resourceUsage = new ResourceUsage();
        object4 = this.gs.getUnits().iterator();
        while (object4.hasNext()) {
            object3 = (Unit)object4.next();
            object2 = this.gs.getUnitAction((Unit)object3);
            if (object2 == null) continue;
            ResourceUsage resourceUsage2 = ((UnitAction)object2).resourceUsage((Unit)object3, this.gs.getPhysicalGameState());
            resourceUsage.merge(resourceUsage2);
        }
        object4 = null;
        long l = -1L;
        double d2 = 0.0;
        for (int j = 0; j < 10; ++j) {
            object = new PlayerAction();
            long l2 = 0L;
            double d3 = 0.0;
            double d4 = 0.0;
            ((PlayerAction)object).setResourceUsage(resourceUsage.clone());
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            linkedList2.addAll(linkedList);
            while (!linkedList2.isEmpty()) {
                if (DEBUG >= 2) {
                    System.out.println("notSampledYet: " + linkedList2);
                }
                int n6 = r.nextInt(linkedList2.size());
                n6 = (Integer)linkedList2.remove(n6);
                try {
                    double d5;
                    Sampling.UnitActionTableEntry unitActionTableEntry = this.unitActionTable.get(n6);
                    double[] dArray = this.UCBExploitationScores.get(n6);
                    double[] dArray2 = this.UCBExplorationScores.get(n6);
                    int n7 = -1;
                    for (int k = 0; k < unitActionTableEntry.nactions; ++k) {
                        if (n7 == -1) {
                            n7 = k;
                            continue;
                        }
                        double d6 = dArray[k] + d * Math.max(dArray2[k], d4);
                        if (!(d6 > (d5 = dArray[n7] + d * Math.max(dArray2[n7], d4)))) continue;
                        n7 = k;
                    }
                    UnitAction unitAction = unitActionTableEntry.actions.get(n7);
                    ResourceUsage resourceUsage3 = unitAction.resourceUsage(unitActionTableEntry.u, this.gs.getPhysicalGameState());
                    if (!((PlayerAction)object).getResourceUsage().consistentWith(resourceUsage3, this.gs)) {
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        for (int k = 0; k < unitActionTableEntry.nactions; ++k) {
                            if (k == n7) continue;
                            arrayList.add(k);
                        }
                        if (DEBUG >= 4) {
                            System.out.println("    unit " + n6 + ": trying " + n7);
                        }
                        do {
                            n7 = -1;
                            for (Integer n8 : arrayList) {
                                double d7;
                                if (n7 == -1) {
                                    n7 = n8;
                                    continue;
                                }
                                d5 = dArray[n8] + d * Math.max(dArray2[n8], d4);
                                if (!(d5 > (d7 = dArray[n7] + d * Math.max(dArray2[n7], d4)))) continue;
                                n7 = n8;
                            }
                            if (DEBUG >= 4) {
                                System.out.println("    unit " + n6 + ": trying " + n7);
                            }
                            arrayList.remove((Object)n7);
                            unitAction = unitActionTableEntry.actions.get(n7);
                            resourceUsage3 = unitAction.resourceUsage(unitActionTableEntry.u, this.gs.getPhysicalGameState());
                        } while (!((PlayerAction)object).getResourceUsage().consistentWith(resourceUsage3, this.gs));
                    }
                    if (DEBUG >= 3) {
                        System.out.println("  unit " + n6 + ": " + n7);
                    }
                    d3 += d * dArray[n7];
                    d4 = Math.max(dArray2[n7], d4);
                    ((PlayerAction)object).getResourceUsage().merge(resourceUsage3);
                    ((PlayerAction)object).addUnitAction(unitActionTableEntry.u, unitAction);
                    l2 += (long)n7 * this.multipliers[n6];
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            d3 += d4;
            if (DEBUG >= 1) {
                System.out.println("  accumUCBScore: " + d3);
            }
            if (object4 != null && !(d3 > d2)) continue;
            object4 = object;
            d2 = d3;
            l = l2;
        }
        MLPSNode mLPSNode = this.childrenMap.get(l);
        if (mLPSNode == null) {
            this.actions.add(object4);
            object = this.gs.cloneIssue((PlayerAction)object4);
            MLPSNode mLPSNode2 = new MLPSNode(n, n2, ((GameState)object).clone(), this, this.evaluation_bound, n4);
            this.childrenMap.put(l, mLPSNode2);
            this.children.add(mLPSNode2);
            return mLPSNode2;
        }
        return mLPSNode.selectLeaf(n, n2, d, n3, n4);
    }

    public Sampling.UnitActionTableEntry getActionTableEntry(Unit unit) {
        for (Sampling.UnitActionTableEntry unitActionTableEntry : this.unitActionTable) {
            if (unitActionTableEntry.u != unit) continue;
            return unitActionTableEntry;
        }
        return null;
    }

    public void propagateEvaluation(float f, MLPSNode mLPSNode) {
        this.accum_evaluation += (double)f;
        ++this.visit_count;
        if (mLPSNode != null) {
            int n = this.children.indexOf(mLPSNode);
            PlayerAction playerAction = (PlayerAction)this.actions.get(n);
            for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                Sampling.UnitActionTableEntry unitActionTableEntry = this.getActionTableEntry((Unit)pair.m_a);
                n = unitActionTableEntry.actions.indexOf(pair.m_b);
                if (n == -1) {
                    System.out.println("Looking for action: " + pair.m_b);
                    System.out.println("Available actions are: " + unitActionTableEntry.actions);
                }
                int n2 = n;
                unitActionTableEntry.accum_evaluation[n2] = unitActionTableEntry.accum_evaluation[n2] + (double)f;
                int n3 = n;
                unitActionTableEntry.visit_count[n3] = unitActionTableEntry.visit_count[n3] + 1;
            }
        }
        if (this.parent != null) {
            ((MLPSNode)this.parent).propagateEvaluation(f, this);
        }
    }

    public void printUnitActionTable() {
        for (Sampling.UnitActionTableEntry unitActionTableEntry : this.unitActionTable) {
            System.out.println("Actions for unit " + unitActionTableEntry.u);
            for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                System.out.println("   " + unitActionTableEntry.actions.get(j) + " visited " + unitActionTableEntry.visit_count[j] + " with average evaluation " + unitActionTableEntry.accum_evaluation[j] / (double)unitActionTableEntry.visit_count[j]);
            }
        }
    }
}

