/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.naivemcts;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class NaiveMCTS
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    public EvaluationFunction ef = null;
    Random r = new Random();
    public AI playoutPolicy = new RandomBiasedAI();
    protected long max_actions_so_far = 0L;
    protected GameState gs_to_start_from = null;
    protected NaiveMCTSNode tree = null;
    protected int current_iteration = 0;
    public int MAXSIMULATIONTIME = 1024;
    public int MAX_TREE_DEPTH = 10;
    protected int player;
    public float epsilon_0 = 0.2f;
    public float epsilon_l = 0.25f;
    public float epsilon_g = 0.0f;
    public float initial_epsilon_0 = 0.2f;
    public float initial_epsilon_l = 0.25f;
    public float initial_epsilon_g = 0.0f;
    public float discount_0 = 0.999f;
    public float discount_l = 0.999f;
    public float discount_g = 0.999f;
    public int global_strategy = 0;
    public boolean forceExplorationOfNonSampledActions = true;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    public long total_time = 0L;

    public NaiveMCTS(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, 10, 0.3f, 0.0f, 0.4f, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3(), true);
    }

    public NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.playoutPolicy = aI;
        this.MAX_TREE_DEPTH = n4;
        this.initial_epsilon_l = this.epsilon_l = f;
        this.initial_epsilon_g = this.epsilon_g = f3;
        this.initial_epsilon_0 = this.epsilon_0 = f5;
        this.discount_l = f2;
        this.discount_g = f4;
        this.discount_0 = f6;
        this.ef = evaluationFunction;
        this.forceExplorationOfNonSampledActions = bl;
    }

    public NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.playoutPolicy = aI;
        this.MAX_TREE_DEPTH = n4;
        this.initial_epsilon_l = this.epsilon_l = f;
        this.initial_epsilon_g = this.epsilon_g = f2;
        this.initial_epsilon_0 = this.epsilon_0 = f3;
        this.discount_l = 1.0f;
        this.discount_g = 1.0f;
        this.discount_0 = 1.0f;
        this.ef = evaluationFunction;
        this.forceExplorationOfNonSampledActions = bl;
    }

    public NaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, int n5, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.playoutPolicy = aI;
        this.MAX_TREE_DEPTH = n4;
        this.initial_epsilon_l = this.epsilon_l = f;
        this.initial_epsilon_g = this.epsilon_g = f2;
        this.initial_epsilon_0 = this.epsilon_0 = f3;
        this.discount_l = 1.0f;
        this.discount_g = 1.0f;
        this.discount_0 = 1.0f;
        this.global_strategy = n5;
        this.ef = evaluationFunction;
        this.forceExplorationOfNonSampledActions = bl;
    }

    @Override
    public void reset() {
        this.tree = null;
        this.gs_to_start_from = null;
        this.total_runs = 0L;
        this.total_cycles_executed = 0L;
        this.total_actions_issued = 0L;
        this.total_time = 0L;
        this.current_iteration = 0;
    }

    @Override
    public AI clone() {
        return new NaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.epsilon_l, this.discount_l, this.epsilon_g, this.discount_g, this.epsilon_0, this.discount_0, this.playoutPolicy, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.player = n;
        this.current_iteration = 0;
        this.tree = new NaiveMCTSNode(this.player, 1 - this.player, gameState, null, this.ef.upperBound(gameState), this.current_iteration++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = this.tree.moveGenerator == null ? 0L : Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gameState;
        this.epsilon_l = this.initial_epsilon_l;
        this.epsilon_g = this.initial_epsilon_g;
        this.epsilon_0 = this.initial_epsilon_0;
    }

    public void resetSearch() {
        if (DEBUG >= 2) {
            System.out.println("Resetting search...");
        }
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l;
        if (DEBUG >= 2) {
            System.out.println("Search...");
        }
        long l2 = l = System.currentTimeMillis();
        long l3 = 0L;
        while (this.iteration(this.player)) {
            l2 = System.currentTimeMillis();
            if ((this.TIME_BUDGET < 0 || l2 - l < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++l3 < (long)this.ITERATIONS_BUDGET)) continue;
        }
        this.total_time += l2 - l;
        ++this.total_cycles_executed;
    }

    public boolean iteration(int n) throws Exception {
        NaiveMCTSNode naiveMCTSNode;
        if ((naiveMCTSNode = this.tree.selectLeaf(n, 1 - n, this.epsilon_l, this.epsilon_g, this.epsilon_0, this.global_strategy, this.MAX_TREE_DEPTH, this.current_iteration++)) != null) {
            GameState gameState = naiveMCTSNode.gs.clone();
            this.simulate(gameState, gameState.getTime() + this.MAXSIMULATIONTIME);
            int n2 = gameState.getTime() - this.gs_to_start_from.getTime();
            double d = (double)this.ef.evaluate(n, 1 - n, gameState) * Math.pow(0.99, (double)n2 / 10.0);
            naiveMCTSNode.propagateEvaluation(d, null);
            this.epsilon_0 *= this.discount_0;
            this.epsilon_l *= this.discount_l;
            this.epsilon_g *= this.discount_g;
            ++this.total_runs;
        } else {
            System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
            return false;
        }
        return true;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        int n = this.getMostVisitedActionIdx();
        if (n == -1) {
            if (DEBUG >= 1) {
                System.out.println("NaiveMCTS no children selected. Returning an empty asction");
            }
            return new PlayerAction();
        }
        if (DEBUG >= 2) {
            this.tree.showNode(0, 1, this.ef);
        }
        if (DEBUG >= 1) {
            NaiveMCTSNode naiveMCTSNode = (NaiveMCTSNode)this.tree.children.get(n);
            System.out.println("NaiveMCTS selected children " + this.tree.actions.get(n) + " explored " + naiveMCTSNode.visit_count + " Avg evaluation: " + naiveMCTSNode.accum_evaluation / (double)naiveMCTSNode.visit_count);
        }
        return (PlayerAction)this.tree.actions.get(n);
    }

    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        int n = -1;
        NaiveMCTSNode naiveMCTSNode = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        if (this.tree.children == null) {
            return -1;
        }
        for (int j = 0; j < this.tree.children.size(); ++j) {
            NaiveMCTSNode naiveMCTSNode2 = (NaiveMCTSNode)this.tree.children.get(j);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(j) + " explored " + naiveMCTSNode2.visit_count + " Avg evaluation: " + naiveMCTSNode2.accum_evaluation / (double)naiveMCTSNode2.visit_count);
            }
            if (naiveMCTSNode != null && naiveMCTSNode2.visit_count <= naiveMCTSNode.visit_count) continue;
            naiveMCTSNode = naiveMCTSNode2;
            n = j;
        }
        return n;
    }

    public int getHighestEvaluationActionIdx() {
        ++this.total_actions_issued;
        int n = -1;
        NaiveMCTSNode naiveMCTSNode = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int j = 0; j < this.tree.children.size(); ++j) {
            NaiveMCTSNode naiveMCTSNode2 = (NaiveMCTSNode)this.tree.children.get(j);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(j) + " explored " + naiveMCTSNode2.visit_count + " Avg evaluation: " + naiveMCTSNode2.accum_evaluation / (double)naiveMCTSNode2.visit_count);
            }
            if (naiveMCTSNode != null && !(naiveMCTSNode2.accum_evaluation / (double)naiveMCTSNode2.visit_count > naiveMCTSNode.accum_evaluation / (double)naiveMCTSNode.visit_count)) continue;
            naiveMCTSNode = naiveMCTSNode2;
            n = j;
        }
        return n;
    }

    public void simulate(GameState gameState, int n) throws Exception {
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.playoutPolicy.getAction(0, gameState));
            gameState.issue(this.playoutPolicy.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    public NaiveMCTSNode getTree() {
        return this.tree;
    }

    public GameState getGameStateToStartFrom() {
        return this.gs_to_start_from;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + "," + this.MAX_TREE_DEPTH + "," + this.epsilon_l + ", " + this.discount_l + ", " + this.epsilon_g + ", " + this.discount_g + ", " + this.epsilon_0 + ", " + this.discount_0 + ", " + this.playoutPolicy + ", " + this.ef + ")";
    }

    @Override
    public String statisticsString() {
        return "Total runs: " + this.total_runs + ", runs per action: " + (float)this.total_runs / (float)this.total_actions_issued + ", runs per cycle: " + (float)this.total_runs / (float)this.total_cycles_executed + ", average time per cycle: " + (float)this.total_time / (float)this.total_cycles_executed + ", max branching factor: " + this.max_actions_so_far;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        arrayList.add(new ParameterSpecification("E_l", Float.TYPE, 0.3));
        arrayList.add(new ParameterSpecification("Discount_l", Float.TYPE, 1.0));
        arrayList.add(new ParameterSpecification("E_g", Float.TYPE, 0.0));
        arrayList.add(new ParameterSpecification("Discount_g", Float.TYPE, 1.0));
        arrayList.add(new ParameterSpecification("E_0", Float.TYPE, 0.4));
        arrayList.add(new ParameterSpecification("Discount_0", Float.TYPE, 1.0));
        arrayList.add(new ParameterSpecification("DefaultPolicy", AI.class, this.playoutPolicy));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        arrayList.add(new ParameterSpecification("ForceExplorationOfNonSampledActions", Boolean.TYPE, true));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int n) {
        this.MAXSIMULATIONTIME = n;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int n) {
        this.MAX_TREE_DEPTH = n;
    }

    public float getE_l() {
        return this.epsilon_l;
    }

    public void setE_l(float f) {
        this.epsilon_l = f;
    }

    public float getDiscount_l() {
        return this.discount_l;
    }

    public void setDiscount_l(float f) {
        this.discount_l = f;
    }

    public float getE_g() {
        return this.epsilon_g;
    }

    public void setE_g(float f) {
        this.epsilon_g = f;
    }

    public float getDiscount_g() {
        return this.discount_g;
    }

    public void setDiscount_g(float f) {
        this.discount_g = f;
    }

    public float getE_0() {
        return this.epsilon_0;
    }

    public void setE_0(float f) {
        this.epsilon_0 = f;
    }

    public float getDiscount_0() {
        return this.discount_0;
    }

    public void setDiscount_0(float f) {
        this.discount_0 = f;
    }

    public AI getDefaultPolicy() {
        return this.playoutPolicy;
    }

    public void setDefaultPolicy(AI aI) {
        this.playoutPolicy = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }

    public boolean getForceExplorationOfNonSampledActions() {
        return this.forceExplorationOfNonSampledActions;
    }

    public void setForceExplorationOfNonSampledActions(boolean bl) {
        this.forceExplorationOfNonSampledActions = bl;
    }
}

