/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.naivemcts;

import ai.mcts.MCTSNode;
import ai.mcts.naivemcts.UnitActionTableEntry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;
import util.Sampler;

public class NaiveMCTSNode
extends MCTSNode {
    public static final int E_GREEDY = 0;
    public static final int UCB1 = 1;
    public static int DEBUG = 0;
    public static float C = 0.05f;
    boolean forceExplorationOfNonSampledActions = true;
    boolean hasMoreActions = true;
    public PlayerActionGenerator moveGenerator = null;
    HashMap<BigInteger, NaiveMCTSNode> childrenMap = new LinkedHashMap<BigInteger, NaiveMCTSNode>();
    public List<UnitActionTableEntry> unitActionTable = null;
    double evaluation_bound;
    public BigInteger[] multipliers;

    public NaiveMCTSNode(int n, int n2, GameState gameState, NaiveMCTSNode naiveMCTSNode, double d, int n3, boolean bl) throws Exception {
        this.parent = naiveMCTSNode;
        this.gs = gameState;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = d;
        this.creation_ID = n3;
        this.forceExplorationOfNonSampledActions = bl;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(n) || this.gs.canExecuteAnyAction(n2))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(n)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(this.gs, n);
            this.actions = new ArrayList();
            this.children = new ArrayList();
            this.unitActionTable = new LinkedList<UnitActionTableEntry>();
            this.multipliers = new BigInteger[this.moveGenerator.getChoices().size()];
            BigInteger bigInteger = BigInteger.ONE;
            int n4 = 0;
            for (Pair<Unit, List<UnitAction>> pair : this.moveGenerator.getChoices()) {
                UnitActionTableEntry unitActionTableEntry = new UnitActionTableEntry();
                unitActionTableEntry.u = (Unit)pair.m_a;
                unitActionTableEntry.nactions = ((List)pair.m_b).size();
                unitActionTableEntry.actions = (List)pair.m_b;
                unitActionTableEntry.accum_evaluation = new double[unitActionTableEntry.nactions];
                unitActionTableEntry.visit_count = new int[unitActionTableEntry.nactions];
                for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                    unitActionTableEntry.accum_evaluation[j] = 0.0;
                    unitActionTableEntry.visit_count[j] = 0;
                }
                this.unitActionTable.add(unitActionTableEntry);
                this.multipliers[n4] = bigInteger;
                bigInteger = bigInteger.multiply(BigInteger.valueOf(unitActionTableEntry.nactions));
                ++n4;
            }
        } else if (this.gs.canExecuteAnyAction(n2)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(this.gs, n2);
            this.actions = new ArrayList();
            this.children = new ArrayList();
            this.unitActionTable = new LinkedList<UnitActionTableEntry>();
            this.multipliers = new BigInteger[this.moveGenerator.getChoices().size()];
            BigInteger bigInteger = BigInteger.ONE;
            int n5 = 0;
            for (Pair<Unit, List<UnitAction>> pair : this.moveGenerator.getChoices()) {
                UnitActionTableEntry unitActionTableEntry = new UnitActionTableEntry();
                unitActionTableEntry.u = (Unit)pair.m_a;
                unitActionTableEntry.nactions = ((List)pair.m_b).size();
                unitActionTableEntry.actions = (List)pair.m_b;
                unitActionTableEntry.accum_evaluation = new double[unitActionTableEntry.nactions];
                unitActionTableEntry.visit_count = new int[unitActionTableEntry.nactions];
                for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                    unitActionTableEntry.accum_evaluation[j] = 0.0;
                    unitActionTableEntry.visit_count[j] = 0;
                }
                this.unitActionTable.add(unitActionTableEntry);
                this.multipliers[n5] = bigInteger;
                bigInteger = bigInteger.multiply(BigInteger.valueOf(unitActionTableEntry.nactions));
                ++n5;
            }
        } else {
            this.type = -1;
            System.err.println("NaiveMCTSNode: This should not have happened...");
        }
    }

    public NaiveMCTSNode selectLeaf(int n, int n2, float f, float f2, float f3, int n3, int n4, int n5) throws Exception {
        if (this.unitActionTable == null) {
            return this;
        }
        if (this.depth >= n4) {
            return this;
        }
        if (this.children.size() > 0 && r.nextFloat() >= f3) {
            NaiveMCTSNode naiveMCTSNode = null;
            if (n3 == 0) {
                naiveMCTSNode = this.selectFromAlreadySampledEpsilonGreedy(f2);
            } else if (n3 == 1) {
                naiveMCTSNode = this.selectFromAlreadySampledUCB1(C);
            }
            return naiveMCTSNode.selectLeaf(n, n2, f, f2, f3, n3, n4, n5);
        }
        return this.selectLeafUsingLocalMABs(n, n2, f, f2, f3, n3, n4, n5);
    }

    public NaiveMCTSNode selectFromAlreadySampledEpsilonGreedy(float f) throws Exception {
        if (r.nextFloat() >= f) {
            NaiveMCTSNode naiveMCTSNode = null;
            for (MCTSNode mCTSNode : this.children) {
                if (this.type == 0) {
                    if (naiveMCTSNode != null && !(mCTSNode.accum_evaluation / (double)mCTSNode.visit_count > naiveMCTSNode.accum_evaluation / (double)naiveMCTSNode.visit_count)) continue;
                    naiveMCTSNode = (NaiveMCTSNode)mCTSNode;
                    continue;
                }
                if (naiveMCTSNode != null && !(mCTSNode.accum_evaluation / (double)mCTSNode.visit_count < naiveMCTSNode.accum_evaluation / (double)naiveMCTSNode.visit_count)) continue;
                naiveMCTSNode = (NaiveMCTSNode)mCTSNode;
            }
            return naiveMCTSNode;
        }
        NaiveMCTSNode naiveMCTSNode = (NaiveMCTSNode)this.children.get(r.nextInt(this.children.size()));
        return naiveMCTSNode;
    }

    public NaiveMCTSNode selectFromAlreadySampledUCB1(float f) throws Exception {
        NaiveMCTSNode naiveMCTSNode = null;
        double d = 0.0;
        for (MCTSNode mCTSNode : this.children) {
            double d2 = mCTSNode.accum_evaluation / (double)mCTSNode.visit_count;
            double d3 = Math.sqrt(Math.log(this.visit_count) / (double)mCTSNode.visit_count);
            d2 = this.type == 0 ? (this.evaluation_bound + d2) / (2.0 * this.evaluation_bound) : (this.evaluation_bound - d2) / (2.0 * this.evaluation_bound);
            double d4 = (double)f * d2 + d3;
            if (naiveMCTSNode != null && !(d4 > d)) continue;
            naiveMCTSNode = (NaiveMCTSNode)mCTSNode;
            d = d4;
        }
        return naiveMCTSNode;
    }

    public NaiveMCTSNode selectLeafUsingLocalMABs(int n, int n2, float f, float f2, float f3, int n3, int n4, int n5) throws Exception {
        Object exception2;
        LinkedList<double[]> linkedList = new LinkedList<double[]>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (UnitActionTableEntry object22 : this.unitActionTable) {
            int n6;
            exception2 = new double[object22.nactions];
            int n7 = -1;
            double d = 0.0;
            int n8 = 0;
            for (n6 = 0; n6 < object22.nactions; ++n6) {
                if (this.type == 0) {
                    if (n7 == -1 || n8 != 0 && object22.visit_count[n6] == 0 || n8 != 0 && object22.accum_evaluation[n6] / (double)object22.visit_count[n6] > d) {
                        n7 = n6;
                        d = object22.visit_count[n6] > 0 ? object22.accum_evaluation[n6] / (double)object22.visit_count[n6] : 0.0;
                        n8 = object22.visit_count[n6];
                    }
                } else if (n7 == -1 || n8 != 0 && object22.visit_count[n6] == 0 || n8 != 0 && object22.accum_evaluation[n6] / (double)object22.visit_count[n6] < d) {
                    n7 = n6;
                    d = object22.visit_count[n6] > 0 ? object22.accum_evaluation[n6] / (double)object22.visit_count[n6] : 0.0;
                    n8 = object22.visit_count[n6];
                }
                exception2[n6] = f / (float)object22.nactions;
            }
            if (object22.visit_count[n7] != 0) {
                exception2[n7] = 1.0f - f + f / (float)object22.nactions;
            } else if (this.forceExplorationOfNonSampledActions) {
                for (n6 = 0; n6 < ((double[])exception2).length; ++n6) {
                    if (object22.visit_count[n6] <= 0) continue;
                    exception2[n6] = 0.0;
                }
            }
            if (DEBUG >= 3) {
                System.out.print("[ ");
                for (n6 = 0; n6 < object22.nactions; ++n6) {
                    System.out.print("(" + object22.visit_count[n6] + "," + object22.accum_evaluation[n6] / (double)object22.visit_count[n6] + ")");
                }
                System.out.println("]");
                System.out.print("[ ");
                for (n6 = 0; n6 < ((Object)exception2).length; ++n6) {
                    System.out.print((double)exception2[n6] + " ");
                }
                System.out.println("]");
            }
            linkedList2.add(linkedList.size());
            linkedList.add((double[])exception2);
        }
        ResourceUsage resourceUsage = new ResourceUsage();
        for (Object exception2 : this.gs.getUnits()) {
            UnitAction n10 = this.gs.getUnitAction((Unit)exception2);
            if (n10 == null) continue;
            ResourceUsage unitAction = n10.resourceUsage((Unit)exception2, this.gs.getPhysicalGameState());
            resourceUsage.merge(unitAction);
        }
        PlayerAction playerAction = new PlayerAction();
        BigInteger bigInteger = BigInteger.ZERO;
        playerAction.setResourceUsage(resourceUsage.clone());
        while (!linkedList2.isEmpty()) {
            int naiveMCTSNode = (Integer)linkedList2.remove(r.nextInt(linkedList2.size()));
            try {
                exception2 = this.unitActionTable.get(naiveMCTSNode);
                double[] dArray = (double[])linkedList.get(naiveMCTSNode);
                int naiveMCTSNode2 = Sampler.weighted(dArray);
                UnitAction unitAction = ((UnitActionTableEntry)exception2).actions.get(naiveMCTSNode2);
                ResourceUsage resourceUsage2 = unitAction.resourceUsage(((UnitActionTableEntry)exception2).u, this.gs.getPhysicalGameState());
                if (!playerAction.getResourceUsage().consistentWith(resourceUsage2, this.gs)) {
                    int n9;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (n9 = 0; n9 < dArray.length; ++n9) {
                        arrayList.add(dArray[n9]);
                        arrayList2.add(n9);
                    }
                    do {
                        n9 = arrayList2.indexOf(naiveMCTSNode2);
                        arrayList.remove(n9);
                        arrayList2.remove(n9);
                        naiveMCTSNode2 = (Integer)Sampler.weighted(arrayList, arrayList2);
                        unitAction = ((UnitActionTableEntry)exception2).actions.get(naiveMCTSNode2);
                        resourceUsage2 = unitAction.resourceUsage(((UnitActionTableEntry)exception2).u, this.gs.getPhysicalGameState());
                    } while (!playerAction.getResourceUsage().consistentWith(resourceUsage2, this.gs));
                }
                if (this.gs.getUnit(((UnitActionTableEntry)exception2).u.getID()) == null) {
                    throw new Error("Issuing an action to an inexisting unit!!!");
                }
                playerAction.getResourceUsage().merge(resourceUsage2);
                playerAction.addUnitAction(((UnitActionTableEntry)exception2).u, unitAction);
                bigInteger = bigInteger.add(BigInteger.valueOf(naiveMCTSNode2).multiply(this.multipliers[naiveMCTSNode]));
            }
            catch (Exception exception3) {
                exception3.printStackTrace();
            }
        }
        NaiveMCTSNode naiveMCTSNode = this.childrenMap.get(bigInteger);
        if (naiveMCTSNode == null) {
            this.actions.add(playerAction);
            exception2 = this.gs.cloneIssue(playerAction);
            NaiveMCTSNode naiveMCTSNode2 = new NaiveMCTSNode(n, n2, ((GameState)exception2).clone(), this, this.evaluation_bound, n5, this.forceExplorationOfNonSampledActions);
            this.childrenMap.put(bigInteger, naiveMCTSNode2);
            this.children.add(naiveMCTSNode2);
            return naiveMCTSNode2;
        }
        return naiveMCTSNode.selectLeaf(n, n2, f, f2, f3, n3, n4, n5);
    }

    public UnitActionTableEntry getActionTableEntry(Unit unit) {
        for (UnitActionTableEntry unitActionTableEntry : this.unitActionTable) {
            if (unitActionTableEntry.u != unit) continue;
            return unitActionTableEntry;
        }
        throw new Error("Could not find Action Table Entry!");
    }

    public void propagateEvaluation(double d, NaiveMCTSNode naiveMCTSNode) {
        this.accum_evaluation += d;
        ++this.visit_count;
        if (naiveMCTSNode != null) {
            int n = this.children.indexOf(naiveMCTSNode);
            PlayerAction playerAction = (PlayerAction)this.actions.get(n);
            for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                UnitActionTableEntry unitActionTableEntry = this.getActionTableEntry((Unit)pair.m_a);
                n = unitActionTableEntry.actions.indexOf(pair.m_b);
                if (n == -1) {
                    System.out.println("Looking for action: " + pair.m_b);
                    System.out.println("Available actions are: " + unitActionTableEntry.actions);
                }
                int n2 = n;
                unitActionTableEntry.accum_evaluation[n2] = unitActionTableEntry.accum_evaluation[n2] + d;
                int n3 = n;
                unitActionTableEntry.visit_count[n3] = unitActionTableEntry.visit_count[n3] + 1;
            }
        }
        if (this.parent != null) {
            ((NaiveMCTSNode)this.parent).propagateEvaluation(d, this);
        }
    }

    public void printUnitActionTable() {
        for (UnitActionTableEntry unitActionTableEntry : this.unitActionTable) {
            System.out.println("Actions for unit " + unitActionTableEntry.u);
            for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                System.out.println("   " + unitActionTableEntry.actions.get(j) + " visited " + unitActionTableEntry.visit_count[j] + " with average evaluation " + unitActionTableEntry.accum_evaluation[j] / (double)unitActionTableEntry.visit_count[j]);
            }
        }
    }
}

