/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.naivemcts;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.naivemcts.NaiveMCTSNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class TwoPhaseNaiveMCTS
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    public EvaluationFunction ef = null;
    Random r = new Random();
    public AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from = null;
    NaiveMCTSNode tree = null;
    int node_creation_ID = 0;
    int n_phase1_iterations_left = -1;
    int n_phase1_milliseconds_left = -1;
    public int MAXSIMULATIONTIME = 1024;
    public int MAX_TREE_DEPTH = 10;
    int playerForThisComputation;
    public float phase1_epsilon_l = 0.3f;
    public float phase1_epsilon_g = 0.0f;
    public float phase1_epsilon_0 = 1.0f;
    public float phase2_epsilon_l = 0.3f;
    public float phase2_epsilon_g = 0.0f;
    public float phase2_epsilon_0 = 0.0f;
    public float phase1_ratio = 0.5f;
    public int phase1_global_strategy = 0;
    public int phase2_global_strategy = 0;
    boolean forceExplorationOfNonSampledActions = true;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    public long total_time = 0L;

    public TwoPhaseNaiveMCTS(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, 10, 0.3f, 0.0f, 1.0f, 0.3f, 0.0f, 0.0f, 0.5f, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3(), true);
    }

    public TwoPhaseNaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6, float f7, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.MAX_TREE_DEPTH = n4;
        this.phase1_epsilon_l = f;
        this.phase1_epsilon_g = f2;
        this.phase1_epsilon_0 = f3;
        this.phase2_epsilon_l = f4;
        this.phase2_epsilon_g = f5;
        this.phase2_epsilon_0 = f6;
        this.phase1_ratio = f7;
        this.ef = evaluationFunction;
        this.forceExplorationOfNonSampledActions = bl;
    }

    public TwoPhaseNaiveMCTS(int n, int n2, int n3, int n4, float f, float f2, float f3, int n5, float f4, float f5, float f6, int n6, float f7, AI aI, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.MAX_TREE_DEPTH = n4;
        this.phase1_epsilon_l = f;
        this.phase1_epsilon_g = f2;
        this.phase1_epsilon_0 = f3;
        this.phase1_global_strategy = n5;
        this.phase2_epsilon_l = f4;
        this.phase2_epsilon_g = f5;
        this.phase2_epsilon_0 = f6;
        this.phase2_global_strategy = n6;
        this.phase1_ratio = f7;
        this.ef = evaluationFunction;
        this.forceExplorationOfNonSampledActions = bl;
    }

    @Override
    public void reset() {
        this.tree = null;
        this.gs_to_start_from = null;
        this.total_runs = 0L;
        this.total_cycles_executed = 0L;
        this.total_actions_issued = 0L;
        this.total_time = 0L;
        this.node_creation_ID = 0;
        this.n_phase1_iterations_left = -1;
        this.n_phase1_milliseconds_left = -1;
    }

    @Override
    public AI clone() {
        return new TwoPhaseNaiveMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.phase1_epsilon_l, this.phase1_epsilon_g, this.phase1_epsilon_0, this.phase2_epsilon_l, this.phase2_epsilon_g, this.phase2_epsilon_0, this.phase1_ratio, this.randomAI, this.ef, this.forceExplorationOfNonSampledActions);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.playerForThisComputation = n;
        this.node_creation_ID = 0;
        this.tree = new NaiveMCTSNode(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState, null, this.ef.upperBound(gameState), this.node_creation_ID++, this.forceExplorationOfNonSampledActions);
        this.max_actions_so_far = Math.max(this.tree.moveGenerator.getSize(), this.max_actions_so_far);
        this.gs_to_start_from = gameState;
        this.n_phase1_iterations_left = -1;
        this.n_phase1_milliseconds_left = -1;
        if (this.ITERATIONS_BUDGET > 0) {
            this.n_phase1_iterations_left = (int)(this.phase1_ratio * (float)this.ITERATIONS_BUDGET);
        }
        if (this.TIME_BUDGET > 0) {
            this.n_phase1_milliseconds_left = (int)(this.phase1_ratio * (float)this.TIME_BUDGET);
        }
    }

    public void resetSearch() {
        if (DEBUG >= 2) {
            System.out.println("Resetting search...");
        }
        this.tree = null;
        this.gs_to_start_from = null;
        this.n_phase1_iterations_left = -1;
        this.n_phase1_milliseconds_left = -1;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l;
        if (DEBUG >= 2) {
            System.out.println("Search...");
        }
        long l2 = l = System.currentTimeMillis();
        long l3 = 0L;
        int n = this.n_phase1_milliseconds_left;
        do {
            if (this.n_phase1_milliseconds_left > 0) {
                this.n_phase1_milliseconds_left = n - (int)(l2 - l);
            }
            if (!this.iteration(this.playerForThisComputation)) break;
            l2 = System.currentTimeMillis();
        } while ((this.TIME_BUDGET < 0 || l2 - l < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++l3 < (long)this.ITERATIONS_BUDGET));
        if (this.n_phase1_milliseconds_left > 0) {
            this.n_phase1_milliseconds_left = n - (int)(l2 - l);
        }
        this.total_time += l2 - l;
        ++this.total_cycles_executed;
    }

    public boolean iteration(int n) throws Exception {
        NaiveMCTSNode naiveMCTSNode;
        if (this.n_phase1_iterations_left > 0 || this.n_phase1_milliseconds_left > 0) {
            naiveMCTSNode = this.tree.selectLeaf(n, 1 - n, this.phase1_epsilon_l, this.phase1_epsilon_g, this.phase1_epsilon_0, this.phase1_global_strategy, this.MAX_TREE_DEPTH, this.node_creation_ID++);
            --this.n_phase1_iterations_left;
        } else {
            naiveMCTSNode = this.tree.selectLeaf(n, 1 - n, this.phase2_epsilon_l, this.phase2_epsilon_g, this.phase2_epsilon_0, this.phase2_global_strategy, this.MAX_TREE_DEPTH, this.node_creation_ID++);
        }
        if (naiveMCTSNode != null) {
            GameState gameState = naiveMCTSNode.gs.clone();
            this.simulate(gameState, gameState.getTime() + this.MAXSIMULATIONTIME);
            int n2 = gameState.getTime() - this.gs_to_start_from.getTime();
            double d = (double)this.ef.evaluate(n, 1 - n, gameState) * Math.pow(0.99, (double)n2 / 10.0);
            naiveMCTSNode.propagateEvaluation((float)d, null);
            ++this.total_runs;
        } else {
            System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
            return false;
        }
        return true;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        int n = this.getMostVisitedActionIdx();
        if (n == -1) {
            if (DEBUG >= 1) {
                System.out.println("TwoPhaseNaiveMCTS no children selected. Returning an empty asction");
            }
            return new PlayerAction();
        }
        if (DEBUG >= 2) {
            this.tree.showNode(0, 1, this.ef);
        }
        if (DEBUG >= 1) {
            NaiveMCTSNode naiveMCTSNode = (NaiveMCTSNode)this.tree.children.get(n);
            System.out.println("TwoPhaseNaiveMCTS selected children " + this.tree.actions.get(n) + " explored " + naiveMCTSNode.visit_count + " Avg evaluation: " + naiveMCTSNode.accum_evaluation / (double)naiveMCTSNode.visit_count);
        }
        return (PlayerAction)this.tree.actions.get(n);
    }

    public int getMostVisitedActionIdx() {
        ++this.total_actions_issued;
        int n = -1;
        NaiveMCTSNode naiveMCTSNode = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int j = 0; j < this.tree.children.size(); ++j) {
            NaiveMCTSNode naiveMCTSNode2 = (NaiveMCTSNode)this.tree.children.get(j);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(j) + " explored " + naiveMCTSNode2.visit_count + " Avg evaluation: " + naiveMCTSNode2.accum_evaluation / (double)naiveMCTSNode2.visit_count);
            }
            if (naiveMCTSNode != null && naiveMCTSNode2.visit_count <= naiveMCTSNode.visit_count) continue;
            naiveMCTSNode = naiveMCTSNode2;
            n = j;
        }
        return n;
    }

    public int getHighestEvaluationActionIdx() {
        ++this.total_actions_issued;
        int n = -1;
        NaiveMCTSNode naiveMCTSNode = null;
        if (DEBUG >= 2) {
            System.out.println("Number of playouts: " + this.tree.visit_count);
            this.tree.printUnitActionTable();
        }
        for (int j = 0; j < this.tree.children.size(); ++j) {
            NaiveMCTSNode naiveMCTSNode2 = (NaiveMCTSNode)this.tree.children.get(j);
            if (DEBUG >= 2) {
                System.out.println("child " + this.tree.actions.get(j) + " explored " + naiveMCTSNode2.visit_count + " Avg evaluation: " + naiveMCTSNode2.accum_evaluation / (double)naiveMCTSNode2.visit_count);
            }
            if (naiveMCTSNode != null && !(naiveMCTSNode2.accum_evaluation / (double)naiveMCTSNode2.visit_count > naiveMCTSNode.accum_evaluation / (double)naiveMCTSNode.visit_count)) continue;
            naiveMCTSNode = naiveMCTSNode2;
            n = j;
        }
        return n;
    }

    public void simulate(GameState gameState, int n) throws Exception {
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.randomAI.getAction(0, gameState));
            gameState.issue(this.randomAI.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    public NaiveMCTSNode getTree() {
        return this.tree;
    }

    public GameState getGameStateToStartFrom() {
        return this.gs_to_start_from;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + "," + this.MAX_TREE_DEPTH + "," + this.phase1_epsilon_l + ", " + this.phase1_epsilon_g + ", " + this.phase1_epsilon_0 + ", " + this.phase2_epsilon_l + ", " + this.phase2_epsilon_g + ", " + this.phase2_epsilon_0 + ", " + this.phase1_ratio + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public String statisticsString() {
        return "Total runs: " + this.total_runs + ", runs per action: " + (float)this.total_runs / (float)this.total_actions_issued + ", runs per cycle: " + (float)this.total_runs / (float)this.total_cycles_executed + ", averate time per cycle: " + (float)this.total_time / (float)this.total_cycles_executed + ", max branching factor: " + this.max_actions_so_far;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        arrayList.add(new ParameterSpecification("E1_l", Float.TYPE, 0.3));
        arrayList.add(new ParameterSpecification("E1_g", Float.TYPE, 0.0));
        arrayList.add(new ParameterSpecification("E1_0", Float.TYPE, 1.0));
        arrayList.add(new ParameterSpecification("E2_l", Float.TYPE, 0.3));
        arrayList.add(new ParameterSpecification("E2_g", Float.TYPE, 0.0));
        arrayList.add(new ParameterSpecification("E2_0", Float.TYPE, 0.0));
        ParameterSpecification parameterSpecification = new ParameterSpecification("Phase1_Ratio", Float.TYPE, 0.5);
        parameterSpecification.setRange(0.0, 1.0);
        arrayList.add(parameterSpecification);
        arrayList.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        arrayList.add(new ParameterSpecification("ForceExplorationOfNonSampledActions", Boolean.TYPE, true));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int n) {
        this.MAXSIMULATIONTIME = n;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int n) {
        this.MAX_TREE_DEPTH = n;
    }

    public float getE1_l() {
        return this.phase1_epsilon_l;
    }

    public void setE1_l(float f) {
        this.phase1_epsilon_l = f;
    }

    public float getE1_g() {
        return this.phase1_epsilon_g;
    }

    public void setE1_g(float f) {
        this.phase1_epsilon_g = f;
    }

    public float getE1_0() {
        return this.phase1_epsilon_0;
    }

    public void setE1_0(float f) {
        this.phase1_epsilon_0 = f;
    }

    public float getE2_l() {
        return this.phase2_epsilon_l;
    }

    public void setE2_l(float f) {
        this.phase2_epsilon_l = f;
    }

    public float getE2_g() {
        return this.phase2_epsilon_g;
    }

    public void setE2_g(float f) {
        this.phase2_epsilon_g = f;
    }

    public float getE2_0() {
        return this.phase2_epsilon_0;
    }

    public void setE2_0(float f) {
        this.phase2_epsilon_0 = f;
    }

    public float getPhase1_Ratio() {
        return this.phase1_ratio;
    }

    public void setPhase1_Ratio(float f) {
        this.phase1_ratio = f;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI aI) {
        this.randomAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }

    public boolean getForceExplorationOfNonSampledActions() {
        return this.forceExplorationOfNonSampledActions;
    }

    public void setForceExplorationOfNonSampledActions(boolean bl) {
        this.forceExplorationOfNonSampledActions = bl;
    }
}

