/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.uct.DownsamplingUCTNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class DownsamplingUCT
extends AIWithComputationBudget
implements InterruptibleAI {
    public static final int DEBUG = 0;
    EvaluationFunction ef = null;
    Random r = new Random();
    AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from = null;
    DownsamplingUCTNode tree = null;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    long MAXACTIONS = 100L;
    int MAXSIMULATIONTIME = 1024;
    int MAX_TREE_DEPTH = 10;
    int playerForThisComputation;

    public DownsamplingUCT(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, 100L, 10, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public DownsamplingUCT(int n, int n2, int n3, long l, int n4, AI aI, EvaluationFunction evaluationFunction) {
        super(n, n2);
        this.MAXACTIONS = l;
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.MAX_TREE_DEPTH = n4;
        this.ef = evaluationFunction;
    }

    @Override
    public void printStats() {
        if (this.total_cycles_executed > 0L && this.total_actions_issued > 0L) {
            System.out.println("Average runs per cycle: " + (double)this.total_runs / (double)this.total_cycles_executed);
            System.out.println("Average runs per action: " + (double)this.total_runs / (double)this.total_actions_issued);
        }
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.tree = null;
    }

    @Override
    public AI clone() {
        return new DownsamplingUCT(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAXACTIONS, this.MAX_TREE_DEPTH, this.randomAI, this.ef);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.playerForThisComputation = n;
        float f = this.ef.upperBound(gameState);
        this.tree = new DownsamplingUCTNode(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState, null, this.MAXACTIONS, f);
        this.gs_to_start_from = gameState;
    }

    public void resetSearch() {
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l = System.currentTimeMillis();
        long l2 = this.TIME_BUDGET > 0 ? l + (long)this.TIME_BUDGET : 0L;
        long l3 = l;
        long l4 = 0L;
        do {
            DownsamplingUCTNode downsamplingUCTNode;
            if ((downsamplingUCTNode = this.tree.UCTSelectLeaf(this.playerForThisComputation, 1 - this.playerForThisComputation, this.MAXACTIONS, l2, this.MAX_TREE_DEPTH)) == null) {
                System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
                break;
            }
            GameState gameState = downsamplingUCTNode.gs.clone();
            this.simulate(gameState, gameState.getTime() + this.MAXSIMULATIONTIME);
            int n = gameState.getTime() - this.gs_to_start_from.getTime();
            double d = (double)this.ef.evaluate(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState) * Math.pow(0.99, (double)n / 10.0);
            while (downsamplingUCTNode != null) {
                downsamplingUCTNode.accum_evaluation = (float)((double)downsamplingUCTNode.accum_evaluation + d);
                ++downsamplingUCTNode.visit_count;
                downsamplingUCTNode = downsamplingUCTNode.parent;
            }
            ++this.total_runs;
            l3 = System.currentTimeMillis();
        } while ((this.TIME_BUDGET < 0 || l3 - l < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++l4 < (long)this.ITERATIONS_BUDGET));
        ++this.total_cycles_executed;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        ++this.total_actions_issued;
        int n = -1;
        DownsamplingUCTNode downsamplingUCTNode = null;
        for (int j = 0; j < this.tree.children.size(); ++j) {
            DownsamplingUCTNode downsamplingUCTNode2 = this.tree.children.get(j);
            if (downsamplingUCTNode != null && downsamplingUCTNode2.visit_count <= downsamplingUCTNode.visit_count) continue;
            downsamplingUCTNode = downsamplingUCTNode2;
            n = j;
        }
        if (n == -1) {
            System.err.println("DownsamplingUCT.getBestActionSoFar: mostVisitedIdx == -1!!! tree.children.size() = " + this.tree.children.size());
            return this.tree.moveGenerator.getRandom();
        }
        return this.tree.actions.get(n);
    }

    public void simulate(GameState gameState, int n) throws Exception {
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.randomAI.getAction(0, gameState));
            gameState.issue(this.randomAI.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + ", " + this.MAXACTIONS + ", " + this.MAX_TREE_DEPTH + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxActions", Long.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        arrayList.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int n) {
        this.MAXSIMULATIONTIME = n;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int n) {
        this.MAX_TREE_DEPTH = n;
    }

    public long getMaxActions() {
        return this.MAXACTIONS;
    }

    public void setMaxActions(long l) {
        this.MAXACTIONS = l;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI aI) {
        this.randomAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }
}

