/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;

public class DownsamplingUCTNode {
    public static int DEBUG = 0;
    static Random r = new Random();
    static float C = 0.05f;
    public int type;
    DownsamplingUCTNode parent = null;
    public GameState gs;
    int depth = 0;
    boolean hasMoreActions = true;
    PlayerActionGenerator moveGenerator = null;
    public List<PlayerAction> actions = null;
    public List<DownsamplingUCTNode> children = null;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;

    public DownsamplingUCTNode(int n, int n2, GameState gameState, DownsamplingUCTNode downsamplingUCTNode, long l, float f) throws Exception {
        this.parent = downsamplingUCTNode;
        this.gs = gameState;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = f;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(n) || this.gs.canExecuteAnyAction(n2))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(n)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(gameState, n);
            this.moveGenerator.randomizeOrder();
        } else if (this.gs.canExecuteAnyAction(n2)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(gameState, n2);
            this.moveGenerator.randomizeOrder();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public DownsamplingUCTNode UCTSelectLeaf(int n, int n2, long l, long l2, int n3) throws Exception {
        if (this.depth >= n3) {
            return this;
        }
        if (this.moveGenerator != null && this.actions == null) {
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<DownsamplingUCTNode>();
            if (this.moveGenerator.getSize() > 2L * l) {
                int n4 = 0;
                while ((long)n4 < l) {
                    this.actions.add(this.moveGenerator.getRandom());
                    ++n4;
                }
            } else {
                PlayerAction playerAction = null;
                long l3 = 0L;
                do {
                    if ((playerAction = this.moveGenerator.getNextAction(l2)) == null) continue;
                    this.actions.add(playerAction);
                    if (++l3 >= 2L * l) break;
                } while (playerAction != null);
                while ((long)this.actions.size() > l) {
                    this.actions.remove(r.nextInt(this.actions.size()));
                }
            }
        }
        if (this.hasMoreActions) {
            if (this.moveGenerator == null) {
                return this;
            }
            if (this.children.size() >= this.actions.size()) {
                this.hasMoreActions = false;
            } else {
                PlayerAction playerAction = this.actions.get(this.children.size());
                GameState gameState = this.gs.cloneIssue(playerAction);
                DownsamplingUCTNode downsamplingUCTNode = new DownsamplingUCTNode(n, n2, gameState.clone(), this, l, this.evaluation_bound);
                this.children.add(downsamplingUCTNode);
                return downsamplingUCTNode;
            }
        }
        double d = 0.0;
        DownsamplingUCTNode downsamplingUCTNode = null;
        for (int j = 0; j < this.children.size(); ++j) {
            DownsamplingUCTNode downsamplingUCTNode2 = this.children.get(j);
            double d2 = (double)downsamplingUCTNode2.accum_evaluation / (double)downsamplingUCTNode2.visit_count;
            double d3 = Math.sqrt(Math.log(this.visit_count) / (double)downsamplingUCTNode2.visit_count);
            d2 = this.type == 0 ? (d2 + (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound) : -(d2 - (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound);
            double d4 = (double)C * d2 + d3;
            if (downsamplingUCTNode != null && !(d4 > d)) continue;
            downsamplingUCTNode = downsamplingUCTNode2;
            d = d4;
        }
        if (downsamplingUCTNode == null) {
            return this;
        }
        return downsamplingUCTNode.UCTSelectLeaf(n, n2, l, l2, n3);
    }

    public void showNode(int n, int n2) {
        if (this.children != null) {
            for (int j = 0; j < this.children.size(); ++j) {
                DownsamplingUCTNode downsamplingUCTNode = this.children.get(j);
                for (int k = 0; k < n; ++k) {
                    System.out.print("    ");
                }
                System.out.println("child " + this.actions.get(j) + " explored " + downsamplingUCTNode.visit_count + " Avg evaluation: " + (double)downsamplingUCTNode.accum_evaluation / (double)downsamplingUCTNode.visit_count);
                if (n >= n2) continue;
                downsamplingUCTNode.showNode(n + 1, n2);
            }
        }
    }
}

