/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.uct.UCTNodeFirstPlayUrgency;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class UCTFirstPlayUrgency
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    EvaluationFunction ef = null;
    Random r = new Random();
    AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from = null;
    public UCTNodeFirstPlayUrgency tree = null;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    long total_runs_this_move = 0L;
    int MAXSIMULATIONTIME = 1024;
    int MAX_TREE_DEPTH = 10;
    int playerForThisComputation;
    double FPUvalue = 0.0;

    public UCTFirstPlayUrgency(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, 10, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3(), 0.0);
    }

    public UCTFirstPlayUrgency(int n, int n2, int n3, int n4, AI aI, EvaluationFunction evaluationFunction, double d) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.MAX_TREE_DEPTH = n4;
        this.ef = evaluationFunction;
        this.FPUvalue = d;
    }

    @Override
    public void printStats() {
        if (this.total_cycles_executed > 0L && this.total_actions_issued > 0L) {
            System.out.println("Average runs per cycle: " + (double)this.total_runs / (double)this.total_cycles_executed);
            System.out.println("Average runs per action: " + (double)this.total_runs / (double)this.total_actions_issued);
        }
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.tree = null;
        this.total_runs_this_move = 0L;
    }

    @Override
    public AI clone() {
        return new UCTFirstPlayUrgency(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.randomAI, this.ef, this.FPUvalue);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.playerForThisComputation = n;
        float f = this.ef.upperBound(gameState);
        this.tree = new UCTNodeFirstPlayUrgency(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState, null, f, this.FPUvalue);
        this.gs_to_start_from = gameState;
        this.total_runs_this_move = 0L;
    }

    public void resetSearch() {
        if (DEBUG >= 2) {
            System.out.println("Resetting search...");
        }
        this.tree = null;
        this.gs_to_start_from = null;
        this.total_runs_this_move = 0L;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        if (DEBUG >= 2) {
            System.out.println("Search...");
        }
        long l = System.currentTimeMillis();
        int n = 0;
        long l2 = l + (long)this.TIME_BUDGET;
        if (this.TIME_BUDGET <= 0) {
            l2 = 0L;
        }
        while (!(l2 > 0L && System.currentTimeMillis() >= l2 || this.ITERATIONS_BUDGET > 0 && n >= this.ITERATIONS_BUDGET)) {
            this.monteCarloRun(this.playerForThisComputation, l2);
            ++n;
        }
        ++this.total_cycles_executed;
    }

    public double monteCarloRun(int n, long l) throws Exception {
        UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency = this.tree.UCTSelectLeaf(n, 1 - n, l, this.MAX_TREE_DEPTH);
        if (uCTNodeFirstPlayUrgency != null) {
            GameState gameState = uCTNodeFirstPlayUrgency.gs.clone();
            this.simulate(gameState, gameState.getTime() + this.MAXSIMULATIONTIME);
            int n2 = gameState.getTime() - this.gs_to_start_from.getTime();
            double d = (double)this.ef.evaluate(n, 1 - n, gameState) * Math.pow(0.99, (double)n2 / 10.0);
            while (uCTNodeFirstPlayUrgency != null) {
                uCTNodeFirstPlayUrgency.accum_evaluation = (float)((double)uCTNodeFirstPlayUrgency.accum_evaluation + d);
                ++uCTNodeFirstPlayUrgency.visit_count;
                uCTNodeFirstPlayUrgency = uCTNodeFirstPlayUrgency.parent;
            }
            ++this.total_runs;
            ++this.total_runs_this_move;
            return d;
        }
        return this.ef.evaluate(n, 1 - n, this.gs_to_start_from);
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        ++this.total_actions_issued;
        if (this.tree.children == null) {
            if (DEBUG >= 1) {
                System.out.println(this.getClass().getSimpleName() + " no children selected. Returning an empty asction");
            }
            return new PlayerAction();
        }
        int n = -1;
        UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency = null;
        for (int j = 0; j < this.tree.children.size(); ++j) {
            UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency2 = this.tree.children.get(j);
            if (uCTNodeFirstPlayUrgency != null && uCTNodeFirstPlayUrgency2.visit_count <= uCTNodeFirstPlayUrgency.visit_count) continue;
            uCTNodeFirstPlayUrgency = uCTNodeFirstPlayUrgency2;
            n = j;
        }
        if (DEBUG >= 2) {
            System.out.println("--- Tree: ----");
            this.tree.showNode(0, 1);
        }
        if (DEBUG >= 1) {
            System.out.println(this.getClass().getSimpleName() + " performed " + this.total_runs_this_move + " playouts.");
        }
        if (DEBUG >= 1) {
            System.out.println(this.getClass().getSimpleName() + " selected children " + this.tree.actions.get(n) + " explored " + uCTNodeFirstPlayUrgency.visit_count + " Avg evaluation: " + (double)uCTNodeFirstPlayUrgency.accum_evaluation / (double)uCTNodeFirstPlayUrgency.visit_count);
        }
        if (n == -1) {
            return new PlayerAction();
        }
        return this.tree.actions.get(n);
    }

    public float getBestActionEvaluation(GameState gameState, int n, int n2) throws Exception {
        PlayerAction playerAction = this.getBestActionSoFar();
        if (playerAction == null) {
            return 0.0f;
        }
        float f = 0.0f;
        for (int j = 0; j < n2; ++j) {
            GameState gameState2 = gameState.cloneIssue(playerAction);
            GameState gameState3 = gameState2.clone();
            this.simulate(gameState3, gameState3.getTime() + this.MAXSIMULATIONTIME);
            int n3 = gameState3.getTime() - gameState2.getTime();
            f += (float)((double)this.ef.evaluate(n, 1 - n, gameState3) * Math.pow(0.99, (double)n3 / 10.0));
        }
        return f / (float)n2;
    }

    public void simulate(GameState gameState, int n) throws Exception {
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.randomAI.getAction(0, gameState));
            gameState.issue(this.randomAI.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + ", " + this.MAX_TREE_DEPTH + ", " + this.randomAI + ", " + this.ef + ", " + this.FPUvalue + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        arrayList.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        arrayList.add(new ParameterSpecification("FPU", Double.TYPE, 0.0));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int n) {
        this.MAXSIMULATIONTIME = n;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int n) {
        this.MAX_TREE_DEPTH = n;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI aI) {
        this.randomAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }

    public double getFPU() {
        return this.FPUvalue;
    }

    public void setFPU(double d) {
        this.FPUvalue = d;
    }
}

