/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;

public class UCTNode {
    static Random r = new Random();
    public static float C = 0.05f;
    public int type;
    UCTNode parent = null;
    public GameState gs;
    int depth = 0;
    boolean hasMoreActions = true;
    PlayerActionGenerator moveGenerator = null;
    public List<PlayerAction> actions = null;
    public List<UCTNode> children = null;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;

    public UCTNode(int n, int n2, GameState gameState, UCTNode uCTNode, float f) throws Exception {
        this.parent = uCTNode;
        this.gs = gameState;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = f;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(n) || this.gs.canExecuteAnyAction(n2))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(n)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(gameState, n);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNode>();
        } else if (this.gs.canExecuteAnyAction(n2)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(gameState, n2);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNode>();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public UCTNode UCTSelectLeaf(int n, int n2, long l, int n3) throws Exception {
        if (this.depth >= n3) {
            return this;
        }
        if (this.hasMoreActions) {
            if (this.moveGenerator == null) {
                return this;
            }
            PlayerAction playerAction = this.moveGenerator.getNextAction(l);
            if (playerAction != null) {
                this.actions.add(playerAction);
                GameState gameState = this.gs.cloneIssue(playerAction);
                UCTNode uCTNode = new UCTNode(n, n2, gameState.clone(), this, this.evaluation_bound);
                this.children.add(uCTNode);
                return uCTNode;
            }
            this.hasMoreActions = false;
        }
        double d = 0.0;
        UCTNode uCTNode = null;
        for (UCTNode uCTNode2 : this.children) {
            double d2 = this.childValue(uCTNode2);
            if (uCTNode != null && !(d2 > d)) continue;
            uCTNode = uCTNode2;
            d = d2;
        }
        if (uCTNode == null) {
            return this;
        }
        return uCTNode.UCTSelectLeaf(n, n2, l, n3);
    }

    public double childValue(UCTNode uCTNode) {
        double d = (double)uCTNode.accum_evaluation / (double)uCTNode.visit_count;
        double d2 = Math.sqrt(Math.log(this.visit_count) / (double)uCTNode.visit_count);
        d = this.type == 0 ? ((double)this.evaluation_bound + d) / (double)(2.0f * this.evaluation_bound) : ((double)this.evaluation_bound - d) / (double)(2.0f * this.evaluation_bound);
        double d3 = (double)C * d + d2;
        return d3;
    }

    public void showNode(int n, int n2) {
        int n3 = -1;
        Object var4_4 = null;
        for (int j = 0; j < this.children.size(); ++j) {
            UCTNode uCTNode = this.children.get(j);
            for (int k = 0; k < n; ++k) {
                System.out.print("    ");
            }
            System.out.println("child explored " + uCTNode.visit_count + " Avg evaluation: " + (double)uCTNode.accum_evaluation / (double)uCTNode.visit_count + " : " + this.actions.get(j));
            if (n >= n2) continue;
            uCTNode.showNode(n + 1, n2);
        }
    }
}

