/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;

public class UCTNodeFirstPlayUrgency {
    public static int DEBUG = 0;
    static Random r = new Random();
    public static float C = 0.05f;
    public int type;
    UCTNodeFirstPlayUrgency parent = null;
    public GameState gs;
    int depth = 0;
    boolean hasMoreActions = true;
    PlayerActionGenerator moveGenerator = null;
    public List<PlayerAction> actions = null;
    HashMap<Long, UCTNodeFirstPlayUrgency> childrenMap = new LinkedHashMap<Long, UCTNodeFirstPlayUrgency>();
    public List<UCTNodeFirstPlayUrgency> children = null;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;
    double FPUvalue = 0.0;

    public UCTNodeFirstPlayUrgency(int n, int n2, GameState gameState, UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency, float f, double d) throws Exception {
        this.parent = uCTNodeFirstPlayUrgency;
        this.gs = gameState;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.evaluation_bound = f;
        this.FPUvalue = d;
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(n) || this.gs.canExecuteAnyAction(n2))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(n)) {
            this.type = 0;
            this.moveGenerator = new PlayerActionGenerator(gameState, n);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNodeFirstPlayUrgency>();
        } else if (this.gs.canExecuteAnyAction(n2)) {
            this.type = 1;
            this.moveGenerator = new PlayerActionGenerator(gameState, n2);
            this.moveGenerator.randomizeOrder();
            this.actions = new ArrayList<PlayerAction>();
            this.children = new ArrayList<UCTNodeFirstPlayUrgency>();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public UCTNodeFirstPlayUrgency UCTSelectLeaf(int n, int n2, long l, int n3) throws Exception {
        if (this.depth >= n3) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        double d = 0.0;
        UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency = null;
        if (DEBUG >= 1) {
            System.out.println("UCTNodeFirstPlayUrgency.UCTSelectLeaf:");
        }
        for (int j = 0; j < this.children.size(); ++j) {
            UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency2 = this.children.get(j);
            double d2 = this.childValue(uCTNodeFirstPlayUrgency2);
            if (DEBUG >= 1) {
                System.out.println("  " + d2);
            }
            if (uCTNodeFirstPlayUrgency != null && !(d2 > d)) continue;
            uCTNodeFirstPlayUrgency = uCTNodeFirstPlayUrgency2;
            d = d2;
        }
        if (uCTNodeFirstPlayUrgency != null && d > this.FPUvalue) {
            return uCTNodeFirstPlayUrgency.UCTSelectLeaf(n, n2, l, n3);
        }
        if (this.moveGenerator != null) {
            int n4;
            PlayerAction playerAction = this.moveGenerator.getRandom();
            long l2 = this.moveGenerator.getActionIndex(playerAction);
            for (n4 = 50; this.childrenMap.containsKey(l2) && n4 > 0; --n4) {
                playerAction = this.moveGenerator.getRandom();
                l2 = this.moveGenerator.getActionIndex(playerAction);
            }
            if (n4 > 0) {
                this.actions.add(playerAction);
                GameState gameState = this.gs.cloneIssue(playerAction);
                UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency3 = new UCTNodeFirstPlayUrgency(n, n2, gameState.clone(), this, this.evaluation_bound, this.FPUvalue);
                this.children.add(uCTNodeFirstPlayUrgency3);
                this.childrenMap.put(l2, uCTNodeFirstPlayUrgency3);
                return uCTNodeFirstPlayUrgency3;
            }
        }
        if (uCTNodeFirstPlayUrgency == null) {
            return this;
        }
        return uCTNodeFirstPlayUrgency.UCTSelectLeaf(n, n2, l, n3);
    }

    public double childValue(UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency) {
        double d = (double)uCTNodeFirstPlayUrgency.accum_evaluation / (double)uCTNodeFirstPlayUrgency.visit_count;
        double d2 = Math.sqrt(Math.log(this.visit_count) / (double)uCTNodeFirstPlayUrgency.visit_count);
        d = this.type == 0 ? (d + (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound) : -(d - (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound);
        double d3 = d + (double)C * d2;
        return d3;
    }

    public void showNode(int n, int n2) {
        int n3 = -1;
        Object var4_4 = null;
        for (int j = 0; j < this.children.size(); ++j) {
            UCTNodeFirstPlayUrgency uCTNodeFirstPlayUrgency = this.children.get(j);
            for (int k = 0; k < n; ++k) {
                System.out.print("    ");
            }
            System.out.println("child explored " + uCTNodeFirstPlayUrgency.visit_count + " Avg evaluation: " + (double)uCTNodeFirstPlayUrgency.accum_evaluation / (double)uCTNodeFirstPlayUrgency.visit_count + " : " + this.actions.get(j));
            if (n >= n2) continue;
            uCTNodeFirstPlayUrgency.showNode(n + 1, n2);
        }
    }
}

