/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.uct.UCTUnitActionsNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class UCTUnitActions
extends AIWithComputationBudget
implements InterruptibleAI {
    public static final int DEBUG = 0;
    EvaluationFunction ef = null;
    Random r = new Random();
    AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    GameState gs_to_start_from = null;
    UCTUnitActionsNode tree = null;
    int MAX_TREE_DEPTH = 10;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    int MAXSIMULATIONTIME = 1024;
    int playerForThisComputation;

    public UCTUnitActions(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, 10, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public UCTUnitActions(int n, int n2, int n3, int n4, AI aI, EvaluationFunction evaluationFunction) {
        super(n, n2);
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.MAX_TREE_DEPTH = n4;
        this.ef = evaluationFunction;
    }

    @Override
    public void printStats() {
        if (this.total_cycles_executed > 0L && this.total_actions_issued > 0L) {
            System.out.println("Average runs per cycle: " + (double)this.total_runs / (double)this.total_cycles_executed);
            System.out.println("Average runs per action: " + (double)this.total_runs / (double)this.total_actions_issued);
        }
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.tree = null;
    }

    @Override
    public AI clone() {
        return new UCTUnitActions(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAX_TREE_DEPTH, this.randomAI, this.ef);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) {
        this.playerForThisComputation = n;
        float f = this.ef.upperBound(gameState);
        this.tree = new UCTUnitActionsNode(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState, null, f);
        this.gs_to_start_from = gameState;
    }

    public void resetSearch() {
        this.tree = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l;
        long l2 = l = System.currentTimeMillis();
        long l3 = 0L;
        do {
            UCTUnitActionsNode uCTUnitActionsNode;
            if ((uCTUnitActionsNode = this.tree.UCTSelectLeaf(this.playerForThisComputation, 1 - this.playerForThisComputation, this.MAX_TREE_DEPTH)) == null) {
                System.err.println(this.getClass().getSimpleName() + ": claims there are no more leafs to explore...");
                break;
            }
            GameState gameState = uCTUnitActionsNode.gs.clone();
            this.simulate(gameState, gameState.getTime() + this.MAXSIMULATIONTIME);
            int n = gameState.getTime() - this.gs_to_start_from.getTime();
            double d = (double)this.ef.evaluate(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState) * Math.pow(0.99, (double)n / 10.0);
            while (uCTUnitActionsNode != null) {
                uCTUnitActionsNode.accum_evaluation = (float)((double)uCTUnitActionsNode.accum_evaluation + d);
                ++uCTUnitActionsNode.visit_count;
                uCTUnitActionsNode = uCTUnitActionsNode.parent;
            }
            ++this.total_runs;
            l2 = System.currentTimeMillis();
        } while ((this.TIME_BUDGET < 0 || l2 - l < (long)this.TIME_BUDGET) && (this.ITERATIONS_BUDGET < 0 || ++l3 < (long)this.ITERATIONS_BUDGET));
        ++this.total_cycles_executed;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        if (this.tree.children == null) {
            return new PlayerAction();
        }
        return this.getMostVisited(this.tree, this.gs_to_start_from.getTime());
    }

    public PlayerAction getMostVisited(UCTUnitActionsNode uCTUnitActionsNode, int n) {
        Object object;
        if (uCTUnitActionsNode.type != 0 || uCTUnitActionsNode.gs.getTime() != n) {
            return null;
        }
        int n2 = -1;
        UCTUnitActionsNode uCTUnitActionsNode2 = null;
        for (int j = 0; j < uCTUnitActionsNode.children.size(); ++j) {
            object = uCTUnitActionsNode.children.get(j);
            if (uCTUnitActionsNode2 != null && ((UCTUnitActionsNode)object).visit_count <= uCTUnitActionsNode2.visit_count) continue;
            uCTUnitActionsNode2 = object;
            n2 = j;
        }
        if (n2 == -1) {
            return null;
        }
        PlayerAction playerAction = uCTUnitActionsNode.actions.get(n2);
        object = this.getMostVisited(uCTUnitActionsNode2, n);
        if (object != null) {
            playerAction = playerAction.merge((PlayerAction)object);
        }
        return playerAction;
    }

    public void simulate(GameState gameState, int n) throws Exception {
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.randomAI.getAction(0, gameState));
            gameState.issue(this.randomAI.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.MAXSIMULATIONTIME + ", " + this.MAX_TREE_DEPTH + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxTreeDepth", Integer.TYPE, 10));
        arrayList.add(new ParameterSpecification("DefaultPolicy", AI.class, this.randomAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int n) {
        this.MAXSIMULATIONTIME = n;
    }

    public int getMaxTreeDepth() {
        return this.MAX_TREE_DEPTH;
    }

    public void setMaxTreeDepth(int n) {
        this.MAX_TREE_DEPTH = n;
    }

    public AI getDefaultPolicy() {
        return this.randomAI;
    }

    public void setDefaultPolicy(AI aI) {
        this.randomAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }
}

