/*
 * Decompiled with CFR 0.152.
 */
package ai.mcts.uct;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.Unit;

public class UCTUnitActionsNode {
    static Random r = new Random();
    static float C = 0.05f;
    public int type;
    UCTUnitActionsNode parent = null;
    public GameState gs;
    int depth = 0;
    public List<PlayerAction> actions = null;
    public List<UCTUnitActionsNode> children = null;
    float evaluation_bound = 0.0f;
    float accum_evaluation = 0.0f;
    int visit_count = 0;

    public UCTUnitActionsNode(int n, int n2, GameState gameState, UCTUnitActionsNode uCTUnitActionsNode, float f) {
        this.parent = uCTUnitActionsNode;
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.gs = gameState;
        this.evaluation_bound = f;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        while (!(this.gs.winner() != -1 || this.gs.gameover() || this.gs.canExecuteAnyAction(n) || this.gs.canExecuteAnyAction(n2))) {
            this.gs.cycle();
        }
        if (this.gs.winner() != -1 || this.gs.gameover()) {
            this.type = -1;
        } else if (this.gs.canExecuteAnyAction(n)) {
            this.type = 0;
            this.actions = null;
            for (Unit unit : physicalGameState.getUnits()) {
                if (unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
                this.actions = gameState.getPlayerActionsSingleUnit(n, unit);
                break;
            }
            if (this.actions == null) {
                System.err.println("UCTUnitActionNode: error when generating maxplayer node!");
            }
            this.children = new ArrayList<UCTUnitActionsNode>();
        } else if (this.gs.canExecuteAnyAction(n2)) {
            this.type = 1;
            this.actions = null;
            for (Unit unit : physicalGameState.getUnits()) {
                if (unit.getPlayer() != n2 || gameState.getActionAssignment(unit) != null) continue;
                this.actions = gameState.getPlayerActionsSingleUnit(n2, unit);
                break;
            }
            if (this.actions == null) {
                System.err.println("UCTUnitActionNode: error when generating minplayer node!");
            }
            this.children = new ArrayList<UCTUnitActionsNode>();
        } else {
            this.type = -1;
            System.err.println("RTMCTSNode: This should not have happened...");
        }
    }

    public UCTUnitActionsNode UCTSelectLeaf(int n, int n2, int n3) {
        PlayerAction playerAction;
        if (this.depth >= n3) {
            return this;
        }
        if (this.children == null || this.actions == null) {
            return this;
        }
        if (this.children.size() < this.actions.size() && (playerAction = this.actions.get(this.children.size())) != null) {
            GameState gameState = this.gs.cloneIssue(playerAction);
            UCTUnitActionsNode uCTUnitActionsNode = new UCTUnitActionsNode(n, n2, gameState.clone(), this, this.evaluation_bound);
            this.children.add(uCTUnitActionsNode);
            return uCTUnitActionsNode;
        }
        double d = 0.0;
        UCTUnitActionsNode uCTUnitActionsNode = null;
        for (int j = 0; j < this.children.size(); ++j) {
            UCTUnitActionsNode uCTUnitActionsNode2 = this.children.get(j);
            double d2 = (double)uCTUnitActionsNode2.accum_evaluation / (double)uCTUnitActionsNode2.visit_count;
            double d3 = Math.sqrt(Math.log((double)this.visit_count / (double)uCTUnitActionsNode2.visit_count));
            d2 = this.type == 0 ? (d2 + (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound) : -(d2 - (double)this.evaluation_bound) / (double)(2.0f * this.evaluation_bound);
            double d4 = (double)C * d2 + d3;
            if (uCTUnitActionsNode != null && !(d4 > d)) continue;
            uCTUnitActionsNode = uCTUnitActionsNode2;
            d = d4;
        }
        if (uCTUnitActionsNode == null) {
            return this;
        }
        return uCTUnitActionsNode.UCTSelectLeaf(n, n2, n3);
    }

    public void showNode(int n, int n2) {
        int n3 = -1;
        Object var4_4 = null;
        for (int j = 0; j < this.children.size(); ++j) {
            UCTUnitActionsNode uCTUnitActionsNode = this.children.get(j);
            for (int k = 0; k < n; ++k) {
                System.out.print("    ");
            }
            System.out.println("child " + this.actions.get(j) + " explored " + uCTUnitActionsNode.visit_count + " Avg evaluation: " + (double)uCTUnitActionsNode.accum_evaluation / (double)uCTUnitActionsNode.visit_count);
            if (n >= n2) continue;
            uCTUnitActionsNode.showNode(n + 1, n2);
        }
    }
}

