/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.ABCD;

import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.MiniMaxResult;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;

public class ABCD
extends AI {
    public static int DEBUG = 0;
    int nLeaves = 0;
    int nNodes = 0;
    int max_depth_so_far = 0;
    long max_branching_so_far = 0L;
    long max_leaves_so_far = 0L;
    long max_nodes_so_far = 0L;
    int MAXDEPTH = 4;
    AI playoutAI = null;
    int maxPlayoutTime = 100;
    EvaluationFunction ef = null;
    protected int defaultNONEduration = 8;

    public ABCD(UnitTypeTable unitTypeTable) {
        this(4, new WorkerRush(unitTypeTable, new AStarPathFinding()), 100, new SimpleSqrtEvaluationFunction3());
    }

    public ABCD(int n, AI aI, int n2, EvaluationFunction evaluationFunction) {
        this.MAXDEPTH = n;
        this.playoutAI = aI;
        this.maxPlayoutTime = n2;
        this.ef = evaluationFunction;
    }

    @Override
    public void reset() {
        this.max_depth_so_far = 0;
        this.max_branching_so_far = 0L;
        this.max_leaves_so_far = 0L;
        this.max_nodes_so_far = 0L;
    }

    @Override
    public AI clone() {
        return new ABCD(this.MAXDEPTH, this.playoutAI, this.maxPlayoutTime, this.ef);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n) && gameState.winner() == -1) {
            PlayerAction playerAction = this.ABCD(n, gameState, this.MAXDEPTH);
            playerAction.fillWithNones(gameState, n, this.defaultNONEduration);
            return playerAction;
        }
        return new PlayerAction();
    }

    public PlayerAction ABCD(int n, GameState gameState, int n2) throws Exception {
        long l = System.currentTimeMillis();
        float f = -EvaluationFunction.VICTORY;
        float f2 = EvaluationFunction.VICTORY;
        int n3 = n;
        int n4 = 1 - n;
        if (DEBUG >= 1) {
            System.out.println("Starting ABCD... " + n);
        }
        if ((long)this.nLeaves > this.max_leaves_so_far) {
            this.max_leaves_so_far = this.nLeaves;
        }
        if ((long)this.nNodes > this.max_nodes_so_far) {
            this.max_nodes_so_far = this.nNodes;
        }
        this.nLeaves = 0;
        this.nNodes = 0;
        MiniMaxResult miniMaxResult = this.ABCD(gameState, n3, n4, f, f2, n2, n3);
        if (DEBUG >= 1) {
            System.out.println("ABCD: " + miniMaxResult + " in " + (System.currentTimeMillis() - l));
        }
        return miniMaxResult.action;
    }

    public MiniMaxResult ABCD(GameState gameState, int n, int n2, float f, float f2, int n3, int n4) throws Exception {
        ++this.nNodes;
        if (n3 <= 0 || gameState.winner() != -1) {
            ++this.nLeaves;
            GameState gameState2 = gameState.clone();
            AI aI = this.playoutAI.clone();
            AI aI2 = this.playoutAI.clone();
            int n5 = gameState2.getTime() + this.maxPlayoutTime;
            boolean bl = false;
            while (!bl && gameState2.getTime() < n5) {
                if (gameState2.isComplete()) {
                    bl = gameState2.cycle();
                    continue;
                }
                gameState2.issue(aI.getAction(0, gameState2));
                gameState2.issue(aI2.getAction(1, gameState2));
            }
            return new MiniMaxResult(null, this.ef.evaluate(n, n2, gameState2), gameState2);
        }
        int n6 = -1;
        if (gameState.canExecuteAnyAction(n)) {
            if (gameState.canExecuteAnyAction(n2)) {
                n6 = n4;
                n4 = 1 - n4;
            } else {
                n6 = n;
            }
        } else if (gameState.canExecuteAnyAction(n2)) {
            n6 = n2;
        }
        if (n6 == n) {
            PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
            long l = playerActionGenerator.getSize();
            if (l > this.max_branching_so_far) {
                this.max_branching_so_far = l;
            }
            MiniMaxResult miniMaxResult = null;
            PlayerAction playerAction = null;
            do {
                if ((playerAction = playerActionGenerator.getNextAction(-1L)) == null) continue;
                GameState gameState3 = gameState.cloneIssue(playerAction);
                MiniMaxResult miniMaxResult2 = this.ABCD(gameState3, n, n2, f, f2, n3 - 1, n4);
                f = Math.max(f, miniMaxResult2.evaluation);
                if (miniMaxResult == null || miniMaxResult2.evaluation > miniMaxResult.evaluation) {
                    miniMaxResult = miniMaxResult2;
                    miniMaxResult.action = playerAction;
                }
                if (!(f2 <= f)) continue;
                return miniMaxResult;
            } while (playerAction != null);
            return miniMaxResult;
        }
        if (n6 == n2) {
            PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n2);
            long l = playerActionGenerator.getSize();
            if (l > this.max_branching_so_far) {
                this.max_branching_so_far = l;
            }
            MiniMaxResult miniMaxResult = null;
            PlayerAction playerAction = null;
            do {
                if ((playerAction = playerActionGenerator.getNextAction(-1L)) == null) continue;
                GameState gameState4 = gameState.cloneIssue(playerAction);
                MiniMaxResult miniMaxResult3 = this.ABCD(gameState4, n, n2, f, f2, n3 - 1, n4);
                f2 = Math.min(f2, miniMaxResult3.evaluation);
                if (miniMaxResult == null || miniMaxResult3.evaluation < miniMaxResult.evaluation) {
                    miniMaxResult = miniMaxResult3;
                    miniMaxResult.action = playerAction;
                }
                if (!(f2 <= f)) continue;
                return miniMaxResult;
            } while (playerAction != null);
            return miniMaxResult;
        }
        GameState gameState5 = gameState.clone();
        while (!(gameState5.winner() != -1 || gameState5.gameover() || gameState5.canExecuteAnyAction(n) || gameState5.canExecuteAnyAction(n2))) {
            gameState5.cycle();
        }
        return this.ABCD(gameState5, n, n2, f, f2, n3, n4);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.MAXDEPTH + ", " + this.playoutAI + ", " + this.maxPlayoutTime + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("MaxDepth", Integer.TYPE, 4));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("PlayoutAI", AI.class, this.playoutAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getMaxDepth() {
        return this.MAXDEPTH;
    }

    public void setMaxDepth(int n) {
        this.MAXDEPTH = n;
    }

    public int getPlayoutLookahead() {
        return this.maxPlayoutTime;
    }

    public void setPlayoutLookahead(int n) {
        this.maxPlayoutTime = n;
    }

    public AI getPlayoutAI() {
        return this.playoutAI;
    }

    public void setPlayoutAI(AI aI) {
        this.playoutAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }
}

