/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.ABCD;

import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.ABCD.ABCDNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;
import util.Pair;

public class IDABCD
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    int MAX_DEPTH = 50;
    int avg_depth_so_far = 0;
    int count_depth_so_far = 0;
    long avg_branching_so_far = 0L;
    int count_branching_so_far = 0;
    long avg_leaves_so_far = 0L;
    int count_leaves_so_far = 0;
    long avg_nodes_so_far = 0L;
    int count_nodes_so_far = 0;
    long max_potential_branching_so_far = 0L;
    long avg_potential_branching_so_far = 0L;
    int count_potential_branching_so_far = 0;
    int nPlayouts = 0;
    int nLeaves = 0;
    int nNodes = 0;
    int max_depth_so_far = 0;
    long max_branching_so_far = 0L;
    long max_leaves_so_far = 0L;
    long max_nodes_so_far = 0L;
    AI playoutAI = null;
    int maxPlayoutTime = 100;
    EvaluationFunction ef = null;
    boolean performGreedyActionScan = false;
    int max_consecutive_frames_searching_so_far = 0;
    GameState gs_to_start_from = null;
    int consecutive_frames_searching = 0;
    int last_depth = 1;
    int last_nleaves = 0;
    int last_nnodes = 0;
    int last_time_depth = 0;
    int time_depth = 0;
    int max_time_depth_so_far = 0;
    long avg_time_depth_so_far = 0L;
    double count_time_depth_so_far = 0.0;
    boolean treeIsComplete = true;
    List<ABCDNode> stack = null;
    Pair<PlayerAction, Float> lastResult = null;
    PlayerAction bestMove = null;
    int playerForThisComputation;

    public IDABCD(UnitTypeTable unitTypeTable) {
        this(100, -1, new WorkerRush(unitTypeTable, new AStarPathFinding()), 100, new SimpleSqrtEvaluationFunction3(), true);
    }

    public IDABCD(int n, int n2, AI aI, int n3, EvaluationFunction evaluationFunction, boolean bl) {
        super(n, n2);
        this.playoutAI = aI;
        this.maxPlayoutTime = n3;
        this.ef = evaluationFunction;
        this.performGreedyActionScan = bl;
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.consecutive_frames_searching = 0;
        this.stack = null;
        this.lastResult = null;
        this.bestMove = null;
        this.treeIsComplete = true;
        this.max_depth_so_far = 0;
        this.max_branching_so_far = 0L;
        this.max_leaves_so_far = 0L;
        this.max_nodes_so_far = 0L;
        this.avg_depth_so_far = 0;
        this.count_depth_so_far = 0;
        this.avg_branching_so_far = 0L;
        this.count_branching_so_far = 0;
        this.avg_leaves_so_far = 0L;
        this.count_leaves_so_far = 0;
        this.avg_nodes_so_far = 0L;
        this.count_nodes_so_far = 0;
        this.avg_time_depth_so_far = 0L;
        this.count_time_depth_so_far = 0.0;
        this.max_time_depth_so_far = 0;
        this.max_potential_branching_so_far = 0L;
        this.avg_potential_branching_so_far = 0L;
        this.count_potential_branching_so_far = 0;
    }

    @Override
    public AI clone() {
        return new IDABCD(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.playoutAI, this.maxPlayoutTime, this.ef, this.performGreedyActionScan);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.consecutive_frames_searching = 0;
        this.stack = null;
        this.last_depth = 1;
        this.last_nleaves = 0;
        this.last_nnodes = 0;
        this.last_time_depth = 0;
        this.gs_to_start_from = gameState;
        this.playerForThisComputation = n;
        this.bestMove = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        int n = this.playerForThisComputation;
        int n2 = 1 - this.playerForThisComputation;
        int n3 = 1;
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.TIME_BUDGET;
        if (this.TIME_BUDGET <= 0) {
            l2 = 0L;
        }
        this.nPlayouts = 0;
        if (this.bestMove == null && this.performGreedyActionScan) {
            this.bestMove = this.greedyActionScan(this.gs_to_start_from, this.playerForThisComputation, l2, this.ITERATIONS_BUDGET);
        }
        if (l2 > 0L && System.currentTimeMillis() >= l2) {
            return;
        }
        ++this.consecutive_frames_searching;
        do {
            if (this.stack != null) {
                n3 = this.last_depth;
            }
            if (DEBUG >= 1) {
                System.out.println("  next depth: " + n3);
            }
            long l3 = System.currentTimeMillis();
            PlayerAction playerAction = this.searchOutsideStack(this.gs_to_start_from, n, n2, n3, l2, this.ITERATIONS_BUDGET, false);
            if (DEBUG >= 1) {
                System.out.println("    Time taken: " + (System.currentTimeMillis() - l3) + ", nPlayouts: " + this.nPlayouts);
            }
            if (playerAction != null) {
                this.bestMove = playerAction;
                if (n3 > this.max_depth_so_far) {
                    this.max_depth_so_far = n3;
                }
            }
            if (this.stack.isEmpty()) {
                if ((long)this.nLeaves > this.max_leaves_so_far) {
                    this.max_leaves_so_far = this.nLeaves;
                }
                if ((long)this.nNodes > this.max_nodes_so_far) {
                    this.max_nodes_so_far = this.nNodes;
                }
                this.last_nleaves = this.nLeaves;
                this.last_nnodes = this.nNodes;
                this.last_time_depth = this.time_depth;
                this.stack = null;
                if (this.treeIsComplete || ++n3 > this.MAX_DEPTH) break;
            }
            this.nLeaves = 0;
            this.nNodes = 0;
            this.time_depth = 0;
        } while ((this.ITERATIONS_BUDGET <= 0 || this.nPlayouts < this.ITERATIONS_BUDGET) && (l2 <= 0L || System.currentTimeMillis() < l2));
        this.last_depth = n3;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        this.avg_depth_so_far += this.last_depth;
        ++this.count_depth_so_far;
        this.avg_leaves_so_far += (long)this.last_nleaves;
        ++this.count_leaves_so_far;
        this.avg_nodes_so_far += (long)this.last_nnodes;
        ++this.count_nodes_so_far;
        this.avg_time_depth_so_far += (long)this.last_time_depth;
        this.count_time_depth_so_far += 1.0;
        if (this.last_time_depth > this.max_time_depth_so_far) {
            this.max_time_depth_so_far = this.last_time_depth;
        }
        if (this.bestMove == null) {
            PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(this.gs_to_start_from, this.playerForThisComputation);
            return playerActionGenerator.getRandom();
        }
        return this.bestMove;
    }

    public PlayerAction greedyActionScan(GameState gameState, int n, long l, int n2) throws Exception {
        PlayerAction playerAction = null;
        float f = 0.0f;
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        PlayerAction playerAction2 = null;
        do {
            if ((playerAction2 = playerActionGenerator.getNextAction(l)) != null) {
                GameState gameState2 = gameState.cloneIssue(playerAction2);
                float f2 = this.ef.evaluate(n, 1 - n, gameState2);
                if (playerAction == null || f2 > f) {
                    playerAction = playerAction2;
                    f = f2;
                }
            }
            if (l <= 0L || System.currentTimeMillis() <= l) continue;
            return playerAction;
        } while (playerAction2 != null);
        return playerAction;
    }

    public PlayerAction searchOutsideStack(GameState gameState, int n, int n2, int n3, long l, int n4, boolean bl) throws Exception {
        ABCDNode aBCDNode;
        if (this.stack == null) {
            this.nLeaves = 0;
            this.time_depth = 0;
            this.stack = new LinkedList<ABCDNode>();
            aBCDNode = new ABCDNode(-1, 0, gameState, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, 0);
            this.stack.add(aBCDNode);
            this.treeIsComplete = true;
        } else {
            if (this.stack.isEmpty()) {
                return (PlayerAction)this.lastResult.m_a;
            }
            aBCDNode = this.stack.get(this.stack.size() - 1);
        }
        block6: while (!(this.stack.isEmpty() || l > 0L && System.currentTimeMillis() >= l || n4 > 0 && this.nPlayouts >= n4)) {
            int n5;
            ABCDNode aBCDNode2 = this.stack.get(0);
            if (DEBUG >= 2) {
                for (n5 = 0; n5 < aBCDNode2.depth; ++n5) {
                    System.out.print(" ");
                }
                System.out.println("Node: " + aBCDNode2.type);
            }
            switch (aBCDNode2.type) {
                case -1: {
                    Object object;
                    Object object2;
                    n5 = aBCDNode2.gs.winner();
                    boolean bl2 = aBCDNode2.gs.gameover();
                    if (aBCDNode2.depth >= n3 || n5 != -1 || bl2) {
                        if (aBCDNode2.gs.getTime() - gameState.getTime() > this.time_depth) {
                            this.time_depth = aBCDNode2.gs.getTime() - gameState.getTime();
                        }
                        ++this.nLeaves;
                        ++this.nNodes;
                        ++this.nPlayouts;
                        if (DEBUG >= 2) {
                            for (int j = 0; j < aBCDNode2.depth; ++j) {
                                System.out.print(" ");
                            }
                            System.out.println("playout!");
                        }
                        object2 = aBCDNode2.gs.clone();
                        object = this.playoutAI.clone();
                        AI aI = this.playoutAI.clone();
                        int n6 = ((GameState)object2).getTime() + this.maxPlayoutTime;
                        if (!((GameState)object2).gameover()) {
                            this.treeIsComplete = false;
                        }
                        bl2 = false;
                        while (!bl2 && ((GameState)object2).getTime() < n6) {
                            if (((GameState)object2).isComplete()) {
                                bl2 = ((GameState)object2).cycle();
                                continue;
                            }
                            ((GameState)object2).issue(((AI)object).getAction(0, (GameState)object2));
                            ((GameState)object2).issue(aI.getAction(1, (GameState)object2));
                        }
                        this.lastResult = new Pair<Object, Float>(null, Float.valueOf(this.ef.evaluate(n, n2, (GameState)object2)));
                        this.stack.remove(0);
                        break;
                    }
                    aBCDNode2.type = 2;
                    if (aBCDNode2.gs.canExecuteAnyAction(n)) {
                        if (aBCDNode2.gs.canExecuteAnyAction(n2)) {
                            aBCDNode2.type = aBCDNode2.nextPlayerInSimultaneousNode;
                            aBCDNode2.nextPlayerInSimultaneousNode = 1 - aBCDNode2.nextPlayerInSimultaneousNode;
                            break;
                        }
                        aBCDNode2.type = 0;
                        break;
                    }
                    if (!aBCDNode2.gs.canExecuteAnyAction(n2)) continue block6;
                    aBCDNode2.type = 1;
                    break;
                }
                case 0: {
                    Object object;
                    Object object2;
                    ++this.nNodes;
                    if (aBCDNode2.actions == null) {
                        aBCDNode2.actions = new PlayerActionGenerator(aBCDNode2.gs, n);
                        aBCDNode2.actions.randomizeOrder();
                        long l2 = aBCDNode2.actions.getSize();
                        if (DEBUG >= 2) {
                            for (int j = 0; j < aBCDNode2.depth; ++j) {
                                System.out.print(" ");
                            }
                            System.out.println("PlayerGenerator moves: " + l2 + "(cutOffTime: " + l + ")");
                        }
                        if (l2 > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l2;
                        }
                        this.avg_potential_branching_so_far += l2;
                        ++this.count_potential_branching_so_far;
                        aBCDNode2.best = null;
                        object2 = aBCDNode2.actions.getNextAction(l);
                        if (object2 == null) break;
                        object = aBCDNode2.gs.cloneIssue((PlayerAction)object2);
                        this.stack.add(0, new ABCDNode(-1, aBCDNode2.depth + 1, (GameState)object, aBCDNode2.alpha, aBCDNode2.beta, aBCDNode2.nextPlayerInSimultaneousNode));
                        break;
                    }
                    aBCDNode2.alpha = Math.max(aBCDNode2.alpha, ((Float)this.lastResult.m_b).floatValue());
                    if (aBCDNode2.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)aBCDNode2.best.m_b).floatValue()) {
                        aBCDNode2.best = this.lastResult;
                        aBCDNode2.best.m_a = aBCDNode2.actions.getLastAction();
                    }
                    PlayerAction playerAction = aBCDNode2.actions.getNextAction(l);
                    if (DEBUG >= 2) {
                        for (int j = 0; j < aBCDNode2.depth; ++j) {
                            System.out.print(" ");
                        }
                        System.out.println("alpha: " + aBCDNode2.alpha + ", beta: " + aBCDNode2.beta + ", next: " + playerAction);
                    }
                    if (aBCDNode2.beta <= aBCDNode2.alpha || playerAction == null) {
                        this.lastResult = aBCDNode2.best;
                        this.stack.remove(0);
                        if (aBCDNode2.actions.getGenerated() > this.max_branching_so_far) {
                            this.max_branching_so_far = aBCDNode2.actions.getGenerated();
                        }
                        this.avg_branching_so_far += aBCDNode2.actions.getGenerated();
                        ++this.count_branching_so_far;
                        break;
                    }
                    GameState gameState2 = aBCDNode2.gs.cloneIssue(playerAction);
                    this.stack.add(0, new ABCDNode(-1, aBCDNode2.depth + 1, gameState2, aBCDNode2.alpha, aBCDNode2.beta, aBCDNode2.nextPlayerInSimultaneousNode));
                    break;
                }
                case 1: {
                    Object object;
                    Object object2;
                    ++this.nNodes;
                    if (aBCDNode2.actions == null) {
                        aBCDNode2.actions = new PlayerActionGenerator(aBCDNode2.gs, n2);
                        aBCDNode2.actions.randomizeOrder();
                        long l3 = aBCDNode2.actions.getSize();
                        if (DEBUG >= 2) {
                            for (int j = 0; j < aBCDNode2.depth; ++j) {
                                System.out.print(" ");
                            }
                            System.out.println("PlayerGenerator moves: " + l3);
                        }
                        if (l3 > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l3;
                        }
                        this.avg_potential_branching_so_far += l3;
                        ++this.count_potential_branching_so_far;
                        aBCDNode2.best = null;
                        object2 = aBCDNode2.actions.getNextAction(l);
                        if (object2 == null) break;
                        object = aBCDNode2.gs.cloneIssue((PlayerAction)object2);
                        this.stack.add(0, new ABCDNode(-1, aBCDNode2.depth + 1, (GameState)object, aBCDNode2.alpha, aBCDNode2.beta, aBCDNode2.nextPlayerInSimultaneousNode));
                        break;
                    }
                    aBCDNode2.beta = Math.min(aBCDNode2.beta, ((Float)this.lastResult.m_b).floatValue());
                    if (aBCDNode2.best == null || ((Float)this.lastResult.m_b).floatValue() < ((Float)aBCDNode2.best.m_b).floatValue()) {
                        aBCDNode2.best = this.lastResult;
                        aBCDNode2.best.m_a = aBCDNode2.actions.getLastAction();
                    }
                    PlayerAction playerAction = aBCDNode2.actions.getNextAction(l);
                    if (aBCDNode2.beta <= aBCDNode2.alpha || playerAction == null) {
                        this.lastResult = aBCDNode2.best;
                        this.stack.remove(0);
                        if (aBCDNode2.actions.getGenerated() > this.max_branching_so_far) {
                            this.max_branching_so_far = aBCDNode2.actions.getGenerated();
                        }
                        this.avg_branching_so_far += aBCDNode2.actions.getGenerated();
                        ++this.count_branching_so_far;
                        break;
                    }
                    GameState gameState3 = aBCDNode2.gs.cloneIssue(playerAction);
                    this.stack.add(0, new ABCDNode(-1, aBCDNode2.depth + 1, gameState3, aBCDNode2.alpha, aBCDNode2.beta, aBCDNode2.nextPlayerInSimultaneousNode));
                    break;
                }
                case 2: {
                    ++this.nNodes;
                    aBCDNode2.gs = aBCDNode2.gs.clone();
                    while (!(aBCDNode2.gs.winner() != -1 || aBCDNode2.gs.gameover() || aBCDNode2.gs.canExecuteAnyAction(n) || aBCDNode2.gs.canExecuteAnyAction(n2))) {
                        aBCDNode2.gs.cycle();
                    }
                    aBCDNode2.type = -1;
                }
            }
        }
        if (this.stack.isEmpty()) {
            return (PlayerAction)this.lastResult.m_a;
        }
        if (bl) {
            if (aBCDNode.best != null) {
                return (PlayerAction)aBCDNode.best.m_a;
            }
            return aBCDNode.actions.getRandom();
        }
        return null;
    }

    @Override
    public String statisticsString() {
        return "avg depth: " + (double)this.avg_depth_so_far / (double)this.count_depth_so_far + " , max depth: " + this.max_depth_so_far + " , avg branching factor: " + (double)this.avg_branching_so_far / (double)this.count_branching_so_far + " , max branching factor: " + this.max_branching_so_far + " , avg potential branching factor: " + (double)this.avg_potential_branching_so_far / (double)this.count_potential_branching_so_far + " , max potential branching factor: " + this.max_potential_branching_so_far + " , avg leaves: " + (double)this.avg_leaves_so_far / (double)this.count_leaves_so_far + " , max leaves: " + this.max_leaves_so_far + " , avg nodes: " + (double)this.avg_nodes_so_far / (double)this.count_nodes_so_far + " , max nodes: " + this.max_nodes_so_far + " , avg time depth: " + (double)this.avg_time_depth_so_far / this.count_time_depth_so_far + " , max time depth: " + this.max_time_depth_so_far;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.playoutAI + ", " + this.maxPlayoutTime + ", " + this.ef + ", " + this.performGreedyActionScan + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutAI", AI.class, this.playoutAI));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        arrayList.add(new ParameterSpecification("PerformGreedyActionScan", Boolean.TYPE, true));
        return arrayList;
    }

    public AI getPlayoutAI() {
        return this.playoutAI;
    }

    public void setPlayoutAI(AI aI) {
        this.playoutAI = aI;
    }

    public int getPlayoutLookahead() {
        return this.maxPlayoutTime;
    }

    public void setPlayoutLookahead(int n) {
        this.maxPlayoutTime = n;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }

    public boolean getPerformGreedyActionScan() {
        return this.performGreedyActionScan;
    }

    public void setPerformGreedyActionScan(boolean bl) {
        this.performGreedyActionScan = bl;
    }
}

