/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.RTMiniMax;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.EvaluationFunctionForwarding;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.RTMiniMax.RTMiniMaxNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;
import util.Pair;

public class IDRTMinimax
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    static int minCT = -1;
    static int maxCT = -1;
    static int nLeaves = 0;
    public long max_branching_so_far = 0L;
    public long max_leaves_so_far = 0L;
    int LOOKAHEAD = 1;
    protected int defaultNONEduration = 8;
    EvaluationFunction ef = null;
    int max_depth_so_far = 0;
    long max_potential_branching_so_far = 0L;
    int max_consecutive_frames_searching_so_far = 0;
    GameState gs_to_start_from = null;
    int consecutive_frames_searching = 0;
    int last_lookAhead = 1;
    List<RTMiniMaxNode> stack = null;
    Pair<PlayerAction, Float> lastResult = null;
    PlayerAction bestMove = null;
    Random r = new Random();
    int playerForThisComputation;

    public IDRTMinimax(UnitTypeTable unitTypeTable) {
        this(100, new SimpleSqrtEvaluationFunction3());
    }

    public IDRTMinimax(int n, EvaluationFunction evaluationFunction) {
        super(n, -1);
        this.ef = evaluationFunction;
    }

    @Override
    public void reset() {
        this.gs_to_start_from = null;
        this.consecutive_frames_searching = 0;
        this.stack = null;
        this.lastResult = null;
        this.bestMove = null;
    }

    @Override
    public AI clone() {
        return new IDRTMinimax(this.TIME_BUDGET, this.ef);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.playerForThisComputation = n;
        this.stack = null;
        this.last_lookAhead = 1;
        this.gs_to_start_from = gameState;
        this.bestMove = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        int n = this.playerForThisComputation;
        int n2 = 1 - this.playerForThisComputation;
        int n3 = 1;
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.TIME_BUDGET;
        if (this.bestMove == null) {
            this.bestMove = this.greedyActionScan(this.gs_to_start_from, this.playerForThisComputation, l2);
        }
        if (System.currentTimeMillis() >= l2) {
            return;
        }
        ++this.consecutive_frames_searching;
        do {
            if (this.stack == null) {
                if ((long)nLeaves > this.max_leaves_so_far) {
                    this.max_leaves_so_far = nLeaves;
                }
                minCT = -1;
                maxCT = -1;
                nLeaves = 0;
            } else {
                n3 = this.last_lookAhead;
            }
            PlayerAction playerAction = this.timeBoundedRealTimeMinimaxABOutsideStack(this.gs_to_start_from, n, n2, this.gs_to_start_from.getTime() + n3, l2, false);
            if (playerAction != null) {
                this.bestMove = playerAction;
                if (n3 > this.max_depth_so_far) {
                    this.max_depth_so_far = n3;
                }
            }
            if (!this.stack.isEmpty()) continue;
            this.stack = null;
            int n4 = Math.max(minCT + 1 - this.gs_to_start_from.getTime(), n3 + 4);
            if (minCT == -1 && maxCT == -1 || n4 <= n3) {
                return;
            }
            n3 = n4;
        } while (System.currentTimeMillis() - l < (long)this.TIME_BUDGET);
        this.last_lookAhead = n3;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        return this.bestMove;
    }

    public PlayerAction timeBoundedRealTimeMinimaxABOutsideStack(GameState gameState, int n, int n2, int n3, long l, boolean bl) throws Exception {
        RTMiniMaxNode rTMiniMaxNode;
        if (this.stack == null) {
            this.stack = new LinkedList<RTMiniMaxNode>();
            rTMiniMaxNode = new RTMiniMaxNode(0, gameState, -EvaluationFunctionForwarding.VICTORY, EvaluationFunctionForwarding.VICTORY);
            this.stack.add(rTMiniMaxNode);
        } else {
            if (this.stack.isEmpty()) {
                return (PlayerAction)this.lastResult.m_a;
            }
            rTMiniMaxNode = this.stack.get(this.stack.size() - 1);
        }
        block6: while (!this.stack.isEmpty() && System.currentTimeMillis() < l) {
            RTMiniMaxNode rTMiniMaxNode2 = this.stack.get(0);
            switch (rTMiniMaxNode2.type) {
                case -1: {
                    int n4 = rTMiniMaxNode2.gs.winner();
                    if (rTMiniMaxNode2.gs.getTime() >= n3 || n4 != -1) {
                        if (n4 == -1) {
                            int n5 = rTMiniMaxNode2.gs.getNextChangeTime();
                            if (minCT == -1 || n5 < minCT) {
                                minCT = n5;
                            }
                            if (maxCT == -1 || n5 > maxCT) {
                                maxCT = n5;
                            }
                        }
                        ++nLeaves;
                        this.lastResult = new Pair<Object, Float>(null, Float.valueOf(this.ef.evaluate(n, n2, rTMiniMaxNode2.gs)));
                        this.stack.remove(0);
                        break;
                    }
                    if (rTMiniMaxNode2.gs.canExecuteAnyAction(n)) {
                        rTMiniMaxNode2.type = 0;
                        break;
                    }
                    if (rTMiniMaxNode2.gs.canExecuteAnyAction(n2)) {
                        rTMiniMaxNode2.type = 1;
                        break;
                    }
                    rTMiniMaxNode2.type = 2;
                    break;
                }
                case 0: {
                    GameState gameState2;
                    PlayerAction playerAction;
                    if (rTMiniMaxNode2.actions == null) {
                        rTMiniMaxNode2.actions = new PlayerActionGenerator(rTMiniMaxNode2.gs, n);
                        long l2 = rTMiniMaxNode2.actions.getSize();
                        if (l2 > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l2;
                        }
                        rTMiniMaxNode2.best = null;
                        playerAction = rTMiniMaxNode2.actions.getNextAction(l);
                        if (playerAction == null) break;
                        gameState2 = rTMiniMaxNode2.gs.cloneIssue(playerAction);
                        this.stack.add(0, new RTMiniMaxNode(-1, gameState2, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                        break;
                    }
                    rTMiniMaxNode2.alpha = Math.max(rTMiniMaxNode2.alpha, ((Float)this.lastResult.m_b).floatValue());
                    if (rTMiniMaxNode2.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)rTMiniMaxNode2.best.m_b).floatValue()) {
                        rTMiniMaxNode2.best = this.lastResult;
                        rTMiniMaxNode2.best.m_a = rTMiniMaxNode2.actions.getLastAction();
                    }
                    PlayerAction playerAction2 = rTMiniMaxNode2.actions.getNextAction(l);
                    if (rTMiniMaxNode2.beta <= rTMiniMaxNode2.alpha || playerAction2 == null) {
                        this.lastResult = rTMiniMaxNode2.best;
                        this.stack.remove(0);
                        if (rTMiniMaxNode2.actions.getGenerated() <= this.max_branching_so_far) continue block6;
                        this.max_branching_so_far = rTMiniMaxNode2.actions.getGenerated();
                        break;
                    }
                    GameState gameState3 = rTMiniMaxNode2.gs.cloneIssue(playerAction2);
                    this.stack.add(0, new RTMiniMaxNode(-1, gameState3, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                    break;
                }
                case 1: {
                    GameState gameState2;
                    PlayerAction playerAction;
                    if (rTMiniMaxNode2.actions == null) {
                        rTMiniMaxNode2.actions = new PlayerActionGenerator(rTMiniMaxNode2.gs, n2);
                        long l3 = rTMiniMaxNode2.actions.getSize();
                        if (l3 > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l3;
                        }
                        rTMiniMaxNode2.best = null;
                        playerAction = rTMiniMaxNode2.actions.getNextAction(l);
                        if (playerAction == null) break;
                        gameState2 = rTMiniMaxNode2.gs.cloneIssue(playerAction);
                        this.stack.add(0, new RTMiniMaxNode(-1, gameState2, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                        break;
                    }
                    rTMiniMaxNode2.beta = Math.min(rTMiniMaxNode2.beta, ((Float)this.lastResult.m_b).floatValue());
                    if (rTMiniMaxNode2.best == null || ((Float)this.lastResult.m_b).floatValue() < ((Float)rTMiniMaxNode2.best.m_b).floatValue()) {
                        rTMiniMaxNode2.best = this.lastResult;
                        rTMiniMaxNode2.best.m_a = rTMiniMaxNode2.actions.getLastAction();
                    }
                    PlayerAction playerAction3 = rTMiniMaxNode2.actions.getNextAction(l);
                    if (rTMiniMaxNode2.beta <= rTMiniMaxNode2.alpha || playerAction3 == null) {
                        this.lastResult = rTMiniMaxNode2.best;
                        this.stack.remove(0);
                        if (rTMiniMaxNode2.actions.getGenerated() <= this.max_branching_so_far) continue block6;
                        this.max_branching_so_far = rTMiniMaxNode2.actions.getGenerated();
                        break;
                    }
                    GameState gameState4 = rTMiniMaxNode2.gs.cloneIssue(playerAction3);
                    this.stack.add(0, new RTMiniMaxNode(-1, gameState4, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                    break;
                }
                case 2: {
                    rTMiniMaxNode2.gs = rTMiniMaxNode2.gs.clone();
                    while (!(rTMiniMaxNode2.gs.winner() != -1 || rTMiniMaxNode2.gs.gameover() || rTMiniMaxNode2.gs.canExecuteAnyAction(n) || rTMiniMaxNode2.gs.canExecuteAnyAction(n2))) {
                        rTMiniMaxNode2.gs.cycle();
                    }
                    rTMiniMaxNode2.type = -1;
                }
            }
        }
        if (this.stack.isEmpty()) {
            return (PlayerAction)this.lastResult.m_a;
        }
        if (bl) {
            if (rTMiniMaxNode.best != null) {
                return (PlayerAction)rTMiniMaxNode.best.m_a;
            }
            return rTMiniMaxNode.actions.getRandom();
        }
        return null;
    }

    public PlayerAction greedyActionScan(GameState gameState, int n, long l) throws Exception {
        PlayerAction playerAction = null;
        float f = 0.0f;
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        PlayerAction playerAction2 = null;
        do {
            if ((playerAction2 = playerActionGenerator.getNextAction(l)) != null) {
                GameState gameState2 = gameState.cloneIssue(playerAction2);
                float f2 = this.ef.evaluate(n, 1 - n, gameState2);
                if (playerAction == null || f2 > f) {
                    playerAction = playerAction2;
                    f = f2;
                }
            }
            if (System.currentTimeMillis() <= l) continue;
            return playerAction;
        } while (playerAction2 != null);
        return playerAction;
    }

    @Override
    public String statisticsString() {
        return "max depth: " + this.max_depth_so_far + " , max branching factor (potential): " + this.max_branching_so_far + "(" + this.max_potential_branching_so_far + ") , max leaves: " + this.max_leaves_so_far + " , max consecutive frames: " + this.max_consecutive_frames_searching_so_far;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }
}

