/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.RTMiniMax;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.RTMiniMax.IDRTMinimax;
import ai.minimax.RTMiniMax.RTMiniMaxNode;
import ai.minimax.RTMiniMax.RTMiniMaxRandomizedRootNode;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;
import util.Pair;

public class IDRTMinimaxRandomized
extends IDRTMinimax {
    int m_repeats = 10;

    public IDRTMinimaxRandomized(UnitTypeTable unitTypeTable) {
        this(100, 10, new SimpleSqrtEvaluationFunction3());
    }

    public IDRTMinimaxRandomized(int n, int n2, EvaluationFunction evaluationFunction) {
        super(n, evaluationFunction);
    }

    @Override
    public AI clone() {
        return new IDRTMinimaxRandomized(this.TIME_BUDGET, this.m_repeats, this.ef);
    }

    public PlayerAction timeBoundedRealTimeMinimaxRandomizedABOutsideStack(GameState gameState, int n, int n2, int n3, long l, boolean bl) throws Exception {
        RTMiniMaxNode rTMiniMaxNode;
        if (this.stack == null) {
            this.stack = new LinkedList();
            rTMiniMaxNode = new RTMiniMaxRandomizedRootNode(gameState);
            this.stack.add(rTMiniMaxNode);
        } else {
            if (this.stack.isEmpty()) {
                return (PlayerAction)this.lastResult.m_a;
            }
            rTMiniMaxNode = (RTMiniMaxNode)this.stack.get(this.stack.size() - 1);
        }
        block7: while (!this.stack.isEmpty() && System.currentTimeMillis() < l) {
            RTMiniMaxNode rTMiniMaxNode2 = (RTMiniMaxNode)this.stack.get(0);
            switch (rTMiniMaxNode2.type) {
                case -1: {
                    int n4 = rTMiniMaxNode2.gs.winner();
                    if (rTMiniMaxNode2.gs.getTime() >= n3 || n4 != -1) {
                        if (n4 == -1) {
                            int n5 = rTMiniMaxNode2.gs.getNextChangeTime();
                            if (minCT == -1 || n5 < minCT) {
                                minCT = n5;
                            }
                            if (maxCT == -1 || n5 > maxCT) {
                                maxCT = n5;
                            }
                        }
                        ++nLeaves;
                        this.lastResult = new Pair<Object, Float>(null, Float.valueOf(this.ef.evaluate(n, n2, rTMiniMaxNode2.gs)));
                        this.stack.remove(0);
                        break;
                    }
                    if (rTMiniMaxNode2.gs.canExecuteAnyAction(n)) {
                        if (this.stack.size() == 1 || !rTMiniMaxNode2.gs.canExecuteAnyAction(n2)) {
                            rTMiniMaxNode2.type = 0;
                            break;
                        }
                        rTMiniMaxNode2.type = this.r.nextInt(2) + 1;
                        break;
                    }
                    if (rTMiniMaxNode2.gs.canExecuteAnyAction(n2)) {
                        rTMiniMaxNode2.type = 1;
                        break;
                    }
                    rTMiniMaxNode2.type = 2;
                    break;
                }
                case 3: {
                    int n6;
                    Object object;
                    Object object2;
                    Object object3;
                    RTMiniMaxRandomizedRootNode rTMiniMaxRandomizedRootNode = (RTMiniMaxRandomizedRootNode)rTMiniMaxNode2;
                    if (rTMiniMaxRandomizedRootNode.actions == null) {
                        rTMiniMaxRandomizedRootNode.actions = new PlayerActionGenerator(rTMiniMaxRandomizedRootNode.gs, n);
                        rTMiniMaxRandomizedRootNode.scores = new float[this.m_repeats];
                        rTMiniMaxRandomizedRootNode.iterations_run = 0;
                        long l2 = rTMiniMaxRandomizedRootNode.actions.getSize();
                        if (l2 > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l2;
                        }
                        rTMiniMaxRandomizedRootNode.best = null;
                        object3 = rTMiniMaxRandomizedRootNode.actions.getNextAction(l);
                        if (object3 == null) break;
                        object2 = rTMiniMaxRandomizedRootNode.gs.cloneIssue((PlayerAction)object3);
                        this.stack.add(0, new RTMiniMaxNode(-1, (GameState)object2, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY));
                        break;
                    }
                    rTMiniMaxRandomizedRootNode.scores[rTMiniMaxRandomizedRootNode.iterations_run] = ((Float)this.lastResult.m_b).floatValue();
                    ++rTMiniMaxRandomizedRootNode.iterations_run;
                    if (rTMiniMaxRandomizedRootNode.iterations_run < this.m_repeats) {
                        PlayerAction playerAction = rTMiniMaxRandomizedRootNode.actions.getLastAction();
                        if (playerAction == null) {
                            System.out.println("getLastAction returned null!!! time: " + System.currentTimeMillis() + "  cutOff: " + l);
                            System.out.println("Action generator status:");
                            System.out.println(rTMiniMaxRandomizedRootNode.actions);
                        }
                        object = rTMiniMaxRandomizedRootNode.gs.cloneIssue(playerAction);
                        this.stack.add(0, new RTMiniMaxNode(-1, (GameState)object, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY));
                        break;
                    }
                    float f = 0.0f;
                    float f2 = 0.0f;
                    for (n6 = 0; n6 < this.m_repeats; ++n6) {
                        f += rTMiniMaxRandomizedRootNode.scores[n6];
                    }
                    f /= (float)this.m_repeats;
                    for (n6 = 0; n6 < this.m_repeats; ++n6) {
                        f2 += (f - rTMiniMaxRandomizedRootNode.scores[n6]) * (f - rTMiniMaxRandomizedRootNode.scores[n6]);
                    }
                    f2 /= (float)this.m_repeats;
                    f2 = (float)Math.sqrt(f2);
                    float f3 = f - f2;
                    this.lastResult.m_b = Float.valueOf(f3);
                    if (rTMiniMaxRandomizedRootNode.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)rTMiniMaxRandomizedRootNode.best.m_b).floatValue()) {
                        rTMiniMaxRandomizedRootNode.best = this.lastResult;
                        rTMiniMaxRandomizedRootNode.best.m_a = rTMiniMaxRandomizedRootNode.actions.getLastAction();
                    }
                    rTMiniMaxRandomizedRootNode.iterations_run = 0;
                    object2 = rTMiniMaxRandomizedRootNode.actions.getNextAction(l);
                    if (object2 == null) {
                        this.lastResult = rTMiniMaxRandomizedRootNode.best;
                        this.stack.remove(0);
                        if (rTMiniMaxRandomizedRootNode.actions.getGenerated() <= this.max_branching_so_far) continue block7;
                        this.max_branching_so_far = rTMiniMaxNode2.actions.getGenerated();
                        break;
                    }
                    GameState gameState2 = rTMiniMaxRandomizedRootNode.gs.cloneIssue((PlayerAction)object2);
                    this.stack.add(0, new RTMiniMaxNode(-1, gameState2, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY));
                    break;
                }
                case 0: {
                    Object object;
                    Object object3;
                    if (rTMiniMaxNode2.actions == null) {
                        rTMiniMaxNode2.actions = new PlayerActionGenerator(rTMiniMaxNode2.gs, n);
                        long l3 = rTMiniMaxNode2.actions.getSize();
                        if (l3 > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l3;
                        }
                        rTMiniMaxNode2.best = null;
                        object = rTMiniMaxNode2.actions.getNextAction(l);
                        if (object == null) break;
                        object3 = rTMiniMaxNode2.gs.cloneIssue((PlayerAction)object);
                        this.stack.add(0, new RTMiniMaxNode(-1, (GameState)object3, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                        break;
                    }
                    rTMiniMaxNode2.alpha = Math.max(rTMiniMaxNode2.alpha, ((Float)this.lastResult.m_b).floatValue());
                    if (rTMiniMaxNode2.best == null || ((Float)this.lastResult.m_b).floatValue() > ((Float)rTMiniMaxNode2.best.m_b).floatValue()) {
                        rTMiniMaxNode2.best = this.lastResult;
                        rTMiniMaxNode2.best.m_a = rTMiniMaxNode2.actions.getLastAction();
                    }
                    PlayerAction playerAction = rTMiniMaxNode2.actions.getNextAction(l);
                    if (rTMiniMaxNode2.beta <= rTMiniMaxNode2.alpha || playerAction == null) {
                        this.lastResult = rTMiniMaxNode2.best;
                        this.stack.remove(0);
                        if (rTMiniMaxNode2.actions.getGenerated() <= this.max_branching_so_far) continue block7;
                        this.max_branching_so_far = rTMiniMaxNode2.actions.getGenerated();
                        break;
                    }
                    GameState gameState3 = rTMiniMaxNode2.gs.cloneIssue(playerAction);
                    this.stack.add(0, new RTMiniMaxNode(-1, gameState3, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                    break;
                }
                case 1: {
                    Object object;
                    Object object3;
                    if (rTMiniMaxNode2.actions == null) {
                        rTMiniMaxNode2.actions = new PlayerActionGenerator(rTMiniMaxNode2.gs, n2);
                        long l4 = rTMiniMaxNode2.actions.getSize();
                        if (l4 > this.max_potential_branching_so_far) {
                            this.max_potential_branching_so_far = l4;
                        }
                        rTMiniMaxNode2.best = null;
                        object = rTMiniMaxNode2.actions.getNextAction(l);
                        if (object == null) break;
                        object3 = rTMiniMaxNode2.gs.cloneIssue((PlayerAction)object);
                        this.stack.add(0, new RTMiniMaxNode(-1, (GameState)object3, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                        break;
                    }
                    rTMiniMaxNode2.beta = Math.min(rTMiniMaxNode2.beta, ((Float)this.lastResult.m_b).floatValue());
                    if (rTMiniMaxNode2.best == null || ((Float)this.lastResult.m_b).floatValue() < ((Float)rTMiniMaxNode2.best.m_b).floatValue()) {
                        rTMiniMaxNode2.best = this.lastResult;
                        rTMiniMaxNode2.best.m_a = rTMiniMaxNode2.actions.getLastAction();
                    }
                    PlayerAction playerAction = rTMiniMaxNode2.actions.getNextAction(l);
                    if (rTMiniMaxNode2.beta <= rTMiniMaxNode2.alpha || playerAction == null) {
                        this.lastResult = rTMiniMaxNode2.best;
                        this.stack.remove(0);
                        if (rTMiniMaxNode2.actions.getGenerated() <= this.max_branching_so_far) continue block7;
                        this.max_branching_so_far = rTMiniMaxNode2.actions.getGenerated();
                        break;
                    }
                    GameState gameState4 = rTMiniMaxNode2.gs.cloneIssue(playerAction);
                    this.stack.add(0, new RTMiniMaxNode(-1, gameState4, rTMiniMaxNode2.alpha, rTMiniMaxNode2.beta));
                    break;
                }
                case 2: {
                    rTMiniMaxNode2.gs = rTMiniMaxNode2.gs.clone();
                    while (!(rTMiniMaxNode2.gs.winner() != -1 || rTMiniMaxNode2.gs.gameover() || rTMiniMaxNode2.gs.canExecuteAnyAction(n) || rTMiniMaxNode2.gs.canExecuteAnyAction(n2))) {
                        rTMiniMaxNode2.gs.cycle();
                    }
                    rTMiniMaxNode2.type = -1;
                }
            }
        }
        if (this.stack.isEmpty()) {
            return (PlayerAction)this.lastResult.m_a;
        }
        if (bl) {
            if (rTMiniMaxNode.best != null) {
                return (PlayerAction)rTMiniMaxNode.best.m_a;
            }
            return rTMiniMaxNode.actions.getRandom();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.m_repeats + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        List<ParameterSpecification> list = super.getParameters();
        list.add(new ParameterSpecification("Repeats", Integer.TYPE, 10));
        return list;
    }

    public int getRepeats() {
        return this.m_repeats;
    }

    public void setRepeats(int n) {
        this.m_repeats = n;
    }
}

