/*
 * Decompiled with CFR 0.152.
 */
package ai.minimax.RTMiniMax;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.minimax.MiniMaxResult;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;

public class RTMinimax
extends AI {
    static int minCT = -1;
    static int maxCT = -1;
    static int nLeaves = 0;
    public long max_branching_so_far = 0L;
    public long max_leaves_so_far = 0L;
    int LOOKAHEAD = 40;
    protected int defaultNONEduration = 8;
    EvaluationFunction ef = null;

    public RTMinimax(UnitTypeTable unitTypeTable) {
        this(50, new SimpleSqrtEvaluationFunction3());
    }

    public RTMinimax(int n, EvaluationFunction evaluationFunction) {
        this.LOOKAHEAD = n;
        this.ef = evaluationFunction;
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new RTMinimax(this.LOOKAHEAD, this.ef);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n) && gameState.winner() == -1) {
            PlayerAction playerAction = this.realTimeMinimaxAB(n, gameState, this.LOOKAHEAD);
            playerAction.fillWithNones(gameState, n, this.defaultNONEduration);
            return playerAction;
        }
        return new PlayerAction();
    }

    public PlayerAction greedyActionScan(GameState gameState, int n, long l) throws Exception {
        PlayerAction playerAction = null;
        float f = 0.0f;
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        PlayerAction playerAction2 = null;
        do {
            if ((playerAction2 = playerActionGenerator.getNextAction(l)) != null) {
                GameState gameState2 = gameState.cloneIssue(playerAction2);
                float f2 = this.ef.evaluate(n, 1 - n, gameState2);
                if (playerAction == null || f2 > f) {
                    playerAction = playerAction2;
                    f = f2;
                }
            }
            if (System.currentTimeMillis() <= l) continue;
            return playerAction;
        } while (playerAction2 != null);
        return playerAction;
    }

    public PlayerAction realTimeMinimaxAB(int n, GameState gameState, int n2) {
        long l = System.currentTimeMillis();
        float f = -EvaluationFunction.VICTORY;
        float f2 = EvaluationFunction.VICTORY;
        int n3 = n;
        int n4 = 1 - n;
        System.out.println("Starting realTimeMinimaxAB...");
        if ((long)nLeaves > this.max_leaves_so_far) {
            this.max_leaves_so_far = nLeaves;
        }
        minCT = -1;
        maxCT = -1;
        nLeaves = 0;
        MiniMaxResult miniMaxResult = this.realTimeMinimaxAB(gameState, n3, n4, f, f2, gameState.getTime() + n2, 0);
        System.out.println("realTimeMinimax: " + miniMaxResult + " in " + (System.currentTimeMillis() - l));
        return miniMaxResult.action;
    }

    public MiniMaxResult realTimeMinimaxAB(GameState gameState, int n, int n2, float f, float f2, int n3, int n4) {
        if (gameState.getTime() >= n3 || gameState.winner() != -1) {
            int n5 = gameState.getNextChangeTime();
            if (minCT == -1 || n5 < minCT) {
                minCT = n5;
            }
            if (maxCT == -1 || n5 > maxCT) {
                maxCT = n5;
            }
            ++nLeaves;
            return new MiniMaxResult(null, this.ef.evaluate(n, n2, gameState), gameState);
        }
        if (gameState.canExecuteAnyAction(n)) {
            List<PlayerAction> list = gameState.getPlayerActions(n);
            int n6 = list.size();
            if ((long)n6 > this.max_branching_so_far) {
                this.max_branching_so_far = n6;
            }
            MiniMaxResult miniMaxResult = null;
            for (PlayerAction playerAction : list) {
                GameState gameState2 = gameState.cloneIssue(playerAction);
                MiniMaxResult miniMaxResult2 = this.realTimeMinimaxAB(gameState2, n, n2, f, f2, n3, n4 + 1);
                f = Math.max(f, miniMaxResult2.evaluation);
                if (miniMaxResult == null || miniMaxResult2.evaluation > miniMaxResult.evaluation) {
                    miniMaxResult = miniMaxResult2;
                    miniMaxResult.action = playerAction;
                }
                if (!(f2 <= f)) continue;
                return miniMaxResult;
            }
            return miniMaxResult;
        }
        if (gameState.canExecuteAnyAction(n2)) {
            List<PlayerAction> list = gameState.getPlayerActions(n2);
            int n7 = list.size();
            if ((long)n7 > this.max_branching_so_far) {
                this.max_branching_so_far = n7;
            }
            MiniMaxResult miniMaxResult = null;
            for (PlayerAction playerAction : list) {
                GameState gameState3 = gameState.cloneIssue(playerAction);
                MiniMaxResult miniMaxResult3 = this.realTimeMinimaxAB(gameState3, n, n2, f, f2, n3, n4 + 1);
                f2 = Math.min(f2, miniMaxResult3.evaluation);
                if (miniMaxResult == null || miniMaxResult3.evaluation < miniMaxResult.evaluation) {
                    miniMaxResult = miniMaxResult3;
                    miniMaxResult.action = playerAction;
                }
                if (!(f2 <= f)) continue;
                return miniMaxResult;
            }
            return miniMaxResult;
        }
        GameState gameState4 = gameState.clone();
        while (!(gameState4.winner() != -1 || gameState4.gameover() || gameState4.canExecuteAnyAction(n) || gameState4.canExecuteAnyAction(n2))) {
            gameState4.cycle();
        }
        return this.realTimeMinimaxAB(gameState4, n, n2, f, f2, n3, n4 + 1);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.LOOKAHEAD + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("LookAhead", Integer.TYPE, 50));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getLookAhead() {
        return this.LOOKAHEAD;
    }

    public void setLookAhead(int n) {
        this.LOOKAHEAD = n;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }
}

