/*
 * Decompiled with CFR 0.152.
 */
package ai.montecarlo;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.units.UnitTypeTable;

public class MonteCarlo
extends AIWithComputationBudget
implements InterruptibleAI {
    public static final int DEBUG = 0;
    EvaluationFunction ef = null;
    Random r = new Random();
    AI randomAI = new RandomBiasedAI();
    long max_actions_so_far = 0L;
    PlayerActionGenerator moveGenerator = null;
    boolean allMovesGenerated = false;
    List<PlayerActionTableEntry> actions = null;
    GameState gs_to_start_from = null;
    int run = 0;
    int playerForThisComputation;
    public long total_runs = 0L;
    public long total_cycles_executed = 0L;
    public long total_actions_issued = 0L;
    long MAXACTIONS = 100L;
    int MAXSIMULATIONTIME = 1024;

    public MonteCarlo(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public MonteCarlo(int n, int n2, int n3, AI aI, EvaluationFunction evaluationFunction) {
        super(n, n2);
        this.MAXACTIONS = -1L;
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.ef = evaluationFunction;
    }

    public MonteCarlo(int n, int n2, int n3, long l, AI aI, EvaluationFunction evaluationFunction) {
        super(n, n2);
        this.MAXACTIONS = l;
        this.MAXSIMULATIONTIME = n3;
        this.randomAI = aI;
        this.ef = evaluationFunction;
    }

    @Override
    public void printStats() {
        if (this.total_cycles_executed > 0L && this.total_actions_issued > 0L) {
            System.out.println("Average runs per cycle: " + (double)this.total_runs / (double)this.total_cycles_executed);
            System.out.println("Average runs per action: " + (double)this.total_runs / (double)this.total_actions_issued);
        }
    }

    @Override
    public void reset() {
        this.moveGenerator = null;
        this.actions = null;
        this.gs_to_start_from = null;
        this.run = 0;
    }

    @Override
    public AI clone() {
        return new MonteCarlo(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.MAXSIMULATIONTIME, this.MAXACTIONS, this.randomAI, this.ef);
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.playerForThisComputation = n;
        this.gs_to_start_from = gameState;
        this.moveGenerator = new PlayerActionGenerator(gameState, this.playerForThisComputation);
        this.moveGenerator.randomizeOrder();
        this.allMovesGenerated = false;
        this.actions = null;
        this.run = 0;
    }

    public void resetSearch() {
        this.gs_to_start_from = null;
        this.moveGenerator = null;
        this.actions = null;
        this.run = 0;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l;
        long l2 = System.currentTimeMillis();
        int n = 0;
        long l3 = l = this.TIME_BUDGET > 0 ? System.currentTimeMillis() + (long)this.TIME_BUDGET : 0L;
        if (this.TIME_BUDGET <= 0) {
            l = 0L;
        }
        if (this.actions == null) {
            this.actions = new ArrayList<PlayerActionTableEntry>();
            if (this.MAXACTIONS > 0L && this.moveGenerator.getSize() > 2L * this.MAXACTIONS) {
                int n2 = 0;
                while ((long)n2 < this.MAXACTIONS) {
                    PlayerActionTableEntry playerActionTableEntry = new PlayerActionTableEntry();
                    playerActionTableEntry.pa = this.moveGenerator.getRandom();
                    this.actions.add(playerActionTableEntry);
                    ++n2;
                }
                this.max_actions_so_far = Math.max(this.moveGenerator.getSize(), this.max_actions_so_far);
            } else {
                PlayerAction playerAction;
                long l4 = 0L;
                do {
                    if ((playerAction = this.moveGenerator.getNextAction(l)) == null) continue;
                    PlayerActionTableEntry playerActionTableEntry = new PlayerActionTableEntry();
                    playerActionTableEntry.pa = playerAction;
                    this.actions.add(playerActionTableEntry);
                    if (this.MAXACTIONS > 0L && ++l4 >= 2L * this.MAXACTIONS) break;
                } while (playerAction != null);
                this.max_actions_so_far = Math.max((long)this.actions.size(), this.max_actions_so_far);
                while (this.MAXACTIONS > 0L && (long)this.actions.size() > this.MAXACTIONS) {
                    this.actions.remove(this.r.nextInt(this.actions.size()));
                }
            }
        }
        while (!(this.TIME_BUDGET > 0 && System.currentTimeMillis() - l2 >= (long)this.TIME_BUDGET || this.ITERATIONS_BUDGET > 0 && n >= this.ITERATIONS_BUDGET)) {
            this.monteCarloRun(this.playerForThisComputation, this.gs_to_start_from);
            ++n;
        }
        ++this.total_cycles_executed;
    }

    public void monteCarloRun(int n, GameState gameState) throws Exception {
        int n2 = this.run % this.actions.size();
        PlayerActionTableEntry playerActionTableEntry = this.actions.get(n2);
        GameState gameState2 = gameState.cloneIssue(playerActionTableEntry.pa);
        GameState gameState3 = gameState2.clone();
        this.simulate(gameState3, gameState3.getTime() + this.MAXSIMULATIONTIME);
        int n3 = gameState3.getTime() - gameState2.getTime();
        playerActionTableEntry.accum_evaluation = (float)((double)playerActionTableEntry.accum_evaluation + (double)this.ef.evaluate(n, 1 - n, gameState3) * Math.pow(0.99, (double)n3 / 10.0));
        ++playerActionTableEntry.visit_count;
        ++this.run;
        ++this.total_runs;
    }

    @Override
    public PlayerAction getBestActionSoFar() {
        PlayerActionTableEntry playerActionTableEntry = null;
        for (PlayerActionTableEntry playerActionTableEntry2 : this.actions) {
            if (playerActionTableEntry != null && !(playerActionTableEntry2.accum_evaluation / (float)playerActionTableEntry2.visit_count > playerActionTableEntry.accum_evaluation / (float)playerActionTableEntry.visit_count)) continue;
            playerActionTableEntry = playerActionTableEntry2;
        }
        if (playerActionTableEntry == null) {
            PlayerActionTableEntry playerActionTableEntry3 = new PlayerActionTableEntry();
            playerActionTableEntry3.pa = this.moveGenerator.getRandom();
            System.err.println("MonteCarlo.getBestActionSoFar: best action was null!!! action.size() = " + this.actions.size());
        }
        ++this.total_actions_issued;
        return playerActionTableEntry.pa;
    }

    public void simulate(GameState gameState, int n) throws Exception {
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.randomAI.getAction(0, gameState));
            gameState.issue(this.randomAI.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + "," + this.ITERATIONS_BUDGET + "," + this.MAXSIMULATIONTIME + "," + this.MAXACTIONS + ", " + this.randomAI + ", " + this.ef + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("MaxActions", Long.TYPE, 100));
        arrayList.add(new ParameterSpecification("playoutAI", AI.class, this.randomAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.MAXSIMULATIONTIME;
    }

    public void setPlayoutLookahead(int n) {
        this.MAXSIMULATIONTIME = n;
    }

    public long getMaxActions() {
        return this.MAXACTIONS;
    }

    public void setMaxActions(long l) {
        this.MAXACTIONS = l;
    }

    public AI getplayoutAI() {
        return this.randomAI;
    }

    public void setplayoutAI(AI aI) {
        this.randomAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }

    public class PlayerActionTableEntry {
        PlayerAction pa;
        float accum_evaluation = 0.0f;
        int visit_count = 0;
    }
}

