/*
 * Decompiled with CFR 0.152.
 */
package ai.montecarlo.lsi;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.montecarlo.lsi.Sampling;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;

public class LSI
extends AIWithComputationBudget {
    public static final int DEBUG = 0;
    private static final double NORMALIZATION_EPSILON = 0.01;
    private Random rnd = new Random();
    private int lookAhead;
    private double split;
    private EstimateType estimateType;
    private EstimateReuseType estimateReuseType;
    private GenerateType generateType;
    private Sampling.AgentOrderingType agentOrderingType;
    private EvaluateType evaluateType;
    private boolean eliteReuse;
    private RelaxationType relaxationType;
    private int relaxationLimit;
    private boolean epochal;
    private AI simulationAi;
    private EvaluationFunction evalFunction;
    private int nofPlays = 0;
    private int nofNoops = 0;
    private int nofSamples = 0;
    private int nofPlayedUnits = 0;
    private int nofActions = 0;
    private Sampling sampling;
    private LinkedHashMap<PlayerAction, Pair<Double, Integer>> elitePlayerActions = new LinkedHashMap();
    private Set<Unit> nextEpochUnits = new HashSet<Unit>();
    private Set<Unit> epochUnits = null;
    private int actionCount;

    public LSI(UnitTypeTable unitTypeTable) {
        this(100, 100, 0.25, EstimateType.RANDOM_TAIL, EstimateReuseType.ALL, GenerateType.PER_AGENT, Sampling.AgentOrderingType.ENTROPY, EvaluateType.HALVING, false, RelaxationType.NONE, 2, false, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3());
    }

    public LSI(int n, int n2, double d, EstimateType estimateType, EstimateReuseType estimateReuseType, GenerateType generateType, Sampling.AgentOrderingType agentOrderingType, EvaluateType evaluateType, boolean bl, RelaxationType relaxationType, int n3, boolean bl2, AI aI, EvaluationFunction evaluationFunction) {
        super(-1, n);
        this.lookAhead = n2;
        this.split = d;
        this.estimateType = estimateType;
        this.estimateReuseType = estimateReuseType;
        this.generateType = generateType;
        this.agentOrderingType = agentOrderingType;
        this.evaluateType = evaluateType;
        this.relaxationType = relaxationType;
        this.relaxationLimit = n3;
        this.eliteReuse = bl;
        this.epochal = bl2;
        this.simulationAi = aI;
        this.evalFunction = evaluationFunction;
        this.sampling = new Sampling(agentOrderingType, n2, aI, evaluationFunction);
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new LSI(this.ITERATIONS_BUDGET, this.lookAhead, this.split, this.estimateType, this.estimateReuseType, this.generateType, this.agentOrderingType, this.evaluateType, this.eliteReuse, this.relaxationType, this.relaxationLimit, this.epochal, this.simulationAi, this.evalFunction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        Object object;
        if (!gameState.canExecuteAnyAction(n) || gameState.winner() != -1) {
            return new PlayerAction();
        }
        this.sampling.resetSimulationCount();
        this.elitePlayerActions.clear();
        List<Sampling.UnitActionTableEntry> list2 = this.prepareUnitActionTable(gameState, n);
        HashSet<Unit> hashSet = new HashSet<Unit>();
        for (Sampling.UnitActionTableEntry list3 : list2) {
            hashSet.add(list3.u);
        }
        if (this.epochal) {
            if (this.epochUnits == null) {
                this.epochUnits = new HashSet<Unit>(hashSet);
            }
            for (Sampling.UnitActionTableEntry unitActionTableEntry : list2) {
                if (this.epochUnits.contains(unitActionTableEntry.u) || this.nextEpochUnits.contains(unitActionTableEntry.u)) continue;
                if (this.epochUnits.isEmpty()) {
                    this.epochUnits.add(unitActionTableEntry.u);
                    continue;
                }
                this.nextEpochUnits.add(unitActionTableEntry.u);
            }
            object = list2.iterator();
            while (object.hasNext()) {
                Sampling.UnitActionTableEntry unitActionTableEntry = object.next();
                if (this.epochUnits.contains(unitActionTableEntry.u)) continue;
                object.remove();
            }
        }
        switch (this.relaxationType) {
            case PRE_RANDOM: {
                object = this.getRelaxedAgentIndicesRandom(list2);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    list2.remove(n2);
                }
                break;
            }
        }
        object = new PlayerAction();
        if (!list2.isEmpty()) {
            Object var6_13 = null;
            Set<PlayerAction> set = null;
            if (this.estimateType.equals((Object)EstimateType.ALL_COMBINATIONS)) {
                set = this.sampling.generatePlayerActionAll(list2, n, gameState, true);
                this.sampling.increaseSimulationCount((double)this.ITERATIONS_BUDGET * this.split);
            } else {
                switch (this.estimateType) {
                    case RANDOM: {
                        List<double[]> list = this.stageGenerateRandom(n, gameState, list2);
                        this.sampling.increaseSimulationCount((double)this.ITERATIONS_BUDGET * this.split);
                        break;
                    }
                    case NOOP_TAIL: {
                        List<double[]> list = this.stageGenerateNoopTail(n, gameState, list2);
                        break;
                    }
                    case RANDOM_TAIL: {
                        List<double[]> list = this.stageGenerateRandomTail(n, gameState, list2);
                        break;
                    }
                    case RANDOM_TAIL_ELITE: {
                        List<double[]> list = this.stageGenerateRandomTailElite(n, gameState, list2);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown EstimateType");
                    }
                }
                switch (this.relaxationType) {
                    case MAX: 
                    case MEAN: 
                    case MEDIAN: 
                    case MAX_ENT: 
                    case MIN_ENT: {
                        void var6_18;
                        set = this.stageChoosePlayerActionsAllRelaxation((List<double[]>)var6_18, n, gameState, list2);
                        break;
                    }
                    default: {
                        void var6_18;
                        set = this.stageChoosePlayerActionByDist((List<double[]>)var6_18, n, gameState, list2);
                    }
                }
            }
            switch (this.evaluateType) {
                case HALVING: {
                    object = this.stageEvaluateHalvingFill(set, n, gameState);
                    break;
                }
                case HALVING_ELITE: {
                    object = this.stageEvaluateEliteHalving(set, n, gameState);
                    break;
                }
                case BEST: {
                    object = this.stageEvaluateBest(set, n, gameState);
                }
            }
            switch (this.relaxationType) {
                case POST_RANDOM: {
                    List<Integer> list = this.getRelaxedAgentIndicesRandom(list2);
                    for (Integer n3 : list) {
                        ((PlayerAction)object).getActions().remove(n3);
                    }
                    break;
                }
                case POST_MAX_DIFF: 
                case POST_MAX_TIME_NORMALIZE: 
                case POST_ENTROPY_MAX: 
                case POST_ENTROPY_MIN: {
                    if (list2.size() - this.relaxationLimit < 1) break;
                    int n4 = list2.size() - this.relaxationLimit;
                    ArrayList<Pair<Integer, Double>> arrayList = new ArrayList<Pair<Integer, Double>>();
                    for (int j = 0; j < list2.size(); ++j) {
                        double d = 0.0;
                        switch (this.relaxationType) {
                            case POST_MAX_DIFF: {
                                void var6_19;
                                d = this.sampling.difference(list2, (List<double[]>)var6_19, (PlayerAction)object, j);
                                break;
                            }
                            case POST_MAX_TIME_NORMALIZE: {
                                void var6_19;
                                Sampling.UnitActionTableEntry unitActionTableEntry = list2.get(j);
                                d = Double.NEGATIVE_INFINITY;
                                for (int k = 0; k < unitActionTableEntry.nactions; ++k) {
                                    double d2 = unitActionTableEntry.actions.get(k).ETA(unitActionTableEntry.u);
                                    double d3 = ((double[])var6_19.get(unitActionTableEntry.idx))[k] / d2;
                                    if (!(d3 > d)) continue;
                                    d = d3;
                                }
                                break;
                            }
                            case POST_ENTROPY_MAX: 
                            case POST_ENTROPY_MIN: {
                                void var6_19;
                                d = this.sampling.entropy((double[])var6_19.get(j));
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown relaxationType!");
                            }
                        }
                        arrayList.add(new Pair<Integer, Double>(j, d));
                    }
                    switch (this.relaxationType) {
                        case POST_MAX_DIFF: 
                        case POST_MAX_TIME_NORMALIZE: 
                        case POST_ENTROPY_MAX: {
                            Collections.sort(arrayList, new Comparator<Pair<Integer, Double>>(){

                                @Override
                                public int compare(Pair<Integer, Double> pair, Pair<Integer, Double> pair2) {
                                    return (Double)pair.m_b > (Double)pair2.m_b ? 1 : ((Double)pair.m_b < (Double)pair2.m_b ? -1 : 0);
                                }
                            });
                            break;
                        }
                        case POST_ENTROPY_MIN: {
                            Collections.sort(arrayList, new Comparator<Pair<Integer, Double>>(){

                                @Override
                                public int compare(Pair<Integer, Double> pair, Pair<Integer, Double> pair2) {
                                    return (Double)pair.m_b < (Double)pair2.m_b ? 1 : ((Double)pair.m_b > (Double)pair2.m_b ? -1 : 0);
                                }
                            });
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown relaxationType!");
                        }
                    }
                    List list = arrayList.subList(0, n4);
                    Collections.sort(list, new Comparator<Pair<Integer, Double>>(){

                        @Override
                        public int compare(Pair<Integer, Double> pair, Pair<Integer, Double> pair2) {
                            return (Integer)pair.m_a < (Integer)pair2.m_a ? 1 : ((Integer)pair.m_a > (Integer)pair2.m_a ? -1 : 0);
                        }
                    });
                    for (Pair pair : list) {
                        ((PlayerAction)object).getActions().remove((Integer)pair.m_a);
                    }
                    break;
                }
            }
        }
        if (this.epochal) {
            for (Pair<Unit, UnitAction> pair : ((PlayerAction)object).getActions()) {
                this.epochUnits.remove(pair.m_a);
            }
            if (this.epochUnits.isEmpty()) {
                this.epochUnits = new HashSet<Unit>(this.nextEpochUnits);
                this.nextEpochUnits.clear();
            }
        }
        this.incrementActionCounter((PlayerAction)object, list2);
        return object;
    }

    private List<double[]> stageGenerateNoopTail(int n, GameState gameState, List<Sampling.UnitActionTableEntry> list) throws Exception {
        PlayerAction playerAction = new PlayerAction();
        playerAction.fillWithNones(gameState, n, 10);
        int n2 = this.actionCount;
        int n3 = 0;
        for (Sampling.UnitActionTableEntry object : list) {
            for (UnitAction unitAction : object.actions) {
                PlayerAction playerAction2 = playerAction.clone();
                playerAction2.getActions().set(n3, new Pair<Unit, UnitAction>(object.u, unitAction));
                if (this.isPlayerActionValid(gameState, playerAction2)) continue;
                --n2;
            }
            ++n3;
        }
        ArrayList arrayList = new ArrayList();
        n3 = 0;
        for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
            double[] dArray = new double[unitActionTableEntry.nactions];
            int n4 = 0;
            double d = Double.POSITIVE_INFINITY;
            for (UnitAction unitAction : unitActionTableEntry.actions) {
                PlayerAction playerAction3 = playerAction.clone();
                playerAction3.getActions().set(n3, new Pair<Unit, UnitAction>(unitActionTableEntry.u, unitAction));
                if (this.isPlayerActionValid(gameState, playerAction3)) {
                    double d2;
                    dArray[n4] = d2 = this.sampling.evaluatePlayerAction(n, gameState, playerAction3, (int)((double)this.ITERATIONS_BUDGET * this.split / (double)n2));
                    if (d2 < d) {
                        d = d2;
                    }
                } else {
                    dArray[n4] = Double.NEGATIVE_INFINITY;
                }
                ++n4;
            }
            for (int j = 0; j < dArray.length; ++j) {
                if (Double.isInfinite(dArray[j])) {
                    dArray[j] = 0.0;
                }
                if (dArray[j] == Double.MIN_VALUE) {
                    dArray[j] = 0.01;
                } else {
                    int n5 = j;
                    dArray[n5] = dArray[n5] - (d - 0.01);
                }
                if (!(dArray[j] < 0.0) && !Double.isNaN(dArray[j])) continue;
                System.err.println("Negative/NaN distribution!");
            }
            arrayList.add(dArray);
            ++n3;
        }
        return arrayList;
    }

    private List<double[]> stageGenerateRandomTail(int n, GameState gameState, List<Sampling.UnitActionTableEntry> list) throws Exception {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
            double[] dArray = new double[unitActionTableEntry.nactions];
            arrayList2.add(dArray);
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = 0.0;
            }
        }
        int n2 = 0;
        boolean bl = false;
        block6: while (true) {
            int n3 = 0;
            for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
                int n4 = 0;
                for (UnitAction unitAction : unitActionTableEntry.actions) {
                    PlayerAction playerAction = new PlayerAction();
                    LinkedList<Integer> linkedList = new LinkedList<Integer>();
                    for (int j = 0; j < list.size(); ++j) {
                        if (j == n3) continue;
                        linkedList.add(j);
                    }
                    Collections.shuffle(linkedList);
                    linkedList.add(0, n3);
                    ((double[])arrayList2.get((int)n3))[n4] = 1.0;
                    playerAction = this.sampling.generatePlayerActionGivenDist(list, n, gameState, arrayList2, null);
                    ((double[])arrayList2.get((int)n3))[n4] = 0.0;
                    PlayerAction playerAction2 = new PlayerAction();
                    for (Sampling.UnitActionTableEntry unitActionTableEntry2 : list) {
                        for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                            if (!((Unit)pair.m_a).equals(unitActionTableEntry2.u)) continue;
                            playerAction2.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
                        }
                    }
                    playerAction = playerAction2;
                    if (!this.isPlayerActionValid(gameState, playerAction)) {
                        throw new RuntimeException("Should generate only valid combinations!");
                    }
                    double d = this.sampling.evaluatePlayerAction(n, gameState, playerAction, 1);
                    switch (this.estimateReuseType) {
                        case SINGLE: {
                            this.updateActionEvalSingle(list, playerAction, n3, d);
                            break;
                        }
                        case ALL: {
                            this.updateActionEvalAll(list, playerAction, n3, d);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown EstimateReusingType");
                        }
                    }
                    if ((double)(++n2) >= (double)this.ITERATIONS_BUDGET * this.split) break block6;
                    ++n4;
                }
                ++n3;
            }
            bl = true;
        }
        if (!bl) {
            System.err.println("Generate did not complete even one round! " + n2 + " >= (" + this.ITERATIONS_BUDGET + " * " + this.split + ")");
        }
        for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
            Object object = Double.POSITIVE_INFINITY;
            for (Object object2 : (Object)unitActionTableEntry.accum_evaluation) {
                if (!(object2 < object)) continue;
                object = object2;
            }
            for (int j = 0; j < unitActionTableEntry.accum_evaluation.length; ++j) {
                if (unitActionTableEntry.accum_evaluation[j] == Double.MIN_VALUE) {
                    if (this.eliteReuse) {
                        unitActionTableEntry.accum_evaluation[j] = 0.01;
                    } else {
                        int n5 = j;
                        unitActionTableEntry.accum_evaluation[n5] = unitActionTableEntry.accum_evaluation[n5] - (object - 0.01);
                    }
                } else {
                    int n6 = j;
                    unitActionTableEntry.accum_evaluation[n6] = unitActionTableEntry.accum_evaluation[n6] - (object - 0.01);
                }
                if (!(unitActionTableEntry.accum_evaluation[j] < 0.0) && !Double.isNaN(unitActionTableEntry.accum_evaluation[j])) continue;
                System.err.println("Negative/NaN distribution!");
            }
            arrayList.add(unitActionTableEntry.accum_evaluation);
        }
        return arrayList;
    }

    private List<double[]> stageGenerateRandom(int n, GameState gameState, List<Sampling.UnitActionTableEntry> list) throws Exception {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
            arrayList.add(new double[unitActionTableEntry.nactions]);
        }
        return arrayList;
    }

    private List<double[]> stageGenerateRandomTailElite(int n, GameState gameState, List<Sampling.UnitActionTableEntry> list) throws Exception {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n2 = 0;
        while ((double)n2 < (double)this.ITERATIONS_BUDGET * this.split) {
            int n3 = 0;
            for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
                block6: for (UnitAction j : unitActionTableEntry.actions) {
                    PlayerAction playerAction = new PlayerAction();
                    for (Sampling.UnitActionTableEntry unitActionTableEntry2 : list) {
                        playerAction.addUnitAction(unitActionTableEntry2.u, unitActionTableEntry2.actions.get(this.rnd.nextInt(unitActionTableEntry2.nactions)));
                    }
                    playerAction.getActions().set(n3, new Pair<Unit, UnitAction>(unitActionTableEntry.u, j));
                    if (!this.isPlayerActionValid(gameState, playerAction)) continue;
                    ++n2;
                    double d = this.sampling.evaluatePlayerAction(n, gameState, playerAction, 1);
                    if (this.eliteReuse) {
                        if (this.elitePlayerActions.containsKey(playerAction)) {
                            Pair<Double, Integer> pair = this.elitePlayerActions.get(playerAction);
                            double d2 = ((Double)pair.m_a * (double)((Integer)pair.m_b).intValue() + d) / (double)((Integer)pair.m_b + 1);
                            this.elitePlayerActions.put(playerAction, new Pair<Double, Integer>(d2, (Integer)pair.m_b + 1));
                        } else {
                            this.elitePlayerActions.put(playerAction, new Pair<Double, Integer>(d, 1));
                        }
                    }
                    switch (this.estimateReuseType) {
                        case SINGLE: {
                            this.updateActionEvalSingle(list, playerAction, n3, d);
                            continue block6;
                        }
                        case ALL: {
                            this.updateActionEvalAll(list, playerAction, n3, d);
                            continue block6;
                        }
                    }
                    throw new RuntimeException("Unknown EstimateReusingType");
                }
                ++n3;
            }
        }
        for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
            double d = Double.POSITIVE_INFINITY;
            for (double d3 : unitActionTableEntry.accum_evaluation) {
                if (!(d3 < d)) continue;
                d = d3;
            }
            for (int j = 0; j < unitActionTableEntry.accum_evaluation.length; ++j) {
                int n3 = j;
                unitActionTableEntry.accum_evaluation[n3] = unitActionTableEntry.accum_evaluation[n3] - (d - 0.01);
                if (!(unitActionTableEntry.accum_evaluation[j] < 0.0) && !Double.isNaN(unitActionTableEntry.accum_evaluation[j])) continue;
                System.err.println("Negative/NaN distribution!");
            }
            arrayList.add(unitActionTableEntry.accum_evaluation);
        }
        return arrayList;
    }

    private void updateActionEvalSingle(List<Sampling.UnitActionTableEntry> list, PlayerAction playerAction, int n, double d) {
        int n2 = 0;
        Sampling.UnitActionTableEntry unitActionTableEntry = list.get(n);
        for (UnitAction unitAction : unitActionTableEntry.actions) {
            if (unitAction.equals(playerAction.getActions().get((int)n).m_b)) {
                unitActionTableEntry.accum_evaluation[n2] = (unitActionTableEntry.accum_evaluation[n2] * (double)unitActionTableEntry.visit_count[n2] + d) / (double)(unitActionTableEntry.visit_count[n2] + 1);
                int n3 = n2;
                unitActionTableEntry.visit_count[n3] = unitActionTableEntry.visit_count[n3] + 1;
            }
            ++n2;
        }
    }

    private void updateActionEvalAll(List<Sampling.UnitActionTableEntry> list, PlayerAction playerAction, int n, double d) {
        n = 0;
        for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
            int n2 = 0;
            for (UnitAction unitAction : unitActionTableEntry.actions) {
                if (unitAction.equals(playerAction.getActions().get((int)n).m_b)) {
                    unitActionTableEntry.accum_evaluation[n2] = (unitActionTableEntry.accum_evaluation[n2] * (double)unitActionTableEntry.visit_count[n2] + d) / (double)(unitActionTableEntry.visit_count[n2] + 1);
                    int n3 = n2;
                    unitActionTableEntry.visit_count[n3] = unitActionTableEntry.visit_count[n3] + 1;
                }
                ++n2;
            }
            ++n;
        }
    }

    private Set<PlayerAction> stageChoosePlayerActionsAllRelaxation(List<double[]> list, int n, GameState gameState, List<Sampling.UnitActionTableEntry> list2) throws Exception {
        if (this.relaxationLimit > 0 && list2.size() - this.relaxationLimit >= 1) {
            Object object;
            List<Pair<Integer, Double>> list3 = new LinkedList();
            for (int j = 0; j < list.size(); ++j) {
                double d;
                object = list.get(j);
                switch (this.relaxationType) {
                    case MAX: {
                        Arrays.sort(object);
                        d = object[((double[])object).length - 1];
                        break;
                    }
                    case MEAN: {
                        double d2 = 0.0;
                        for (double d3 : object) {
                            d2 += d3;
                        }
                        d = d2 / (double)((double[])object).length;
                        break;
                    }
                    case MEDIAN: {
                        Arrays.sort(object);
                        if (((double[])object).length % 2 == 0) {
                            d = (object[((double[])object).length / 2] + object[((double[])object).length / 2 - 1]) / 2.0;
                            break;
                        }
                        d = object[(int)Math.floor(((double[])object).length / 2)];
                        break;
                    }
                    case MAX_ENT: {
                        d = this.sampling.entropy((double[])object);
                        break;
                    }
                    case MIN_ENT: {
                        d = 1.0 / this.sampling.entropy((double[])object);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown RelaxationType!");
                    }
                }
                list3.add(new Pair<Integer, Double>(j, d));
            }
            Collections.sort(list3, new Comparator<Pair<Integer, Double>>(){

                @Override
                public int compare(Pair<Integer, Double> pair, Pair<Integer, Double> pair2) {
                    double d;
                    double d2 = (Double)pair.m_b;
                    return d2 > (d = ((Double)pair2.m_b).doubleValue()) ? 1 : (d2 < d ? -1 : 0);
                }
            });
            list3 = list3.subList(0, list3.size() - this.relaxationLimit);
            Collections.sort(list3, new Comparator<Pair<Integer, Double>>(){

                @Override
                public int compare(Pair<Integer, Double> pair, Pair<Integer, Double> pair2) {
                    double d;
                    double d2 = ((Integer)pair.m_a).intValue();
                    return d2 < (d = (double)((Integer)pair2.m_a).intValue()) ? 1 : (d2 > d ? -1 : 0);
                }
            });
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                object = (Pair)iterator.next();
                list2.remove((Integer)object.m_a);
            }
        }
        return this.sampling.generatePlayerActionAll(list2, n, gameState, false);
    }

    private Set<PlayerAction> stageChoosePlayerActionByDist(List<double[]> list, int n, GameState gameState, List<Sampling.UnitActionTableEntry> list2) throws Exception {
        int n2 = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        int n3 = 1;
        while ((int)((double)(n2 / ++n3) / Math.ceil(Sampling.log(n3, 2.0))) != 1) {
        }
        HashSet<PlayerAction> hashSet = new HashSet<PlayerAction>();
        for (int j = 0; j < n3; ++j) {
            PlayerAction playerAction;
            switch (this.generateType) {
                case PER_AGENT: {
                    playerAction = this.sampling.generatePlayerActionGivenDist(list2, n, gameState, list, null);
                    break;
                }
                case ONE_DIST: {
                    playerAction = this.sampling.generatePlayerActionOneDist(list2, n, gameState, list);
                    break;
                }
                default: {
                    throw new RuntimeException("Unkonwn GenerateType");
                }
            }
            if (hashSet.contains(playerAction)) continue;
            hashSet.add(playerAction);
        }
        return hashSet;
    }

    private PlayerAction stageEvaluateHalving(Set<PlayerAction> set, int n, GameState gameState) throws Exception {
        int n2;
        int n3;
        int n4 = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        List<Pair<PlayerAction, Double>> list = new LinkedList<Pair<PlayerAction, Double>>();
        for (PlayerAction playerAction : set) {
            list.add(new Pair<PlayerAction, Double>(playerAction, 0.0));
        }
        this.actionCount = list.size();
        double d = Math.ceil(Sampling.log(this.actionCount, 2.0));
        int n5 = this.log2int(this.actionCount);
        int n6 = this.actionCount;
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = (int)((double)(n4 / n6) / d);
            n7 += n2 * n6;
            n6 /= 2;
        }
        n3 = n4 - n7;
        n2 = 0;
        for (int j = 0; j < n5 - 1; ++j) {
            int n8 = (int)((double)(n4 / list.size()) / d);
            n3 -= n3 / list.size() * list.size();
            list = this.sampling.halvedOriginalSampling(list, gameState, n, n8 += n3 / list.size(), n2);
            n2 += n8;
        }
        list = this.sampling.halvedOriginalSampling(list, gameState, n, (n4 - this.sampling.getSimulationCount()) / list.size(), n2);
        return (PlayerAction)list.get((int)0).m_a;
    }

    private PlayerAction stageEvaluateHalvingFill(Set<PlayerAction> set, int n, GameState gameState) throws Exception {
        int n2;
        int n3;
        int n4 = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        List<Pair<PlayerAction, Double>> list = new LinkedList<Pair<PlayerAction, Double>>();
        for (PlayerAction playerAction : set) {
            list.add(new Pair<PlayerAction, Double>(playerAction, 0.0));
        }
        this.actionCount = list.size();
        int n5 = this.log2int(this.actionCount);
        int n6 = this.actionCount;
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = n4 / n6 / n5;
            n7 += n2 * n6;
            n6 /= 2;
        }
        n3 = n4 - n7;
        n2 = 0;
        for (int j = 0; j < n5; ++j) {
            int n8 = n4 / list.size() / n5;
            n3 -= n3 / list.size() * list.size();
            list = this.sampling.halvedOriginalSamplingFill(list, gameState, n, n8 += n3 / list.size(), n2);
            n2 += n8;
        }
        return (PlayerAction)((Pair)list.get((int)0)).m_a;
    }

    private PlayerAction stageEvaluateEliteHalving(Set<PlayerAction> set, int n, GameState gameState) throws Exception {
        int n2;
        int n3;
        int n4 = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        List<Pair<PlayerAction, Pair<Double, Integer>>> list = new LinkedList<Pair<PlayerAction, Pair<Double, Integer>>>();
        for (PlayerAction object : set) {
            list.add(new Pair<PlayerAction, Pair<Double, Integer>>(object, new Pair<Double, Integer>(0.0, 0)));
        }
        if (this.eliteReuse) {
            ArrayList<Map.Entry<PlayerAction, Pair<Double, Integer>>> arrayList = new ArrayList<Map.Entry<PlayerAction, Pair<Double, Integer>>>(this.elitePlayerActions.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<PlayerAction, Pair<Double, Integer>>>(){

                @Override
                public int compare(Map.Entry<PlayerAction, Pair<Double, Integer>> entry, Map.Entry<PlayerAction, Pair<Double, Integer>> entry2) {
                    double d;
                    double d2 = (Double)entry.getValue().m_a / (double)((Integer)entry.getValue().m_b).intValue();
                    return d2 < (d = (Double)entry2.getValue().m_a / (double)((Integer)entry2.getValue().m_b).intValue()) ? 1 : (d2 > d ? -1 : 0);
                }
            });
            while (!arrayList.isEmpty()) {
                Map.Entry entry = (Map.Entry)arrayList.remove(0);
                if (set.contains(entry.getKey())) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Pair pair = (Pair)iterator.next();
                        if (!((PlayerAction)pair.m_a).equals(entry.getKey())) continue;
                        iterator.remove();
                        break;
                    }
                } else {
                    set.add((PlayerAction)entry.getKey());
                }
                list.add(new Pair(entry.getKey(), entry.getValue()));
                if (list.size() < this.actionCount) continue;
                break;
            }
        }
        this.actionCount = list.size();
        double d = Math.ceil(Sampling.log(this.actionCount, 2.0));
        int n5 = this.log2int(this.actionCount);
        int n6 = this.actionCount;
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = (int)((double)(n4 / n6) / d);
            n7 += n2 * n6;
            n6 /= 2;
        }
        n3 = n4 - n7;
        for (n2 = 0; n2 < n5 - 1; ++n2) {
            int n8 = (int)((double)(n4 / list.size()) / d);
            n3 -= n3 / list.size() * list.size();
            list = this.sampling.halvedSampling(list, gameState, n, n8 += n3 / list.size());
        }
        list = this.sampling.halvedSampling(list, gameState, n, (this.ITERATIONS_BUDGET - this.sampling.getSimulationCount()) / list.size());
        return (PlayerAction)list.get((int)0).m_a;
    }

    private PlayerAction stageEvaluateBest(Set<PlayerAction> set, int n, GameState gameState) throws Exception {
        Integer n2;
        Object object;
        int n3 = (int)((double)this.ITERATIONS_BUDGET * (1.0 - this.split));
        LinkedList<Pair<PlayerAction, Pair<Double, Integer>>> linkedList = new LinkedList<Pair<PlayerAction, Pair<Double, Integer>>>();
        for (PlayerAction object2 : set) {
            linkedList.add(new Pair<PlayerAction, Pair<Double, Integer>>(object2, new Pair<Double, Integer>(0.0, 0)));
        }
        this.actionCount = linkedList.size();
        for (Pair pair : linkedList) {
            double d = this.sampling.evaluatePlayerAction(n, gameState, (PlayerAction)pair.m_a, 1);
            object = (Pair)pair.m_b;
            Double.valueOf((Double)((Pair)object).m_a + d);
            ((Pair)object).m_a = ((Pair)object).m_a;
            object = (Pair)pair.m_b;
            n2 = (Integer)((Pair)object).m_b;
            ((Pair)object).m_b = (Integer)((Pair)object).m_b + 1;
            Integer n4 = ((Pair)object).m_b;
        }
        for (int j = 0; j <= n3 - this.actionCount; ++j) {
            Collections.sort(linkedList, new Comparator<Pair<PlayerAction, Pair<Double, Integer>>>(){

                @Override
                public int compare(Pair<PlayerAction, Pair<Double, Integer>> pair, Pair<PlayerAction, Pair<Double, Integer>> pair2) {
                    double d;
                    double d2 = (Double)((Pair)pair.m_b).m_a / (double)((Integer)((Pair)pair.m_b).m_b).intValue();
                    return d2 < (d = (Double)((Pair)pair2.m_b).m_a / (double)((Integer)((Pair)pair2.m_b).m_b).intValue()) ? 1 : (d2 > d ? -1 : 0);
                }
            });
            double d = this.sampling.evaluatePlayerAction(n, gameState, (PlayerAction)((Pair)linkedList.get((int)0)).m_a, 1);
            Pair pair = (Pair)((Pair)linkedList.get((int)0)).m_b;
            Double.valueOf((Double)pair.m_a + d);
            pair.m_a = pair.m_a;
            pair = (Pair)((Pair)linkedList.get((int)0)).m_b;
            object = (Integer)pair.m_b;
            pair.m_b = (Integer)pair.m_b + 1;
            n2 = pair.m_b;
        }
        return (PlayerAction)((Pair)linkedList.get((int)0)).m_a;
    }

    private void incrementActionCounter(PlayerAction playerAction, List<Sampling.UnitActionTableEntry> list) {
        ++this.nofPlays;
        this.nofNoops += playerAction.hasNamNoneActions();
        this.nofSamples += this.sampling.getSimulationCount();
        this.nofPlayedUnits += playerAction.getActions().size();
        for (Sampling.UnitActionTableEntry unitActionTableEntry : list) {
            this.nofActions += unitActionTableEntry.nactions;
        }
    }

    private int log2int(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    private boolean isPlayerActionValid(GameState gameState, PlayerAction playerAction) {
        ResourceUsage resourceUsage;
        ResourceUsage resourceUsage2 = new ResourceUsage();
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        for (Unit object : physicalGameState.getUnits()) {
            UnitActionAssignment unitActionAssignment = gameState.getUnitActions().get(object);
            if (unitActionAssignment == null) continue;
            resourceUsage = unitActionAssignment.action.resourceUsage(object, physicalGameState);
            resourceUsage2.merge(resourceUsage);
        }
        ResourceUsage resourceUsage3 = new ResourceUsage();
        for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
            resourceUsage = ((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, physicalGameState);
            resourceUsage3.merge(resourceUsage);
        }
        playerAction.setResourceUsage(resourceUsage3);
        return playerAction.consistentWith(resourceUsage2, gameState);
    }

    private List<Sampling.UnitActionTableEntry> prepareUnitActionTable(GameState gameState, int n) throws Exception {
        ArrayList<Sampling.UnitActionTableEntry> arrayList = new ArrayList<Sampling.UnitActionTableEntry>();
        this.actionCount = 0;
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        int n2 = 0;
        for (Pair<Unit, List<UnitAction>> pair : playerActionGenerator.getChoices()) {
            Sampling.UnitActionTableEntry unitActionTableEntry = new Sampling.UnitActionTableEntry();
            unitActionTableEntry.idx = n2;
            unitActionTableEntry.u = (Unit)pair.m_a;
            unitActionTableEntry.nactions = ((List)pair.m_b).size();
            unitActionTableEntry.actions = (List)pair.m_b;
            unitActionTableEntry.accum_evaluation = new double[unitActionTableEntry.nactions];
            unitActionTableEntry.visit_count = new int[unitActionTableEntry.nactions];
            for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                unitActionTableEntry.accum_evaluation[j] = Double.MIN_VALUE;
                unitActionTableEntry.visit_count[j] = 0;
            }
            arrayList.add(unitActionTableEntry);
            ++n2;
            this.actionCount += unitActionTableEntry.nactions;
        }
        return arrayList;
    }

    private List<Integer> getRelaxedAgentIndicesRandom(List<Sampling.UnitActionTableEntry> list) {
        List<Integer> list2 = new ArrayList<Integer>();
        int n = list.size() - this.relaxationLimit;
        if (n > 0) {
            for (int j = 0; j < list.size(); ++j) {
                list2.add(j);
            }
            Collections.shuffle(list2);
            list2 = list2.subList(0, n);
            Collections.sort(list2);
            Collections.reverse(list2);
        }
        return list2;
    }

    public void printState(List<Sampling.UnitActionTableEntry> list, HashMap<Long, PlayerActionTableEntry> hashMap) {
        System.out.println("Unit actions table:");
        for (Sampling.UnitActionTableEntry object : list) {
            System.out.println("Actions for unit " + object.u);
            for (int j = 0; j < object.nactions; ++j) {
                System.out.println("   " + object.actions.get(j) + " visited " + object.visit_count[j] + " with average evaluation " + object.accum_evaluation[j] / (double)object.visit_count[j]);
            }
        }
        System.out.println("Player actions:");
        for (PlayerActionTableEntry playerActionTableEntry : hashMap.values()) {
            System.out.println(playerActionTableEntry.pa + " visited " + playerActionTableEntry.visit_count + " with average evaluation " + playerActionTableEntry.accum_evaluation / (float)playerActionTableEntry.visit_count);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.ITERATIONS_BUDGET + ", " + this.lookAhead + ", " + this.split + ", " + (Object)((Object)this.estimateType) + ", " + (Object)((Object)this.estimateReuseType) + ", " + (Object)((Object)this.generateType) + ", " + (Object)((Object)this.agentOrderingType) + ", " + (Object)((Object)this.evaluateType) + ", " + this.eliteReuse + ", " + (Object)((Object)this.relaxationType) + ", " + this.relaxationLimit + ", " + this.epochal + ", " + this.simulationAi + ", " + this.evalFunction + ")";
    }

    @Override
    public String statisticsString() {
        return this.nofPlays + "\t" + this.nofNoops + "\t" + this.nofSamples + "\t" + (double)this.nofPlayedUnits / (double)this.nofPlays + "\t" + (double)this.nofActions / (double)this.nofPlays;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, 500));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        ParameterSpecification parameterSpecification = new ParameterSpecification("Split", Double.TYPE, 0.25);
        parameterSpecification.setRange(0.0, 1.0);
        arrayList.add(parameterSpecification);
        ParameterSpecification parameterSpecification2 = new ParameterSpecification("EstimateType", EstimateType.class, (Object)EstimateType.RANDOM_TAIL);
        parameterSpecification2.addPossibleValue((Object)EstimateType.RANDOM_TAIL);
        parameterSpecification2.addPossibleValue((Object)EstimateType.RANDOM_TAIL_ELITE);
        parameterSpecification2.addPossibleValue((Object)EstimateType.NOOP_TAIL);
        parameterSpecification2.addPossibleValue((Object)EstimateType.RANDOM);
        parameterSpecification2.addPossibleValue((Object)EstimateType.ALL_COMBINATIONS);
        arrayList.add(parameterSpecification2);
        ParameterSpecification parameterSpecification3 = new ParameterSpecification("EstimateReuseType", EstimateReuseType.class, (Object)EstimateReuseType.ALL);
        parameterSpecification3.addPossibleValue((Object)EstimateReuseType.ALL);
        parameterSpecification3.addPossibleValue((Object)EstimateReuseType.SINGLE);
        arrayList.add(parameterSpecification3);
        ParameterSpecification parameterSpecification4 = new ParameterSpecification("GenerateType", GenerateType.class, (Object)GenerateType.PER_AGENT);
        parameterSpecification4.addPossibleValue((Object)GenerateType.ONE_DIST);
        parameterSpecification4.addPossibleValue((Object)GenerateType.PER_AGENT);
        arrayList.add(parameterSpecification4);
        ParameterSpecification parameterSpecification5 = new ParameterSpecification("AgentOrderingType", Sampling.AgentOrderingType.class, (Object)Sampling.AgentOrderingType.ENTROPY);
        parameterSpecification5.addPossibleValue((Object)Sampling.AgentOrderingType.RANDOM);
        parameterSpecification5.addPossibleValue((Object)Sampling.AgentOrderingType.ENTROPY);
        arrayList.add(parameterSpecification5);
        ParameterSpecification parameterSpecification6 = new ParameterSpecification("EvaluateType", EvaluateType.class, (Object)EvaluateType.HALVING);
        parameterSpecification6.addPossibleValue((Object)EvaluateType.HALVING);
        parameterSpecification6.addPossibleValue((Object)EvaluateType.HALVING_ELITE);
        parameterSpecification6.addPossibleValue((Object)EvaluateType.BEST);
        arrayList.add(parameterSpecification6);
        arrayList.add(new ParameterSpecification("EliteReuse", Boolean.TYPE, false));
        ParameterSpecification parameterSpecification7 = new ParameterSpecification("RelaxationType", RelaxationType.class, (Object)RelaxationType.NONE);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.NONE);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.PRE_RANDOM);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.EPOCH);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.MAX);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.MEAN);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.MEDIAN);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.MAX_ENT);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.MIN_ENT);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.POST_RANDOM);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.POST_ENTROPY_MAX);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.POST_ENTROPY_MIN);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.POST_MAX_DIFF);
        parameterSpecification7.addPossibleValue((Object)RelaxationType.POST_MAX_TIME_NORMALIZE);
        arrayList.add(parameterSpecification7);
        arrayList.add(new ParameterSpecification("RelaxationLimit", Integer.TYPE, 2));
        arrayList.add(new ParameterSpecification("Epochal", Boolean.TYPE, this.epochal));
        arrayList.add(new ParameterSpecification("SimulationAI", AI.class, this.simulationAi));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.lookAhead;
    }

    public void setPlayoutLookahead(int n) {
        this.lookAhead = n;
    }

    public double getSplit() {
        return this.split;
    }

    public void setSplit(double d) {
        this.split = d;
    }

    public EstimateType getEstimateType() {
        return this.estimateType;
    }

    public void setEstimateType(EstimateType estimateType) {
        this.estimateType = estimateType;
    }

    public EstimateReuseType getEstimateReuseType() {
        return this.estimateReuseType;
    }

    public void setEstimateReuseType(EstimateReuseType estimateReuseType) {
        this.estimateReuseType = estimateReuseType;
    }

    public GenerateType getGenerateType() {
        return this.generateType;
    }

    public void setGenerateType(GenerateType generateType) {
        this.generateType = generateType;
    }

    public Sampling.AgentOrderingType getAgentOrderingType() {
        return this.agentOrderingType;
    }

    public void setAgentOrderingType(Sampling.AgentOrderingType agentOrderingType) {
        this.agentOrderingType = agentOrderingType;
    }

    public EvaluateType getEvaluateType() {
        return this.evaluateType;
    }

    public void setEvaluateType(EvaluateType evaluateType) {
        this.evaluateType = evaluateType;
    }

    public boolean getEliteReuse() {
        return this.eliteReuse;
    }

    public void setEliteReuse(boolean bl) {
        this.eliteReuse = bl;
    }

    public RelaxationType getRelaxationType() {
        return this.relaxationType;
    }

    public void setRelaxationType(RelaxationType relaxationType) {
        this.relaxationType = relaxationType;
    }

    public int getRelaxationLimit() {
        return this.relaxationLimit;
    }

    public void setRelaxationLimit(int n) {
        this.relaxationLimit = n;
    }

    public boolean getEpochal() {
        return this.epochal;
    }

    public void setEpochal(boolean bl) {
        this.epochal = bl;
    }

    public AI getSimulationAI() {
        return this.simulationAi;
    }

    public void setSimulationAI(AI aI) {
        this.simulationAi = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evalFunction;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.evalFunction = evaluationFunction;
    }

    class PlayerActionTableEntry {
        long code;
        int[] selectedUnitActions;
        PlayerAction pa;
        float accum_evaluation;
        int visit_count;

        PlayerActionTableEntry() {
        }
    }

    public static enum RelaxationType {
        NONE,
        PRE_RANDOM,
        EPOCH,
        MAX,
        MEAN,
        MEDIAN,
        MAX_ENT,
        MIN_ENT,
        POST_RANDOM,
        POST_ENTROPY_MAX,
        POST_ENTROPY_MIN,
        POST_MAX_DIFF,
        POST_MAX_TIME_NORMALIZE;

    }

    public static enum EvaluateType {
        HALVING,
        HALVING_ELITE,
        BEST;

    }

    public static enum GenerateType {
        ONE_DIST,
        PER_AGENT;

    }

    public static enum EstimateReuseType {
        ALL,
        SINGLE;

    }

    public static enum EstimateType {
        RANDOM_TAIL,
        RANDOM_TAIL_ELITE,
        NOOP_TAIL,
        RANDOM,
        ALL_COMBINATIONS;

    }
}

