/*
 * Decompiled with CFR 0.152.
 */
package ai.montecarlo.lsi;

import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import util.CartesianProduct;
import util.Pair;
import util.Sampler;

public class Sampling {
    private final AgentOrderingType agentOrderingType;
    private final int lookAhead;
    private final EvaluationFunction evalFunction;
    private final AI simulationAi;
    private int simulationCount = 0;

    public Sampling(AgentOrderingType agentOrderingType, int n, AI aI, EvaluationFunction evaluationFunction) {
        this.agentOrderingType = agentOrderingType;
        this.lookAhead = n;
        this.evalFunction = evaluationFunction;
        this.simulationAi = aI;
    }

    public double evaluatePlayerAction(int n, GameState gameState, PlayerAction playerAction, int n2) throws Exception {
        double d = 0.0;
        for (int j = 0; j < n2; ++j) {
            GameState gameState2 = gameState.cloneIssue(playerAction);
            GameState gameState3 = gameState2.clone();
            this.simulate(gameState3, gameState3.getTime() + this.lookAhead);
            int n3 = gameState3.getTime() - gameState2.getTime();
            double d2 = (double)this.evalFunction.evaluate(n, 1 - n, gameState3) * Math.pow(0.99, (double)n3 / 10.0);
            d = ((double)j * d + d2) / (double)(j + 1);
        }
        return d;
    }

    private void simulate(GameState gameState, int n) throws Exception {
        ++this.simulationCount;
        boolean bl = false;
        do {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(this.simulationAi.getAction(0, gameState));
            gameState.issue(this.simulationAi.getAction(1, gameState));
        } while (!bl && gameState.getTime() < n);
    }

    public PlayerAction generatePlayerActionGivenDist(List<UnitActionTableEntry> list, int n, GameState gameState, List<double[]> list2, List<Integer> list3) throws Exception {
        ArrayList<Pair<Integer, Double>> arrayList;
        Object object;
        PhysicalGameState physicalGameState;
        block14: {
            block13: {
                ResourceUsage resourceUsage = new ResourceUsage();
                physicalGameState = gameState.getPhysicalGameState();
                for (Unit serializable2 : physicalGameState.getUnits()) {
                    UnitActionAssignment j = gameState.getUnitActions().get(serializable2);
                    if (j == null) continue;
                    ResourceUsage resourceUsage2 = j.action.resourceUsage(serializable2, physicalGameState);
                    resourceUsage.merge(resourceUsage2);
                }
                object = new PlayerAction();
                ((PlayerAction)object).setResourceUsage(resourceUsage.clone());
                arrayList = new ArrayList<Pair<Integer, Double>>(list2.size());
                if (list3 != null) break block13;
                for (int object2 = 0; object2 < list2.size(); ++object2) {
                    arrayList.add(new Pair<Integer, Double>(object2, this.entropy(list2.get(object2))));
                }
                switch (this.agentOrderingType) {
                    case RANDOM: {
                        Collections.shuffle(arrayList);
                        break block14;
                    }
                    case ENTROPY: {
                        Collections.sort(arrayList, new Comparator<Pair<Integer, Double>>(){

                            @Override
                            public int compare(Pair<Integer, Double> pair, Pair<Integer, Double> pair2) {
                                return (Double)pair.m_b > (Double)pair2.m_b ? 1 : ((Double)pair.m_b < (Double)pair2.m_b ? -1 : 0);
                            }
                        });
                        break block14;
                    }
                    default: {
                        throw new RuntimeException("Unknown AgentOrderingType");
                    }
                }
            }
            for (Integer n2 : list3) {
                arrayList.add(new Pair<Integer, Double>(n2, 0.0));
            }
        }
        for (Pair pair : arrayList) {
            double[] dArray = list2.get((Integer)pair.m_a);
            UnitActionTableEntry unitActionTableEntry = list.get((Integer)pair.m_a);
            int n3 = Sampler.weighted(dArray);
            UnitAction unitAction = unitActionTableEntry.actions.get(n3);
            ResourceUsage resourceUsage = unitAction.resourceUsage(unitActionTableEntry.u, physicalGameState);
            if (!((PlayerAction)object).getResourceUsage().consistentWith(resourceUsage, gameState)) {
                int n4;
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    arrayList2.add(dArray[n4]);
                    arrayList3.add(n4);
                }
                do {
                    n4 = arrayList3.indexOf(n3);
                    arrayList2.remove(n4);
                    arrayList3.remove(n4);
                    n3 = (Integer)Sampler.weighted(arrayList2, arrayList3);
                    unitAction = unitActionTableEntry.actions.get(n3);
                    resourceUsage = unitAction.resourceUsage(unitActionTableEntry.u, physicalGameState);
                } while (!((PlayerAction)object).getResourceUsage().consistentWith(resourceUsage, gameState));
            }
            ((PlayerAction)object).getResourceUsage().merge(resourceUsage);
            ((PlayerAction)object).addUnitAction(unitActionTableEntry.u, unitAction);
        }
        PlayerAction playerAction = new PlayerAction();
        for (UnitActionTableEntry unitActionTableEntry : list) {
            for (Pair pair : ((PlayerAction)object).getActions()) {
                if (!((Unit)pair.m_a).equals(unitActionTableEntry.u)) continue;
                playerAction.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
            }
        }
        object = playerAction;
        return object;
    }

    public PlayerAction generatePlayerActionOneDist(List<UnitActionTableEntry> list, int n, GameState gameState, List<double[]> list2) throws Exception {
        Object object;
        Object object2;
        ResourceUsage resourceUsage = new ResourceUsage();
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        for (Unit serializable2 : physicalGameState.getUnits()) {
            object2 = gameState.getUnitActions().get(serializable2);
            if (object2 == null) continue;
            ResourceUsage n2 = ((UnitActionAssignment)object2).action.resourceUsage(serializable2, physicalGameState);
            resourceUsage.merge(n2);
        }
        PlayerAction playerAction = new PlayerAction();
        playerAction.setResourceUsage(resourceUsage.clone());
        ArrayList arrayList = new ArrayList();
        object2 = new ArrayList();
        int n2 = 0;
        for (double[] dArray : list2) {
            double object3 = 0.0;
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            ArrayList<Integer> j = new ArrayList<Integer>();
            for (int k = 0; k < dArray.length; ++k) {
                arrayList2.add(dArray[k]);
                j.add(k);
                object3 += dArray[k];
            }
            Pair j2 = new Pair(object3, arrayList2);
            object = new Pair(n2, j);
            ((ArrayList)object2).add(j2);
            arrayList.add(object);
            ++n2;
        }
        double d = 0.0;
        Object object3 = ((ArrayList)object2).iterator();
        while (object3.hasNext()) {
            Pair d2 = (Pair)object3.next();
            d += ((Double)d2.m_a).doubleValue();
        }
        block4: while (!((ArrayList)object2).isEmpty()) {
            object3 = new Random();
            double d2 = ((Random)object3).nextDouble() * d;
            for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                if (d2 > (Double)((Pair)((ArrayList)object2).get((int)j)).m_a) {
                    d2 -= ((Double)((Pair)((ArrayList)object2).get((int)j)).m_a).doubleValue();
                    continue;
                }
                for (int k = 0; k < ((ArrayList)((Pair)((ArrayList)object2).get((int)j)).m_b).size(); ++k) {
                    if (d2 > (Double)((ArrayList)((Pair)((ArrayList)object2).get((int)j)).m_b).get(k)) {
                        d2 -= ((Double)((ArrayList)((Pair)((ArrayList)object2).get((int)j)).m_b).get(k)).doubleValue();
                        continue;
                    }
                    object = list.get((Integer)((Pair)arrayList.get((int)j)).m_a);
                    UnitAction unitAction = ((UnitActionTableEntry)object).actions.get((Integer)((ArrayList)((Pair)arrayList.get((int)j)).m_b).get(k));
                    ResourceUsage resourceUsage2 = unitAction.resourceUsage(((UnitActionTableEntry)object).u, physicalGameState);
                    if (!playerAction.getResourceUsage().consistentWith(resourceUsage2, gameState)) {
                        d -= ((Double)((ArrayList)((Pair)((ArrayList)object2).get((int)j)).m_b).get(k)).doubleValue();
                        Pair pair = (Pair)((ArrayList)object2).get(j);
                        Double.valueOf((Double)pair.m_a - (Double)((ArrayList)((Pair)((ArrayList)object2).get((int)j)).m_b).get(k));
                        pair.m_a = pair.m_a;
                        ((ArrayList)((Pair)((ArrayList)object2).get((int)j)).m_b).remove(k);
                        ((ArrayList)((Pair)arrayList.get((int)j)).m_b).remove(k);
                        continue;
                    }
                    d -= ((Double)((Pair)((ArrayList)object2).get((int)j)).m_a).doubleValue();
                    ((ArrayList)object2).remove(j);
                    arrayList.remove(j);
                    playerAction.getResourceUsage().merge(resourceUsage2);
                    playerAction.addUnitAction(((UnitActionTableEntry)object).u, unitAction);
                    continue block4;
                }
                continue block4;
            }
        }
        return playerAction;
    }

    public Set<PlayerAction> generatePlayerActionAll(List<UnitActionTableEntry> list, int n, GameState gameState, boolean bl) throws Exception {
        Object object;
        ResourceUsage resourceUsage = new ResourceUsage();
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        for (Unit serializable2 : physicalGameState.getUnits()) {
            object = gameState.getUnitActions().get(serializable2);
            if (object == null) continue;
            ResourceUsage n2 = ((UnitActionAssignment)object).action.resourceUsage(serializable2, physicalGameState);
            resourceUsage.merge(n2);
        }
        HashSet hashSet = new HashSet();
        ArrayList arrayList = new ArrayList(list.size());
        for (UnitActionTableEntry unitActionTableEntry : list) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            for (int j = 0; j < unitActionTableEntry.nactions; ++j) {
                if (unitActionTableEntry.actions.get(j).getType() == 0 && !bl) continue;
                hashSet2.add(j);
            }
            arrayList.add(hashSet2);
        }
        object = new CartesianProduct(arrayList);
        int n2 = ((CartesianProduct)object).size();
        for (int j = 0; j < n2; ++j) {
            List list2 = ((CartesianProduct)object).element(j);
            PlayerAction playerAction = new PlayerAction();
            playerAction.setResourceUsage(resourceUsage.clone());
            boolean bl2 = true;
            for (int k = 0; k < list2.size(); ++k) {
                int n3 = (Integer)list2.get(k);
                UnitActionTableEntry unitActionTableEntry = list.get(k);
                UnitAction unitAction = unitActionTableEntry.actions.get(n3);
                if (!playerAction.consistentWith(unitAction.resourceUsage(unitActionTableEntry.u, physicalGameState), gameState)) {
                    bl2 = false;
                    break;
                }
                playerAction.addUnitAction(unitActionTableEntry.u, unitAction);
            }
            if (!bl2) continue;
            hashSet.add(playerAction);
        }
        if (hashSet.size() == 0) {
            hashSet.add(new PlayerAction());
        }
        return hashSet;
    }

    public List<Pair<PlayerAction, Pair<Double, Integer>>> halvedSampling(List<Pair<PlayerAction, Pair<Double, Integer>>> list, GameState gameState, int n, int n2) throws Exception {
        for (Pair<PlayerAction, Pair<Double, Integer>> pair : list) {
            double d = this.evaluatePlayerAction(n, gameState, (PlayerAction)pair.m_a, n2);
            double d2 = (Double)((Pair)pair.m_b).m_a;
            int n3 = (Integer)((Pair)pair.m_b).m_b;
            ((Pair)pair.m_b).m_a = d2 + d;
            ((Pair)pair.m_b).m_b = n3 + n2;
        }
        Collections.sort(list, new Comparator<Pair<PlayerAction, Pair<Double, Integer>>>(){

            @Override
            public int compare(Pair<PlayerAction, Pair<Double, Integer>> pair, Pair<PlayerAction, Pair<Double, Integer>> pair2) {
                double d;
                double d2 = (Double)((Pair)pair.m_b).m_a / (double)((Integer)((Pair)pair.m_b).m_b).intValue();
                return d2 < (d = (Double)((Pair)pair2.m_b).m_a / (double)((Integer)((Pair)pair2.m_b).m_b).intValue()) ? 1 : (d2 > d ? -1 : 0);
            }
        });
        return list.subList(0, list.size() / 2 + 1);
    }

    public List<Pair<PlayerAction, Double>> halvedOriginalSampling(List<Pair<PlayerAction, Double>> list, GameState gameState, int n, int n2, int n3) throws Exception {
        for (Pair<PlayerAction, Double> pair : list) {
            double d = this.evaluatePlayerAction(n, gameState, (PlayerAction)pair.m_a, n2);
            pair.m_b = ((Double)pair.m_b * (double)n3 + d * (double)n2) / (double)(n3 + n2);
        }
        Collections.sort(list, new Comparator<Pair<PlayerAction, Double>>(){

            @Override
            public int compare(Pair<PlayerAction, Double> pair, Pair<PlayerAction, Double> pair2) {
                return (Double)pair.m_b < (Double)pair2.m_b ? 1 : ((Double)pair.m_b > (Double)pair2.m_b ? -1 : 0);
            }
        });
        return list.subList(0, list.size() / 2 + 1);
    }

    public List<Pair<PlayerAction, Double>> halvedOriginalSamplingFill(List<Pair<PlayerAction, Double>> list, GameState gameState, int n, int n2, int n3) throws Exception {
        for (Pair<PlayerAction, Double> pair : list) {
            double d = this.evaluatePlayerAction(n, gameState, (PlayerAction)pair.m_a, n2);
            pair.m_b = ((Double)pair.m_b * (double)n3 + d * (double)n2) / (double)(n3 + n2);
        }
        Collections.sort(list, new Comparator<Pair<PlayerAction, Double>>(){

            @Override
            public int compare(Pair<PlayerAction, Double> pair, Pair<PlayerAction, Double> pair2) {
                return (Double)pair.m_b < (Double)pair2.m_b ? 1 : ((Double)pair.m_b > (Double)pair2.m_b ? -1 : 0);
            }
        });
        return list.subList(0, list.size() / 2);
    }

    public double entropy(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        double d3 = 0.0;
        for (double d4 : dArray) {
            if (d4 == 0.0) continue;
            d3 += -1.0 * (d4 / d) * Sampling.log(d4 / d, 2.0);
        }
        return d3;
    }

    public double difference(List<UnitActionTableEntry> list, List<double[]> list2, PlayerAction playerAction, int n) {
        Pair<Unit, UnitAction> pair = playerAction.getActions().get(n);
        int n2 = 0;
        for (UnitAction unitAction : list.get((int)n).actions) {
            if (((UnitAction)pair.m_b).equals(unitAction)) break;
            ++n2;
        }
        return list2.get(n)[n2] - list2.get(n)[list2.get(n).length - 1];
    }

    public void resetSimulationCount() {
        this.simulationCount = 0;
    }

    public int getSimulationCount() {
        return this.simulationCount;
    }

    public static double log(double d, double d2) {
        return Math.log(d) / Math.log(d2);
    }

    public void increaseSimulationCount(double d) {
        this.simulationCount = (int)((double)this.simulationCount + d);
    }

    public static enum AgentOrderingType {
        RANDOM,
        ENTROPY;

    }

    public static class UnitActionTableEntry {
        public int idx;
        public Unit u;
        public int nactions = 0;
        public List<UnitAction> actions = null;
        public double[] accum_evaluation = null;
        public int[] visit_count = null;
    }
}

