/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio;

import ai.RandomBiasedAI;
import ai.abstraction.LightRush;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerRush;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class PortfolioAI
extends AIWithComputationBudget
implements InterruptibleAI {
    public static int DEBUG = 0;
    int LOOKAHEAD = 500;
    AI[] strategies = null;
    boolean[] deterministic = null;
    EvaluationFunction evaluation = null;
    GameState gs_to_start_from = null;
    double[][] scores = null;
    int[][] counts = null;
    int nplayouts = 0;
    int playerForThisComputation;

    public PortfolioAI(UnitTypeTable unitTypeTable) {
        this(new AI[]{new WorkerRush(unitTypeTable), new LightRush(unitTypeTable), new RangedRush(unitTypeTable), new RandomBiasedAI()}, new boolean[]{true, true, true, false}, 100, -1, 100, new SimpleSqrtEvaluationFunction3());
    }

    public PortfolioAI(AI[] aIArray, boolean[] blArray, int n, int n2, int n3, EvaluationFunction evaluationFunction) {
        super(n, n2);
        this.LOOKAHEAD = n3;
        this.strategies = aIArray;
        this.deterministic = blArray;
        this.evaluation = evaluationFunction;
    }

    @Override
    public void reset() {
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) {
        int n2 = this.strategies.length;
        this.scores = new double[n2][n2];
        this.counts = new int[n2][n2];
        this.playerForThisComputation = n;
        this.gs_to_start_from = gameState;
        this.nplayouts = 0;
    }

    public void resetSearch() {
        this.scores = null;
        this.counts = null;
        this.gs_to_start_from = null;
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        boolean bl;
        int n = this.strategies.length;
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        do {
            bl = false;
            for (int j = 0; j < n && !bl2; ++j) {
                for (int k = 0; k < n && !bl2; ++k) {
                    if (this.counts[j][k] == 0 || !this.deterministic[j] || !this.deterministic[k]) {
                        bl = true;
                        AI aI = this.strategies[j].clone();
                        AI aI2 = this.strategies[k].clone();
                        GameState gameState = this.gs_to_start_from.clone();
                        aI.reset();
                        aI2.reset();
                        int n2 = gameState.getTime() + this.LOOKAHEAD;
                        boolean bl3 = false;
                        while (!bl3 && gameState.getTime() < n2) {
                            if (gameState.isComplete()) {
                                bl3 = gameState.cycle();
                                continue;
                            }
                            gameState.issue(aI.getAction(this.playerForThisComputation, gameState));
                            gameState.issue(aI2.getAction(1 - this.playerForThisComputation, gameState));
                        }
                        double[] dArray = this.scores[j];
                        int n3 = k;
                        dArray[n3] = dArray[n3] + (double)this.evaluation.evaluate(this.playerForThisComputation, 1 - this.playerForThisComputation, gameState);
                        int[] nArray = this.counts[j];
                        int n4 = k;
                        nArray[n4] = nArray[n4] + 1;
                        ++this.nplayouts;
                    }
                    if (this.ITERATIONS_BUDGET > 0 && this.nplayouts >= this.ITERATIONS_BUDGET) {
                        bl2 = true;
                    }
                    if (this.TIME_BUDGET <= 0 || System.currentTimeMillis() <= l + (long)this.TIME_BUDGET) continue;
                    bl2 = true;
                }
            }
        } while (bl && !bl2);
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        int n = this.strategies.length;
        if (DEBUG >= 1) {
            int n2;
            int n3;
            System.out.println("PortfolioAI, game cycle: " + this.gs_to_start_from.getTime());
            System.out.println("  counts:");
            for (n3 = 0; n3 < n; ++n3) {
                System.out.print("    ");
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.print(this.counts[n3][n2] + "\t");
                }
                System.out.println("");
            }
            System.out.println("  scores:");
            for (n3 = 0; n3 < n; ++n3) {
                System.out.print("    ");
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.print(this.scores[n3][n2] / (double)this.counts[n3][n2] + "\t");
                }
                System.out.println("");
            }
        }
        double d = 0.0;
        int n4 = -1;
        for (int j = 0; j < n; ++j) {
            double d2 = 0.0;
            int n5 = -1;
            for (int k = 0; k < n; ++k) {
                double d3 = this.scores[j][k] / (double)this.counts[j][k];
                if (n5 != -1 && !(d3 < d2)) continue;
                n5 = k;
                d2 = d3;
            }
            if (n4 != -1 && !(d2 > d)) continue;
            n4 = j;
            d = d2;
        }
        if (DEBUG >= 1) {
            System.out.println("PortfolioAI: selected " + n4 + "  with score: " + d);
        }
        AI aI = this.strategies[n4].clone();
        aI.reset();
        return aI.getAction(this.playerForThisComputation, this.gs_to_start_from);
    }

    @Override
    public AI clone() {
        return new PortfolioAI(this.strategies, this.deterministic, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.LOOKAHEAD, this.evaluation);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.LOOKAHEAD + ", " + this.evaluation + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.LOOKAHEAD;
    }

    public void setPlayoutLookahead(int n) {
        this.LOOKAHEAD = n;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evaluation;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.evaluation = evaluationFunction;
    }
}

