/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import ai.portfolio.portfoliogreedysearch.UnitScriptAttack;
import ai.portfolio.portfoliogreedysearch.UnitScriptBuild;
import ai.portfolio.portfoliogreedysearch.UnitScriptHarvest;
import ai.portfolio.portfoliogreedysearch.UnitScriptIdle;
import ai.portfolio.portfoliogreedysearch.UnitScriptTrain;
import ai.portfolio.portfoliogreedysearch.UnitScriptsAI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class PGSAI
extends AIWithComputationBudget {
    public static int DEBUG = 0;
    int LOOKAHEAD = 500;
    int I = 1;
    int R = 1;
    EvaluationFunction evaluation = null;
    HashMap<UnitType, List<UnitScript>> scripts = null;
    UnitTypeTable utt;
    PathFinding pf;
    UnitScript defaultScript = null;
    long start_time = 0L;
    int nplayouts = 0;

    public PGSAI(UnitTypeTable unitTypeTable) {
        this(100, -1, 100, 1, 1, new SimpleSqrtEvaluationFunction3(), unitTypeTable, new AStarPathFinding());
    }

    public PGSAI(int n, int n2, int n3, int n4, int n5, EvaluationFunction evaluationFunction, UnitTypeTable unitTypeTable, PathFinding pathFinding) {
        super(n, n2);
        this.LOOKAHEAD = n3;
        this.I = n4;
        this.R = n5;
        this.evaluation = evaluationFunction;
        this.utt = unitTypeTable;
        this.pf = pathFinding;
        UnitScriptHarvest unitScriptHarvest = new UnitScriptHarvest(this.pf, this.utt);
        UnitScriptBuild unitScriptBuild = new UnitScriptBuild(this.pf, this.utt.getUnitType("Barracks"));
        UnitScriptBuild unitScriptBuild2 = new UnitScriptBuild(this.pf, this.utt.getUnitType("Base"));
        UnitScriptAttack unitScriptAttack = new UnitScriptAttack(this.pf);
        UnitScriptIdle unitScriptIdle = new UnitScriptIdle();
        UnitScriptTrain unitScriptTrain = new UnitScriptTrain(this.utt.getUnitType("Worker"));
        UnitScriptTrain unitScriptTrain2 = new UnitScriptTrain(this.utt.getUnitType("Light"));
        UnitScriptTrain unitScriptTrain3 = new UnitScriptTrain(this.utt.getUnitType("Heavy"));
        UnitScriptTrain unitScriptTrain4 = new UnitScriptTrain(this.utt.getUnitType("Ranged"));
        this.defaultScript = unitScriptIdle;
        this.scripts = new HashMap();
        ArrayList<UnitScript> arrayList = new ArrayList<UnitScript>();
        arrayList.add(unitScriptHarvest);
        arrayList.add(unitScriptBuild);
        arrayList.add(unitScriptBuild2);
        arrayList.add(unitScriptAttack);
        arrayList.add(unitScriptIdle);
        this.scripts.put(this.utt.getUnitType("Worker"), arrayList);
        arrayList = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Base"), arrayList);
        arrayList.add(unitScriptTrain);
        arrayList.add(unitScriptIdle);
        arrayList = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Barracks"), arrayList);
        arrayList.add(unitScriptTrain2);
        arrayList.add(unitScriptTrain3);
        arrayList.add(unitScriptTrain4);
        arrayList.add(unitScriptIdle);
        arrayList = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Light"), arrayList);
        arrayList.add(unitScriptAttack);
        arrayList.add(unitScriptIdle);
        arrayList = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Heavy"), arrayList);
        arrayList.add(unitScriptAttack);
        arrayList.add(unitScriptIdle);
        arrayList = new ArrayList();
        this.scripts.put(this.utt.getUnitType("Ranged"), arrayList);
        arrayList.add(unitScriptAttack);
        arrayList.add(unitScriptIdle);
    }

    @Override
    public void reset() {
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        int n2;
        if (gameState.winner() != -1) {
            return new PlayerAction();
        }
        if (!gameState.canExecuteAnyAction(n)) {
            return new PlayerAction();
        }
        if (DEBUG >= 1) {
            System.out.println("PGSAI " + n + "(MAX_TIME = " + this.TIME_BUDGET + ", I: " + this.I + ", R: " + this.R + ")");
        }
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        ArrayList<Unit> arrayList2 = new ArrayList<Unit>();
        for (Unit unit : gameState.getUnits()) {
            if (unit.getPlayer() == n) {
                arrayList.add(unit);
                continue;
            }
            if (unit.getPlayer() < 0) continue;
            arrayList2.add(unit);
        }
        int n3 = arrayList.size();
        int n4 = arrayList2.size();
        UnitScript[] unitScriptArray = new UnitScript[n3];
        UnitScript[] unitScriptArray2 = new UnitScript[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            unitScriptArray[n2] = this.defaultScript((Unit)arrayList.get(n2), gameState);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            unitScriptArray2[n2] = this.defaultScript((Unit)arrayList2.get(n2), gameState);
        }
        this.start_time = System.currentTimeMillis();
        this.nplayouts = 0;
        this.improve(n, unitScriptArray, arrayList, unitScriptArray2, arrayList2, gameState);
        for (n2 = 0; n2 < this.R; ++n2) {
            this.improve(1 - n, unitScriptArray2, arrayList2, unitScriptArray, arrayList, gameState);
            this.improve(n, unitScriptArray, arrayList, unitScriptArray2, arrayList2, gameState);
        }
        PlayerAction playerAction = new PlayerAction();
        for (int j = 0; j < n3; ++j) {
            Unit unit = (Unit)arrayList.get(j);
            if (gameState.getUnitAction(unit) != null) continue;
            UnitScript unitScript = unitScriptArray[j].instantiate(unit, gameState);
            if (unitScript != null) {
                UnitAction unitAction = unitScript.getAction(unit, gameState);
                if (unitAction != null) {
                    playerAction.addUnitAction(unit, unitAction);
                    continue;
                }
                playerAction.addUnitAction(unit, new UnitAction(0));
                continue;
            }
            playerAction.addUnitAction(unit, new UnitAction(0));
        }
        return playerAction;
    }

    public UnitScript defaultScript(Unit unit, GameState gameState) {
        List<UnitScript> list = this.scripts.get(unit.getType());
        return list.get(0).instantiate(unit, gameState);
    }

    public void improve(int n, UnitScript[] unitScriptArray, List<Unit> list, UnitScript[] unitScriptArray2, List<Unit> list2, GameState gameState) throws Exception {
        for (int j = 0; j < this.I; ++j) {
            if (DEBUG >= 1) {
                System.out.println("Improve player " + n + "(" + j + "/" + this.I + ")");
            }
            for (int k = 0; k < unitScriptArray.length; ++k) {
                if (this.ITERATIONS_BUDGET > 0 && this.nplayouts >= this.ITERATIONS_BUDGET) {
                    if (DEBUG >= 1) {
                        System.out.println("nplayouts>=MAX_PLAYOUTS");
                    }
                    return;
                }
                if (this.TIME_BUDGET > 0 && System.currentTimeMillis() >= this.start_time + (long)this.TIME_BUDGET) {
                    if (DEBUG >= 1) {
                        System.out.println("Time out!");
                    }
                    return;
                }
                Unit unit = list.get(k);
                double d = 0.0;
                UnitScript unitScript = null;
                List<UnitScript> list3 = this.scripts.get(unit.getType());
                for (UnitScript unitScript2 : list3) {
                    UnitScript unitScript3 = unitScript2.instantiate(unit, gameState);
                    if (unitScript3 == null) continue;
                    if (DEBUG >= 2) {
                        System.out.println("  " + unit + " -> " + unitScript3.getClass().toString());
                    }
                    unitScriptArray[k] = unitScript3;
                    double d2 = this.playout(n, unitScriptArray, list, unitScriptArray2, list2, gameState);
                    if (unitScript != null && !(d2 > d)) continue;
                    unitScript = unitScript2;
                    d = d2;
                    if (DEBUG < 2) continue;
                    System.out.println("    new best: " + d2);
                }
                unitScriptArray[k] = unitScript;
            }
        }
    }

    public double playout(int n, UnitScript[] unitScriptArray, List<Unit> list, UnitScript[] unitScriptArray2, List<Unit> list2, GameState gameState) throws Exception {
        ++this.nplayouts;
        UnitScriptsAI unitScriptsAI = new UnitScriptsAI(unitScriptArray, list, this.scripts, this.defaultScript);
        UnitScriptsAI unitScriptsAI2 = new UnitScriptsAI(unitScriptArray2, list2, this.scripts, this.defaultScript);
        GameState gameState2 = gameState.clone();
        ((AI)unitScriptsAI).reset();
        ((AI)unitScriptsAI2).reset();
        int n2 = gameState2.getTime() + this.LOOKAHEAD;
        boolean bl = false;
        while (!bl && gameState2.getTime() < n2) {
            if (gameState2.isComplete()) {
                bl = gameState2.cycle();
                continue;
            }
            gameState2.issue(((AI)unitScriptsAI).getAction(n, gameState2));
            gameState2.issue(((AI)unitScriptsAI2).getAction(1 - n, gameState2));
        }
        double d = this.evaluation.evaluate(n, 1 - n, gameState2);
        return d;
    }

    @Override
    public AI clone() {
        return new PGSAI(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.LOOKAHEAD, this.I, this.R, this.evaluation, this.utt, this.pf);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.LOOKAHEAD + ", " + this.I + ", " + this.R + ", " + this.evaluation + ", " + this.pf + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("I", Integer.TYPE, 1));
        arrayList.add(new ParameterSpecification("R", Integer.TYPE, 1));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return arrayList;
    }

    public int getPlayoutLookahead() {
        return this.LOOKAHEAD;
    }

    public void setPlayoutLookahead(int n) {
        this.LOOKAHEAD = n;
    }

    public int getI() {
        return this.I;
    }

    public void setI(int n) {
        this.I = n;
    }

    public int getR() {
        return this.R;
    }

    public void setR(int n) {
        this.R = n;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evaluation;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.evaluation = evaluationFunction;
    }

    public PathFinding getPathFinding() {
        return this.pf;
    }

    public void setPathFinding(PathFinding pathFinding) {
        this.pf = pathFinding;
    }
}

