/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.abstraction.AbstractAction;
import ai.abstraction.Build;
import ai.abstraction.pathfinding.PathFinding;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import rts.GameState;
import rts.PhysicalGameState;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;

public class UnitScriptBuild
extends UnitScript {
    AbstractAction action = null;
    PathFinding pf = null;
    UnitType ut = null;

    public UnitScriptBuild(PathFinding pathFinding, UnitType unitType) {
        this.pf = pathFinding;
        this.ut = unitType;
    }

    @Override
    public UnitAction getAction(Unit unit, GameState gameState) {
        if (this.action.completed(gameState)) {
            return null;
        }
        return this.action.execute(gameState);
    }

    @Override
    public UnitScript instantiate(Unit unit, GameState gameState) {
        int n = this.findBuildingPosition(unit, gameState.getPhysicalGameState());
        if (n != -1) {
            UnitScriptBuild unitScriptBuild = new UnitScriptBuild(this.pf, this.ut);
            unitScriptBuild.action = new Build(unit, this.ut, n % gameState.getPhysicalGameState().getWidth(), n / gameState.getPhysicalGameState().getWidth(), this.pf);
            return unitScriptBuild;
        }
        return null;
    }

    public int findBuildingPosition(Unit unit, PhysicalGameState physicalGameState) {
        int n = -1;
        int n2 = 0;
        for (int j = 0; j < physicalGameState.getWidth(); ++j) {
            for (int k = 0; k < physicalGameState.getHeight(); ++k) {
                int n3 = j + k * physicalGameState.getWidth();
                if (physicalGameState.getUnitAt(j, k) != null) continue;
                int n4 = 0;
                n4 = -(Math.abs(unit.getX() - j) + Math.abs(unit.getY() - k));
                if (n != -1 && n4 <= n2) continue;
                n = n3;
                n2 = n4;
            }
        }
        return n;
    }
}

