/*
 * Decompiled with CFR 0.152.
 */
package ai.portfolio.portfoliogreedysearch;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.portfolio.portfoliogreedysearch.UnitScript;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;

public class UnitScriptsAI
extends AI {
    public static int DEBUG = 0;
    UnitScript[] scriptsInput;
    List<Unit> unitsInput;
    HashMap<Unit, UnitScript> scripts = new HashMap();
    HashMap<UnitType, List<UnitScript>> allScripts = null;
    UnitScript defaultScript = null;

    public UnitScriptsAI(UnitScript[] unitScriptArray, List<Unit> list, HashMap<UnitType, List<UnitScript>> hashMap, UnitScript unitScript) {
        this.scriptsInput = unitScriptArray;
        this.unitsInput = list;
        for (int j = 0; j < unitScriptArray.length; ++j) {
            this.scripts.put(list.get(j), unitScriptArray[j]);
        }
        this.allScripts = hashMap;
        this.defaultScript = unitScript;
    }

    @Override
    public void reset() {
    }

    public void resetScripts(GameState gameState) {
        for (Unit unit : this.scripts.keySet()) {
            UnitScript unitScript = this.scripts.get(unit);
            this.scripts.put(unit, unitScript.instantiate(unit, gameState));
        }
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        PlayerAction playerAction = new PlayerAction();
        for (Unit unit : gameState.getUnits()) {
            UnitAction unitAction;
            if (unit.getPlayer() != n || gameState.getUnitAction(unit) != null) continue;
            UnitScript unitScript = this.scripts.get(unit);
            if (unitScript != null) {
                unitScript = unitScript.instantiate(unit, gameState);
            }
            if (unitScript == null) {
                unitScript = this.allScripts.get(unit.getType()).get(0).instantiate(unit, gameState);
                if (unitScript == null) {
                    unitScript = this.defaultScript.instantiate(unit, gameState);
                }
                this.scripts.put(unit, unitScript);
            }
            if ((unitAction = unitScript.getAction(unit, gameState)) != null) {
                playerAction.addUnitAction(unit, unitAction);
                continue;
            }
            playerAction.addUnitAction(unit, new UnitAction(0));
        }
        return playerAction;
    }

    @Override
    public AI clone() {
        return new UnitScriptsAI(this.scriptsInput, this.unitsInput, this.allScripts, this.defaultScript);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("Scripts", List.class, this.scriptsInput));
        arrayList.add(new ParameterSpecification("Units", List.class, this.unitsInput));
        arrayList.add(new ParameterSpecification("AllScripts", HashMap.class, this.allScripts));
        arrayList.add(new ParameterSpecification("DefaultScript", UnitScript.class, this.defaultScript));
        return arrayList;
    }
}

