/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.ParameterSpecification;
import ai.puppet.BasicChoicePoint;
import ai.puppet.ConfigurableScript;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class BasicConfigurableScript
extends ConfigurableScript<BasicChoicePoint> {
    Random r = new Random();
    UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType lightType;
    UnitType heavyType;
    UnitType rangedType;
    UnitType resourceType;
    int resourcesUsed;
    int nbases;
    int nbarracks;
    int nresources;
    int ownresources;
    int abandonedbases;
    int freeresources;
    int nworkers;
    private static final int BASE_RESOURCE_RADIUS = 8;

    public BasicConfigurableScript(UnitTypeTable unitTypeTable) {
        this(unitTypeTable, new FloodFillPathFinding());
    }

    public BasicConfigurableScript(UnitTypeTable unitTypeTable, PathFinding pathFinding) {
        super(pathFinding);
        this.utt = unitTypeTable;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.lightType = this.utt.getUnitType("Light");
        this.heavyType = this.utt.getUnitType("Heavy");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.resourceType = this.utt.getUnitType("Resource");
        this.choicePoints = new EnumMap(BasicChoicePoint.class);
        this.choices = new EnumMap(BasicChoicePoint.class);
        this.choicePointValues = BasicChoicePoint.values();
        this.reset();
    }

    @Override
    public ConfigurableScript<BasicChoicePoint> clone() {
        BasicConfigurableScript basicConfigurableScript = new BasicConfigurableScript(this.utt, this.pf);
        basicConfigurableScript.choices = this.choices.clone();
        basicConfigurableScript.choicePoints = this.choicePoints.clone();
        basicConfigurableScript.choicePointValues = (Enum[])((BasicChoicePoint[])this.choicePointValues).clone();
        return basicConfigurableScript;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = gameState.getPlayer(n);
        this.resourcesUsed = gameState.getResourceUsage().getResourcesUsed(n);
        this.nworkers = 0;
        this.nbases = 0;
        this.nbarracks = 0;
        this.nresources = 0;
        this.ownresources = 0;
        this.abandonedbases = 0;
        this.freeresources = 0;
        for (Unit object : physicalGameState.getUnits()) {
            if (object.getType() != this.workerType || object.getPlayer() != player.getID()) continue;
            ++this.nworkers;
        }
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType() == this.baseType && unit2.getPlayer() == player.getID()) {
                ++this.nbases;
                if (!physicalGameState.getUnitsAround(unit2.getX(), unit2.getY(), 8).stream().map(unit -> unit.getType() == this.resourceType).reduce((bl, bl2) -> bl != false || bl2 != false).get().booleanValue()) {
                    ++this.abandonedbases;
                }
            }
            if (unit2.getType() == this.barracksType && unit2.getPlayer() == player.getID()) {
                ++this.nbarracks;
            }
            if (unit2.getType() != this.resourceType) continue;
            ++this.nresources;
            if (physicalGameState.getUnitsAround(unit2.getX(), unit2.getY(), 8).stream().map(unit -> unit.getPlayer() == player.getID() && unit.getType() == this.baseType).reduce((bl, bl2) -> bl != false || bl2 != false).get().booleanValue()) {
                ++this.ownresources;
            }
            if (physicalGameState.getUnitsAround(unit2.getX(), unit2.getY(), 8).stream().map(unit -> unit.getPlayer() != 1 - player.getID() && unit.getType() != this.baseType).reduce((bl, bl2) -> bl != false && bl2 != false).get().booleanValue()) continue;
            ++this.freeresources;
        }
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getType() != this.baseType || unit3.getPlayer() != n || gameState.getActionAssignment(unit3) != null) continue;
            this.baseBehavior(unit3, player, physicalGameState);
        }
        for (Unit unit4 : physicalGameState.getUnits()) {
            if (!unit4.getType().canAttack || unit4.getType().canHarvest || unit4.getPlayer() != n || gameState.getActionAssignment(unit4) != null) continue;
            this.meleeUnitBehavior(unit4, player, gameState);
        }
        LinkedList linkedList = new LinkedList();
        for (Unit unit5 : physicalGameState.getUnits()) {
            if (!unit5.getType().canHarvest || unit5.getPlayer() != n) continue;
            linkedList.add(unit5);
        }
        this.workersBehavior(linkedList, player, gameState);
        for (Unit unit5 : physicalGameState.getUnits()) {
            if (unit5.getType() != this.barracksType || unit5.getPlayer() != n || gameState.getActionAssignment(unit5) != null) continue;
            this.barracksBehavior(unit5, player, physicalGameState);
        }
        return this.translateActions(n, gameState);
    }

    public void baseBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        if ((Integer)this.choices.get((Object)BasicChoicePoint.UNITTYPE) == this.workerType.ID && player.getResources() >= this.workerType.cost + this.resourcesUsed) {
            this.train(unit, this.workerType);
            this.resourcesUsed += this.workerType.cost;
        }
    }

    public void barracksBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        UnitType unitType = this.utt.getUnitType((Integer)this.choices.get((Object)BasicChoicePoint.UNITTYPE));
        if (!unitType.canHarvest && player.getResources() >= unitType.cost + this.resourcesUsed) {
            this.train(unit, unitType);
            this.resourcesUsed += unitType.cost;
        }
    }

    public int manDist(Unit unit, Unit unit2) {
        return Math.abs(unit2.getX() - unit.getX()) + Math.abs(unit2.getY() - unit.getY());
    }

    public void meleeUnitBehavior(Unit unit, Player player, GameState gameState) {
        int n;
        Unit unit2 = null;
        int n2 = 0;
        for (Unit unit3 : gameState.getPhysicalGameState().getUnits()) {
            if (unit3.getPlayer() < 0 || unit3.getPlayer() == player.getID()) continue;
            n = this.manDist(unit, unit3);
            if (unit2 != null && n >= n2) continue;
            unit2 = unit3;
            n2 = n;
        }
        if (unit2 != null) {
            if (unit2.getAttackRange() < unit.getAttackRange() && this.sqDist(unit, unit2) <= unit2.getAttackRange() * unit2.getAttackRange()) {
                int n3 = unit.getX() - unit2.getX();
                int n4 = unit.getY() - unit2.getY();
                n = unit.getX();
                int n5 = unit.getY();
                if (Math.abs(n3) > Math.abs(n4)) {
                    if (n3 > 0 && n < gameState.getPhysicalGameState().getWidth() - 1) {
                        n = unit.getX() + 1;
                    } else if (n3 < 0 && n > 0) {
                        n = unit.getX() - 1;
                    }
                } else if (n4 > 0 && n5 < gameState.getPhysicalGameState().getHeight() - 1) {
                    n5 = unit.getY() + 1;
                } else if (n4 < 0 && n5 > 0) {
                    n5 = unit.getY() - 1;
                }
                if (gameState.free(n, n5)) {
                    this.move(unit, n, n5);
                } else {
                    this.attack(unit, unit2);
                }
            } else {
                this.attack(unit, unit2);
            }
        }
    }

    public int sqDist(Unit unit, Unit unit2) {
        int n = Math.abs(unit.getX() - unit2.getX());
        int n2 = Math.abs(unit.getY() - unit2.getY());
        return n * n + n2 * n2;
    }

    public void workersBehavior(List<Unit> list, Player player, GameState gameState) {
        Object object;
        Serializable serializable;
        Object object2;
        Serializable serializable22;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        if (list.isEmpty()) {
            return;
        }
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        for (Serializable serializable22 : physicalGameState.getUnits()) {
            if (serializable22.getType() != this.baseType || serializable22.getPlayer() != player.getID()) continue;
            linkedList.add((Unit)serializable22);
        }
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(list);
        serializable22 = new LinkedList();
        if (this.nbases == 0 && !linkedList2.isEmpty() && player.getResources() >= this.baseType.cost + this.resourcesUsed) {
            object2 = (Unit)linkedList2.remove(0);
            this.buildIfNotAlreadyBuilding((Unit)object2, this.baseType, ((Unit)object2).getX(), ((Unit)object2).getY(), (List<Integer>)((Object)serializable22), player, physicalGameState);
            this.resourcesUsed += this.baseType.cost;
        }
        if (this.nbarracks < this.nbases - this.abandonedbases && !this.utt.getUnitType((int)((Integer)this.choices.get((Object)((Object)BasicChoicePoint.UNITTYPE))).intValue()).canHarvest && player.getResources() >= this.barracksType.cost + this.resourcesUsed && !linkedList2.isEmpty()) {
            object2 = (Unit)linkedList2.remove(0);
            serializable = (Unit)linkedList.get(this.nbarracks);
            this.buildIfNotAlreadyBuilding((Unit)object2, this.barracksType, ((Unit)serializable).getX(), ((Unit)serializable).getY(), (List<Integer>)((Object)serializable22), player, physicalGameState);
            this.resourcesUsed += this.barracksType.cost;
        }
        if ((Integer)this.choices.get((Object)BasicChoicePoint.EXPAND) > 0 && this.nbarracks >= 1 && this.nbases - this.abandonedbases <= 1 && this.freeresources > 0 && !linkedList2.isEmpty()) {
            if (player.getResources() >= this.baseType.cost + this.resourcesUsed) {
                object2 = (Unit)linkedList2.remove(0);
                serializable = new LinkedList();
                for (Unit unit : physicalGameState.getUnits()) {
                    if (unit.getType() != this.resourceType) continue;
                    serializable.add(unit);
                }
                object = this.findClosest((Unit)object2, (Unit unit2) -> unit2.getType() == this.resourceType && physicalGameState.getUnitsAround(unit2.getX(), unit2.getY(), 10).stream().map(unit -> unit.getPlayer() != 1 - player.getID() && unit.getType() != this.baseType).reduce((bl, bl2) -> bl != false && bl2 != false).get() != false, physicalGameState);
                if (object != null) {
                    this.buildIfNotAlreadyBuilding((Unit)object2, this.baseType, ((Unit)object).getX(), ((Unit)object).getY(), (List<Integer>)((Object)serializable22), player, physicalGameState);
                }
                this.resourcesUsed += this.baseType.cost;
            } else {
                this.resourcesUsed += this.baseType.cost;
            }
        }
        while ((Integer)this.choices.get((Object)BasicChoicePoint.UNITTYPE) == this.workerType.ID && linkedList2.size() > 1) {
            this.meleeUnitBehavior((Unit)linkedList2.remove(0), player, gameState);
        }
        object2 = linkedList2.iterator();
        while (object2.hasNext()) {
            int n;
            Unit unit;
            serializable = (Unit)object2.next();
            object = null;
            unit = null;
            int n2 = 0;
            for (Unit unit3 : physicalGameState.getUnits()) {
                if (!unit3.getType().isResource) continue;
                n = Math.abs(unit3.getX() - ((Unit)serializable).getX()) + Math.abs(unit3.getY() - ((Unit)serializable).getY());
                if (unit != null && n >= n2) continue;
                unit = unit3;
                n2 = n;
            }
            n2 = 0;
            for (Unit unit3 : physicalGameState.getUnits()) {
                if (!unit3.getType().isStockpile || unit3.getPlayer() != player.getID()) continue;
                n = Math.abs(unit3.getX() - ((Unit)serializable).getX()) + Math.abs(unit3.getY() - ((Unit)serializable).getY());
                if (object != null && n >= n2) continue;
                object = unit3;
                n2 = n;
            }
            if (unit == null || object == null) continue;
            this.harvest((Unit)serializable, unit, (Unit)object);
        }
    }

    public Unit findClosest(Unit unit, Predicate<Unit> predicate, PhysicalGameState physicalGameState) {
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (!predicate.test(unit3)) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        return unit2;
    }

    public Unit findClosest(Unit unit, UnitType unitType, PhysicalGameState physicalGameState) {
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getType() != unitType) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        return unit2;
    }

    public Unit findSecondClosest(Unit unit, UnitType unitType, PhysicalGameState physicalGameState) {
        return this.findClosest(unit, unitType, this.findClosest(unit, unitType, physicalGameState), physicalGameState);
    }

    public Unit findClosest(Unit unit, UnitType unitType, Unit unit2, PhysicalGameState physicalGameState) {
        Unit unit3 = null;
        int n = 0;
        for (Unit unit4 : physicalGameState.getUnits()) {
            if (unit4.getType() != unitType || unit4.getID() == unit2.getID()) continue;
            int n2 = Math.abs(unit4.getX() - unit.getX()) + Math.abs(unit4.getY() - unit.getY());
            if (unit3 != null && n2 >= n) continue;
            unit3 = unit4;
            n = n2;
        }
        return unit3;
    }

    public Unit findClosest(Unit unit, UnitType unitType, Player player, PhysicalGameState physicalGameState) {
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getType() != unitType || unit3.getPlayer() != player.getID()) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        return unit2;
    }

    public Unit findClosest(Unit unit, Player player, PhysicalGameState physicalGameState) {
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() != player.getID()) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        return unit2;
    }

    @Override
    public Collection<ConfigurableScript.Options> getApplicableChoicePoints(int n, GameState gameState) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (Unit unit2 : gameState.getPhysicalGameState().getUnits()) {
            if (unit2.getPlayer() == n) {
                if (unit2.getType() == this.workerType) {
                    ++n2;
                }
                if (unit2.getType() == this.barracksType) {
                    ++n3;
                }
                if (unit2.getType() == this.baseType) {
                    ++n4;
                    if (!gameState.getPhysicalGameState().getUnitsAround(unit2.getX(), unit2.getY(), 8).stream().map(unit -> unit.getType() == this.resourceType).reduce((bl, bl2) -> bl != false || bl2 != false).get().booleanValue()) {
                        ++n5;
                    }
                }
            }
            if (unit2.getType() != this.resourceType) continue;
            ++n7;
            if (gameState.getPhysicalGameState().getUnitsAround(unit2.getX(), unit2.getY(), 8).stream().map(unit -> unit.getPlayer() == n && unit.getType() == this.baseType).reduce((bl, bl2) -> bl != false || bl2 != false).get().booleanValue()) {
                ++n6;
            }
            if (gameState.getPhysicalGameState().getUnitsAround(unit2.getX(), unit2.getY(), 8).stream().map(unit -> unit.getType() == this.baseType).reduce((bl, bl2) -> bl != false || bl2 != false).get().booleanValue()) continue;
            ++n8;
        }
        ArrayList arrayList = new ArrayList();
        if (n3 > 0) {
            arrayList.add(new ConfigurableScript.Options(BasicChoicePoint.UNITTYPE.ordinal(), new int[]{this.lightType.ID, this.rangedType.ID, this.heavyType.ID}));
        } else {
            arrayList.add(new ConfigurableScript.Options(BasicChoicePoint.UNITTYPE.ordinal(), new int[]{this.workerType.ID, this.lightType.ID, this.rangedType.ID, this.heavyType.ID}));
        }
        if (n3 < 1 || n4 - n5 > 1 || n8 == 0) {
            arrayList.add(new ConfigurableScript.Options(BasicChoicePoint.EXPAND.ordinal(), new int[]{0}));
        } else if (n6 == 0) {
            arrayList.add(new ConfigurableScript.Options(BasicChoicePoint.EXPAND.ordinal(), new int[]{1}));
        } else {
            arrayList.add(new ConfigurableScript.Options(BasicChoicePoint.EXPAND.ordinal(), new int[]{0, 1}));
        }
        return arrayList;
    }

    @Override
    public void initializeChoices() {
        block4: for (BasicChoicePoint basicChoicePoint : (BasicChoicePoint[])this.choicePointValues) {
            switch (basicChoicePoint) {
                case UNITTYPE: {
                    this.choicePoints.put(basicChoicePoint, new ConfigurableScript.Options(basicChoicePoint.ordinal(), new int[]{this.lightType.ID, this.workerType.ID, this.rangedType.ID, this.heavyType.ID}));
                    continue block4;
                }
                case EXPAND: {
                    this.choicePoints.put(basicChoicePoint, new ConfigurableScript.Options(basicChoicePoint.ordinal(), new int[]{0, 1}));
                }
            }
        }
    }

    @Override
    public String toString() {
        String string = this.getClass().getSimpleName() + "(";
        for (BasicChoicePoint basicChoicePoint : BasicChoicePoint.values()) {
            string = string + basicChoicePoint.toString() + ",";
        }
        return string + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new FloodFillPathFinding()));
        return arrayList;
    }
}

