/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.pathfinding.PathFinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import rts.GameState;
import util.Pair;

public abstract class ConfigurableScript<T extends Enum<T>>
extends AbstractionLayerAI {
    protected T[] choicePointValues;
    protected EnumMap<T, Options> choicePoints;
    protected EnumMap<T, Integer> choices;

    public ConfigurableScript(PathFinding pathFinding) {
        super(pathFinding);
    }

    @Override
    public void reset() {
        this.initializeChoices();
        this.setDefaultChoices();
    }

    public Collection<Options> getAllChoicePoints() {
        return this.choicePoints.values();
    }

    public void setChoices(Collection<Pair<Integer, Integer>> collection) {
        for (Pair<Integer, Integer> pair : collection) {
            this.choices.put(this.choicePointValues[(Integer)pair.m_a], (Integer)pair.m_b);
        }
    }

    public void setDefaultChoices() {
        for (T t : this.choicePointValues) {
            this.choices.put(t, this.choicePoints.get(t).getOption(0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<ArrayList<Pair<Integer, Integer>>> getChoiceCombinations(int n, GameState gameState) {
        void var7_12;
        int n3;
        Collection<Options> collection = this.getApplicableChoicePoints(n, gameState);
        int[] nArray = new int[collection.size() + 1];
        for (n3 = 0; n3 < collection.size(); ++n3) {
            nArray[n3] = 1;
            int n4 = 0;
            for (Options options : collection) {
                if (n4++ < n3) continue;
                int n2 = n3;
                nArray[n2] = nArray[n2] * options.numOptions();
            }
        }
        nArray[collection.size()] = 1;
        n3 = 1;
        for (Options options : collection) {
            n3 *= options.numOptions();
        }
        ArrayList arrayList = new ArrayList(n3);
        boolean bl = false;
        while (var7_12 < n3) {
            arrayList.add(new ArrayList(collection.size()));
            ++var7_12;
        }
        boolean bl2 = false;
        for (Options options : collection) {
            void var7_14;
            for (int j = 0; j < options.numOptions(); ++j) {
                for (int k = 0; k < nArray[var7_14 + true]; ++k) {
                    int n4 = n3 / nArray[var7_14];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        ((ArrayList)arrayList.get(i2 * nArray[var7_14] + j * nArray[var7_14 + true] + k)).add(new Pair<Integer, Integer>((int)var7_14, options.getOption(j)));
                    }
                }
            }
            ++var7_14;
        }
        return arrayList;
    }

    @Override
    public abstract ConfigurableScript<T> clone();

    public abstract Collection<Options> getApplicableChoicePoints(int var1, GameState var2);

    public abstract void initializeChoices();

    class Options {
        int id;
        int[] options;

        public Options(int n, int[] nArray) {
            this.id = n;
            this.options = nArray;
        }

        public int numOptions() {
            return this.options.length;
        }

        public int getOption(int n) {
            return this.options[n];
        }

        public Options clone() {
            return new Options(this.id, this.options);
        }

        public String toString() {
            return "(" + this.id + ",[" + this.options + "])";
        }
    }
}

