/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.evaluation.EvaluationFunction;
import ai.puppet.ConfigurableScript;
import rts.GameState;
import rts.PlayerAction;

public abstract class PuppetBase
extends AIWithComputationBudget {
    int PLAN_TIME;
    int PLAN_PLAYOUTS;
    int STEP_PLAYOUT_TIME;
    boolean PLAN;
    EvaluationFunction eval;
    ConfigurableScript<?> script;
    int lastSearchFrame;
    long lastSearchTime;
    int frameLeaves = 0;
    int totalLeaves = 0;
    long frameStartTime = 0L;
    long frameTime = 0L;
    long totalTime = 0L;

    PuppetBase(int n, int n2, int n3, int n4, int n5, ConfigurableScript<?> configurableScript, EvaluationFunction evaluationFunction) {
        super(n, n2);
        assert (n >= 0 || n2 >= 0);
        this.PLAN_TIME = n3;
        this.PLAN_PLAYOUTS = n4;
        this.STEP_PLAYOUT_TIME = n5;
        this.PLAN = n3 >= 0 || n4 >= 0;
        this.script = configurableScript;
        this.eval = evaluationFunction;
        this.lastSearchFrame = -1;
        this.lastSearchTime = -1L;
    }

    @Override
    public void reset() {
        this.lastSearchFrame = -1;
        this.lastSearchTime = -1L;
        this.script.reset();
        this.frameLeaves = 0;
        this.totalLeaves = 0;
        this.frameTime = 0L;
        this.totalTime = 0L;
    }

    boolean planBudgetExpired() {
        return this.PLAN_PLAYOUTS >= 0 && this.totalLeaves >= this.PLAN_PLAYOUTS || this.PLAN_TIME >= 0 && this.totalTime > (long)this.PLAN_TIME;
    }

    boolean frameBudgetExpired() {
        return this.ITERATIONS_BUDGET >= 0 && this.frameLeaves >= this.ITERATIONS_BUDGET || this.TIME_BUDGET >= 0 && this.frameTime > (long)this.TIME_BUDGET;
    }

    abstract void startNewComputation(int var1, GameState var2) throws Exception;

    abstract void computeDuringOneGameFrame() throws Exception;

    abstract PlayerAction getBestActionSoFar() throws Exception;

    static void simulate(GameState gameState, AI aI, AI aI2, int n, int n2, int n3) throws Exception {
        assert (n != n2);
        int n4 = gameState.getTime() + n3;
        boolean bl = gameState.gameover();
        while (!bl && gameState.getTime() < n4) {
            if (gameState.isComplete()) {
                bl = gameState.cycle();
                continue;
            }
            gameState.issue(aI.getAction(n, gameState));
            gameState.issue(aI2.getAction(n2, gameState));
        }
    }

    public int getPlanTimeBudget() {
        return this.PLAN_TIME;
    }

    public void setPlanTimeBudget(int n) {
        this.PLAN_TIME = n;
    }

    public int getPlanIterationsBudget() {
        return this.PLAN_PLAYOUTS;
    }

    public void setPlanIterationsBudget(int n) {
        this.PLAN_PLAYOUTS = n;
    }
}

