/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.puppet.Move;
import java.util.Random;
import rts.GameState;
import util.Pair;

class PuppetGameState {
    GameState gs;
    int hash;
    static final int MAX_DEPTH = 100;
    static final int MAX_CHOICE_POINTS = 10;
    static final int MAX_CHOICES = 10;
    static int[][][][] zobrist = new int[100][2][10][10];

    public PuppetGameState(GameState gameState) {
        this.gs = gameState.clone();
        Random random = new Random();
        this.hash = random.nextInt(Integer.MAX_VALUE);
    }

    public PuppetGameState(PuppetGameState puppetGameState) {
        this.gs = puppetGameState.gs;
        this.hash = puppetGameState.hash;
    }

    public PuppetGameState(PuppetGameState puppetGameState, GameState gameState, int n, Move move, Move move2) {
        this.gs = gameState;
        this.hash = puppetGameState.hash;
        this.hash = this.getHash(n, move, move2);
    }

    int getHash(int n, Move move, Move move2) {
        int n2 = this.hash;
        for (Pair<Integer, Integer> pair : move.choices) {
            n2 ^= zobrist[n][0][(Integer)pair.m_a][(Integer)pair.m_b];
        }
        for (Pair<Integer, Integer> pair : move2.choices) {
            n2 ^= zobrist[n + 1][1][(Integer)pair.m_a][(Integer)pair.m_b];
        }
        return n2;
    }

    int getHash(int n, Move move) {
        int n2 = this.hash;
        for (Pair<Integer, Integer> pair : move.choices) {
            n2 ^= zobrist[n][0][(Integer)pair.m_a][(Integer)pair.m_b];
        }
        return n2;
    }

    int getHash() {
        return this.hash;
    }

    static {
        Random random = new Random();
        for (int j = 0; j < 100; ++j) {
            for (int k = 0; k < 2; ++k) {
                for (int i2 = 0; i2 < 10; ++i2) {
                    for (int i3 = 0; i3 < 10; ++i3) {
                        PuppetGameState.zobrist[j][k][i2][i3] = random.nextInt(Integer.MAX_VALUE);
                    }
                }
            }
        }
    }
}

