/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.core.AI;
import ai.puppet.ConfigurableScript;
import ai.puppet.Move;
import ai.puppet.PuppetBase;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import util.Pair;

public class PuppetMCTSNode {
    GameState gs;
    float C;
    PuppetMCTSNode parent;
    ConfigurableScript<?> script;
    float evaluation_bound;
    List<PuppetMCTSNode> children = new ArrayList<PuppetMCTSNode>();
    Move prevMove;
    int nextPlayerInSimultaneousNode;
    Move[] actions;
    int[] visit_count;
    float[] accum_evaluation;
    int total_visit_count;
    int index;

    public String toString() {
        return this.bestChild() == null ? "" : " time:" + this.gs.getTime() + " " + this.actions[this.bestChild().index].toString(this.script) + ", score: " + this.bestChild().score() + "\n" + this.bestChild().toString();
    }

    float score() {
        assert (this.parent.visit_count[this.index] == this.total_visit_count);
        return this.parent.accum_evaluation[this.index] / (float)this.total_visit_count;
    }

    public PuppetMCTSNode(GameState gameState, ConfigurableScript<?> configurableScript, float f, int n, float f2, PuppetMCTSNode puppetMCTSNode, Move move, int n2) {
        this.gs = gameState;
        this.script = configurableScript;
        this.C = f;
        this.nextPlayerInSimultaneousNode = n;
        this.evaluation_bound = f2;
        this.parent = puppetMCTSNode;
        this.prevMove = move;
        this.index = n2;
        this.actions = (Move[])configurableScript.getChoiceCombinations(this.toMove(), gameState).stream().map(arrayList -> new Move((ArrayList<Pair<Integer, Integer>>)arrayList, this.toMove())).toArray(Move[]::new);
        this.visit_count = new int[this.actions.length];
        this.accum_evaluation = new float[this.actions.length];
        this.total_visit_count = 0;
    }

    public PuppetMCTSNode(GameState gameState, ConfigurableScript<?> configurableScript, float f, int n, float f2) {
        this(gameState, configurableScript, f, n, f2, null, null, -1);
    }

    int toMove() {
        if (this.prevMove == null) {
            return this.nextPlayerInSimultaneousNode;
        }
        return 1 - this.prevMove.player;
    }

    PuppetMCTSNode bestChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        int n = -1;
        int n2 = 0;
        for (int j = 0; j < this.children.size(); ++j) {
            int n3 = this.visit_count[j];
            if (n != -1 && n3 <= n2) continue;
            n = j;
            n2 = n3;
        }
        return this.children.get(n);
    }

    PuppetMCTSNode selectLeaf(int n) throws Exception {
        if (this.children.size() < this.actions.length) {
            Move move = this.actions[this.children.size()];
            if (this.prevMove == null) {
                PuppetMCTSNode puppetMCTSNode = new PuppetMCTSNode(this.gs, this.script, this.C, 1 - this.nextPlayerInSimultaneousNode, this.evaluation_bound, this, move, this.children.size());
                this.children.add(puppetMCTSNode);
                return puppetMCTSNode.selectLeaf(n);
            }
            if (this.gs.gameover()) {
                return this;
            }
            GameState gameState = this.gs.clone();
            AI aI = this.script.clone();
            ((ConfigurableScript)aI).reset();
            AI aI2 = this.script.clone();
            ((ConfigurableScript)aI2).reset();
            ((ConfigurableScript)aI).setChoices(this.prevMove.choices);
            ((ConfigurableScript)aI2).setChoices(move.choices);
            PuppetBase.simulate(gameState, aI, aI2, this.prevMove.player, move.player, n);
            PuppetMCTSNode puppetMCTSNode = new PuppetMCTSNode(gameState, this.script, this.C, this.nextPlayerInSimultaneousNode, this.evaluation_bound, this, null, this.children.size());
            this.children.add(puppetMCTSNode);
            return puppetMCTSNode;
        }
        double d = 0.0;
        int n2 = -1;
        for (int j = 0; j < this.children.size(); ++j) {
            double d2 = (double)this.accum_evaluation[j] / (double)this.visit_count[j];
            double d3 = Math.sqrt(Math.log(this.total_visit_count) / (double)this.visit_count[j]);
            double d4 = (d2 /= (double)this.evaluation_bound) + (double)this.C * d3;
            if (n2 != -1 && !(d4 > d)) continue;
            n2 = j;
            d = d4;
        }
        if (n2 == -1) {
            return this;
        }
        return this.children.get(n2).selectLeaf(n);
    }

    void update(float f, int n) {
        ++this.total_visit_count;
        if (this.parent != null) {
            int n2 = this.index;
            this.parent.accum_evaluation[n2] = this.parent.accum_evaluation[n2] + (this.player() == n ? f : -f);
            int n3 = this.index;
            this.parent.visit_count[n3] = this.parent.visit_count[n3] + 1;
            this.parent.update(f, n);
        }
    }

    int player() {
        return this.parent != null ? this.parent.actions[this.index].player : -1;
    }
}

