/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.InterruptibleAI;
import ai.core.ParameterSpecification;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.puppet.BasicConfigurableScript;
import ai.puppet.PuppetBase;
import ai.puppet.PuppetSearchAB;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class PuppetNoPlan
extends AIWithComputationBudget
implements InterruptibleAI {
    PuppetBase puppet;

    public PuppetNoPlan(UnitTypeTable unitTypeTable) {
        this(new PuppetSearchAB(100, -1, -1, -1, 100, new BasicConfigurableScript(unitTypeTable, new FloodFillPathFinding()), new SimpleSqrtEvaluationFunction3()));
    }

    public PuppetNoPlan(PuppetBase puppetBase) {
        super(puppetBase.getTimeBudget(), puppetBase.getIterationsBudget());
        this.puppet = puppetBase;
    }

    @Override
    public final PlayerAction getAction(int n, GameState gameState) throws Exception {
        if (gameState.canExecuteAnyAction(n)) {
            this.startNewComputation(n, gameState.clone());
            this.computeDuringOneGameFrame();
            return this.getBestActionSoFar();
        }
        return new PlayerAction();
    }

    @Override
    public void setTimeBudget(int n) {
        this.puppet.setTimeBudget(n);
    }

    @Override
    public int getTimeBudget() {
        return this.puppet.getTimeBudget();
    }

    @Override
    public int getIterationsBudget() {
        return this.puppet.getIterationsBudget();
    }

    @Override
    public void setIterationsBudget(int n) {
        this.puppet.setIterationsBudget(n);
    }

    @Override
    public void startNewComputation(int n, GameState gameState) throws Exception {
        this.puppet.startNewComputation(n, gameState);
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        this.puppet.computeDuringOneGameFrame();
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        return this.puppet.getBestActionSoFar();
    }

    @Override
    public void reset() {
        this.puppet.reset();
    }

    @Override
    public AI clone() {
        PuppetNoPlan puppetNoPlan = new PuppetNoPlan((PuppetBase)this.puppet.clone());
        return puppetNoPlan;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.puppet.toString() + ")";
    }

    @Override
    public String statisticsString() {
        return this.puppet.statisticsString();
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return this.puppet.getParameters();
    }
}

