/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.puppet.BasicConfigurableScript;
import ai.puppet.CacheEntry;
import ai.puppet.CacheTable;
import ai.puppet.ConfigurableScript;
import ai.puppet.Entry;
import ai.puppet.Move;
import ai.puppet.MoveGenerator;
import ai.puppet.PuppetBase;
import ai.puppet.PuppetGameState;
import ai.puppet.TranspositionTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.Pair;

public class PuppetSearchAB
extends PuppetBase {
    protected int DEBUG = 0;
    protected int DEPTH;
    protected int MAXPLAYER = -1;
    Stack<ABCDNode> stack = new Stack();
    ABCDNode head;
    ABCDNode lastFinishedHead;
    Plan currentPlan;
    TranspositionTable TT = new TranspositionTable(100000);
    CacheTable CT = new CacheTable(100000);
    long allLeaves;
    long allTime;
    long allDepth;
    long allSearches;
    int ttHits = 0;
    int ttQueries = 0;
    int ctHits = 0;
    int ctQueries = 0;
    boolean tt = true;
    boolean ct = true;
    boolean reached;

    public PuppetSearchAB(UnitTypeTable unitTypeTable) {
        this(100, -1, 5000, -1, 100, new BasicConfigurableScript(unitTypeTable, new FloodFillPathFinding()), new SimpleSqrtEvaluationFunction3());
    }

    public PuppetSearchAB(int n, int n2, int n3, int n4, int n5, ConfigurableScript<?> configurableScript, EvaluationFunction evaluationFunction) {
        super(n, n2, n3, n4, n5, configurableScript, evaluationFunction);
        this.currentPlan = new Plan();
    }

    @Override
    public void reset() {
        super.reset();
        this.currentPlan = new Plan();
        this.stack.clear();
        this.head = null;
        this.lastFinishedHead = null;
        this.DEPTH = 0;
        this.clearStats();
    }

    @Override
    public AI clone() {
        PuppetSearchAB puppetSearchAB = new PuppetSearchAB(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAN_TIME, this.PLAN_PLAYOUTS, this.STEP_PLAYOUT_TIME, (ConfigurableScript<?>)this.script.clone(), this.eval);
        puppetSearchAB.currentPlan = this.currentPlan;
        puppetSearchAB.lastSearchFrame = this.lastSearchFrame;
        puppetSearchAB.lastSearchTime = this.lastSearchTime;
        return puppetSearchAB;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        assert (this.PLAN) : "This method can only be called when using a standing plan";
        if (this.lastSearchFrame == -1 || this.stack.empty()) {
            if (this.DEBUG >= 1) {
                System.out.println("Restarting after " + (gameState.getTime() - this.lastSearchFrame) + " frames, " + (System.currentTimeMillis() - this.lastSearchTime) + " ms");
            }
            this.startNewComputation(n, gameState);
        }
        if (this.DEBUG >= 2) {
            System.out.println("Starting ABCD at frame " + gameState.getTime() + ", player " + n + " with " + this.TIME_BUDGET + " ms");
        }
        if (!this.stack.empty()) {
            this.computeDuringOneGameFrame();
        }
        if (gameState.canExecuteAnyAction(n) && gameState.winner() == -1) {
            if (this.DEBUG >= 2) {
                System.out.println("Issuing move using choices: " + this.currentPlan.getChoices());
            }
            this.currentPlan.update(gameState);
            this.script.setDefaultChoices();
            this.script.setChoices(this.currentPlan.getChoices());
            PlayerAction playerAction = this.script.getAction(n, gameState);
            return playerAction;
        }
        return new PlayerAction();
    }

    @Override
    public String statisticsString() {
        return "Average Number of Leaves: " + this.allLeaves / this.allSearches + ", Average Depth: " + this.allDepth / this.allSearches + ", Average Time: " + this.allTime / this.allSearches;
    }

    void clearStats() {
        this.allDepth = 0L;
        this.allLeaves = 0L;
        this.allTime = 0L;
        this.allSearches = -1L;
    }

    @Override
    public void startNewComputation(int n, GameState gameState) {
        this.MAXPLAYER = n;
        this.lastSearchFrame = gameState.getTime();
        this.lastSearchTime = System.currentTimeMillis();
        this.stack.clear();
        this.stack.push(new ABCDNode(new PuppetGameState(gameState.clone()), null, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, 0, this.MAXPLAYER, null));
        this.head = this.stack.peek();
        this.allLeaves += (long)this.totalLeaves;
        this.allTime += this.totalTime;
        this.allDepth += (long)this.DEPTH;
        ++this.allSearches;
        this.totalLeaves = 0;
        this.totalTime = 0L;
        this.DEPTH = 0;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        assert (!this.PLAN) : "This method can only be called when not using a standing plan";
        if (this.DEBUG >= 1) {
            System.out.println("ABCD:\n" + this.currentPlan + " in " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, leaves: " + this.totalLeaves);
        }
        this.script.setDefaultChoices();
        this.script.setChoices(this.currentPlan.getChoices());
        return this.script.getAction(this.MAXPLAYER, this.head.gs.gs);
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l = this.frameStartTime = System.currentTimeMillis();
        this.frameLeaves = 0;
        do {
            if (this.DEPTH == 0) {
                this.DEPTH += 2;
                this.reached = false;
            } else if (this.stack.empty()) {
                if (!this.reached) break;
                this.lastFinishedHead = this.head;
                if (this.DEBUG >= 2) {
                    System.out.println("ABCD:\n" + this.lastFinishedHead + " in " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, leaves: " + this.totalLeaves + ", depth: " + this.DEPTH);
                }
                this.DEPTH += 2;
                this.stack.push(new ABCDNode(new PuppetGameState(this.head.gs), null, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, 0, this.MAXPLAYER, null));
                this.head = this.stack.peek();
                this.reached = false;
            }
            this.iterativeABCD(this.DEPTH);
            if (this.stack.empty()) {
                this.lastFinishedHead = this.head;
            }
            long l2 = System.currentTimeMillis();
            this.totalTime += l2 - l;
            l = l2;
            this.frameTime = l - this.frameStartTime;
        } while (!this.frameBudgetExpired() && !this.searchDone());
        if (!this.PLAN) {
            this.currentPlan = new Plan(this.lastFinishedHead);
        }
        if (this.searchDone()) {
            if (this.DEBUG >= 1) {
                System.out.println(this.ttHits + "/" + this.ttQueries + " TT, " + this.ctHits + "/" + this.ctQueries + " CT");
            }
            this.stack.clear();
            this.currentPlan = new Plan(this.lastFinishedHead);
            if (this.DEBUG >= 1) {
                System.out.println("ABCD:\n" + this.currentPlan + " in " + this.totalTime + " ms, wall time: " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, leaves: " + this.totalLeaves);
            }
        }
    }

    boolean searchDone() {
        return this.PLAN && this.planBudgetExpired();
    }

    protected void iterativeABCD(int n) throws Exception {
        assert (n % 2 == 0);
        if (this.DEBUG >= 2) {
            System.out.println("ABCD at " + this.head.gs.gs.getTime());
        }
        while (!(this.stack.isEmpty() || this.frameBudgetExpired() || this.searchDone())) {
            Object object;
            Object object2;
            if (this.DEBUG >= 2) {
                System.out.println(this.stack);
            }
            ABCDNode aBCDNode = this.stack.peek();
            if (aBCDNode.prevMove == null) {
                if (aBCDNode.depth == n || aBCDNode.gs.gs.gameover()) {
                    if (this.DEBUG >= 2) {
                        System.out.println("eval");
                    }
                    if (aBCDNode.depth == n) {
                        this.reached = true;
                    }
                    ++this.frameLeaves;
                    ++this.totalLeaves;
                    this.stack.pop();
                    object2 = this.stack.peek();
                    object = new Result(((ABCDNode)object2).nextMoves.last(), this.eval.evaluate(this.MAXPLAYER, 1 - this.MAXPLAYER, aBCDNode.gs.gs));
                    ((ABCDNode)object2).setResult((Result)object, aBCDNode);
                } else if (aBCDNode.nextMoves.hasNext()) {
                    if (this.tt && aBCDNode.nextMoves.current == 0) {
                        object2 = this.TT.lookup(aBCDNode.gs);
                        ++this.ttQueries;
                        if (object2 != null) {
                            aBCDNode.nextMoves.swapFront(((Entry)object2)._bestMove);
                            ++this.ttHits;
                        }
                    }
                    if (this.DEBUG >= 2) {
                        System.out.println("current.nextMoves.hasNext()");
                    }
                    this.stack.push(new ABCDNode(aBCDNode.gs, aBCDNode.nextMoves.next(), aBCDNode.alpha, aBCDNode.beta, aBCDNode.depth + 1, 1 - aBCDNode.nextPlayerInSimultaneousNode, null));
                } else {
                    this.stack.pop();
                    if (!this.stack.empty()) {
                        object2 = this.stack.peek();
                        ((ABCDNode)object2).setResult(new Result(((ABCDNode)object2).nextMoves.last(), aBCDNode.best.score), aBCDNode);
                    }
                    if (this.tt) {
                        this.TT.store(aBCDNode.gs, aBCDNode.best.m, aBCDNode.best.score, aBCDNode.alpha, aBCDNode.beta, n - aBCDNode.depth);
                    }
                }
            } else if (aBCDNode.nextMoves.hasNext()) {
                if (this.tt && aBCDNode.nextMoves.current == 0) {
                    object2 = this.TT.lookup(aBCDNode.gs, aBCDNode.depth, aBCDNode.prevMove);
                    ++this.ttQueries;
                    if (object2 != null) {
                        aBCDNode.nextMoves.swapFront(((Entry)object2)._bestMove);
                        ++this.ttHits;
                    }
                }
                object2 = aBCDNode.nextMoves.next();
                object = null;
                if (this.ct) {
                    CacheEntry cacheEntry = this.CT.lookup(aBCDNode.gs, aBCDNode.depth - 1, aBCDNode.prevMove, (Move)object2);
                    ++this.ctQueries;
                    if (cacheEntry != null) {
                        object = cacheEntry._state;
                        ++this.ctHits;
                    }
                }
                if (object == null) {
                    GameState gameState = aBCDNode.gs.gs.clone();
                    AI aI = this.script.clone();
                    ((ConfigurableScript)aI).reset();
                    AI aI2 = this.script.clone();
                    ((ConfigurableScript)aI2).reset();
                    ((ConfigurableScript)aI).setChoices(aBCDNode.prevMove.choices);
                    ((ConfigurableScript)aI2).setChoices(((Move)object2).choices);
                    PuppetSearchAB.simulate(gameState, aI, aI2, aBCDNode.prevMove.player, ((Move)object2).player, this.STEP_PLAYOUT_TIME);
                    object = new PuppetGameState(aBCDNode.gs, gameState, aBCDNode.depth - 1, aBCDNode.prevMove, (Move)object2);
                    if (this.ct) {
                        this.CT.store(aBCDNode.gs, (PuppetGameState)object);
                    }
                }
                this.stack.push(new ABCDNode((PuppetGameState)object, null, aBCDNode.alpha, aBCDNode.beta, aBCDNode.depth + 1, aBCDNode.nextPlayerInSimultaneousNode, null));
            } else {
                this.stack.pop();
                object2 = this.stack.peek();
                ((ABCDNode)object2).setResult(new Result(((ABCDNode)object2).nextMoves.last(), aBCDNode.best.score), aBCDNode);
                if (this.tt) {
                    this.TT.store(aBCDNode.gs, aBCDNode.depth, aBCDNode.prevMove, aBCDNode.best.m, aBCDNode.best.score, aBCDNode.alpha, aBCDNode.beta, n - aBCDNode.depth);
                }
            }
            this.frameTime = System.currentTimeMillis() - this.frameStartTime;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.PLAN_TIME + ", " + this.PLAN_PLAYOUTS + ", " + this.STEP_PLAYOUT_TIME + ", " + this.script + ", " + this.eval + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlanTimeBudget", Integer.TYPE, 5000));
        arrayList.add(new ParameterSpecification("PlanIterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("StepPlayoutTime", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getStepPlayoutTime() {
        return this.STEP_PLAYOUT_TIME;
    }

    public void setStepPlayoutTime(int n) {
        this.STEP_PLAYOUT_TIME = n;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.eval;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.eval = evaluationFunction;
    }

    class Plan {
        ABCDNode node;

        Plan(ABCDNode aBCDNode) {
            this.node = aBCDNode;
        }

        Plan() {
            this.node = null;
        }

        void update(GameState gameState) {
            while (!(this.node == null || gameState.getTime() - this.node.gs.gs.getTime() <= PuppetSearchAB.this.STEP_PLAYOUT_TIME && this.node.isMaxPlayer())) {
                this.node = this.node.following;
            }
        }

        Collection<Pair<Integer, Integer>> getChoices() {
            if (this.valid()) {
                return this.node.best.m.choices;
            }
            return Collections.emptyList();
        }

        boolean valid() {
            return this.node != null && this.node.best != null;
        }

        public String toString() {
            return this.node != null ? this.node.toString() : "";
        }
    }

    class ABCDNode {
        PuppetGameState gs;
        Move prevMove;
        float alpha;
        float beta;
        int depth;
        int nextPlayerInSimultaneousNode;
        MoveGenerator nextMoves;
        Result best;
        ABCDNode following;

        public ABCDNode(PuppetGameState puppetGameState, Move move, float f, float f2, int n, int n2, Result result) {
            this.gs = puppetGameState;
            this.prevMove = move;
            this.alpha = f;
            this.beta = f2;
            this.depth = n;
            this.nextPlayerInSimultaneousNode = n2;
            this.best = result;
            this.nextMoves = new MoveGenerator(PuppetSearchAB.this.script.getChoiceCombinations(this.toMove(), puppetGameState.gs), this.toMove());
            this.following = null;
        }

        int toMove() {
            if (this.prevMove == null) {
                return this.nextPlayerInSimultaneousNode;
            }
            return 1 - this.prevMove.player;
        }

        boolean isMaxPlayer() {
            return this.toMove() == PuppetSearchAB.this.MAXPLAYER;
        }

        void setResult(Result result, ABCDNode aBCDNode) {
            if (this.best == null) {
                this.best = result;
                this.following = aBCDNode;
            } else if (this.isMaxPlayer()) {
                this.alpha = Math.max(this.alpha, this.best.score);
                if (result.score > this.best.score) {
                    this.best = result;
                    this.following = aBCDNode;
                }
            } else if (!this.isMaxPlayer()) {
                this.beta = Math.min(this.beta, this.best.score);
                if (result.score < this.best.score) {
                    this.best = result;
                    this.following = aBCDNode;
                }
            }
            if (this.alpha >= this.beta) {
                this.nextMoves.ABcut();
            }
        }

        public String toString() {
            return " time:" + this.gs.gs.getTime() + " " + this.best + "\n" + (this.following != null ? this.following.toString() : "");
        }
    }

    class Result {
        Move m;
        float score;

        public Result(Move move, float f) {
            this.m = move;
            this.score = f;
        }

        public String toString() {
            return this.m.toString(PuppetSearchAB.this.script) + ", score: " + this.score;
        }
    }
}

