/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.RandomBiasedAI;
import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.puppet.BasicConfigurableScript;
import ai.puppet.ConfigurableScript;
import ai.puppet.PuppetBase;
import ai.puppet.PuppetMCTSNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.Pair;

public class PuppetSearchMCTS
extends PuppetBase {
    int DEBUG = 0;
    int EVAL_PLAYOUT_TIME;
    AI policy1;
    AI policy2;
    PuppetMCTSNode root;
    Plan currentPlan;
    float C;
    long allLeaves;
    long allTime;
    long allSearches;

    public PuppetSearchMCTS(UnitTypeTable unitTypeTable) {
        this(100, -1, 5000, -1, 100, 100, new RandomBiasedAI(), new BasicConfigurableScript(unitTypeTable, new FloodFillPathFinding()), new SimpleSqrtEvaluationFunction3());
    }

    public PuppetSearchMCTS(int n, int n2, int n3, int n4, int n5, int n6, AI aI, ConfigurableScript<?> configurableScript, EvaluationFunction evaluationFunction) {
        super(n, n2, n3, n4, n5, configurableScript, evaluationFunction);
        this.EVAL_PLAYOUT_TIME = n6;
        this.policy1 = aI.clone();
        this.policy2 = aI.clone();
        this.currentPlan = new Plan();
        this.root = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.policy1.reset();
        this.policy2.reset();
        this.currentPlan = new Plan();
        this.root = null;
        this.clearStats();
    }

    @Override
    public String statisticsString() {
        return "Average Number of Leaves: " + (this.allSearches > 0L ? Long.valueOf(this.allLeaves / this.allSearches) : "-") + ", Average Time: " + (this.allSearches > 0L ? Long.valueOf(this.allTime / this.allSearches) : "-");
    }

    void clearStats() {
        this.allLeaves = 0L;
        this.allTime = 0L;
        this.allSearches = -1L;
    }

    @Override
    public AI clone() {
        PuppetSearchMCTS puppetSearchMCTS = new PuppetSearchMCTS(this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAN_TIME, this.PLAN_PLAYOUTS, this.STEP_PLAYOUT_TIME, this.EVAL_PLAYOUT_TIME, this.policy1.clone(), (ConfigurableScript<?>)this.script.clone(), this.eval);
        puppetSearchMCTS.currentPlan = this.currentPlan;
        puppetSearchMCTS.lastSearchFrame = this.lastSearchFrame;
        puppetSearchMCTS.lastSearchTime = this.lastSearchTime;
        return puppetSearchMCTS;
    }

    private void setC(GameState gameState) {
        this.C = gameState.getPhysicalGameState().getWidth() <= 8 ? 1.0f : (gameState.getPhysicalGameState().getWidth() <= 16 ? 10.0f : 0.1f);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        assert (this.PLAN) : "This method can only be called when using a standing plan";
        this.setC(gameState);
        if (this.lastSearchFrame == -1 || this.root == null) {
            if (this.DEBUG >= 1) {
                System.out.println("Restarting after " + (gameState.getTime() - this.lastSearchFrame) + " frames, " + (System.currentTimeMillis() - this.lastSearchTime) + " ms (" + this.totalTime + " ms)");
            }
            this.startNewComputation(n, gameState);
        }
        if (this.DEBUG >= 3) {
            System.out.println("Starting MCTS at frame " + gameState.getTime() + ", player " + n + " with " + this.TIME_BUDGET + " ms");
        }
        if (this.root != null) {
            this.computeDuringOneGameFrame();
        }
        if (gameState.canExecuteAnyAction(n) && gameState.winner() == -1) {
            this.currentPlan.update(gameState, n);
            if (this.DEBUG >= 2) {
                System.out.println("Issuing move using choices: " + this.currentPlan.getChoices());
            }
            this.script.setDefaultChoices();
            this.script.setChoices(this.currentPlan.getChoices());
            PlayerAction playerAction = this.script.getAction(n, gameState);
            return playerAction;
        }
        return new PlayerAction();
    }

    @Override
    public void startNewComputation(int n, GameState gameState) {
        this.setC(gameState);
        this.lastSearchFrame = gameState.getTime();
        this.lastSearchTime = System.currentTimeMillis();
        this.root = new PuppetMCTSNode(gameState.clone(), this.script, this.C, n, this.eval.upperBound(gameState));
        this.allLeaves += (long)this.totalLeaves;
        this.allTime += this.totalTime;
        ++this.allSearches;
        this.totalLeaves = 0;
        this.totalTime = 0L;
    }

    @Override
    public PlayerAction getBestActionSoFar() throws Exception {
        assert (!this.PLAN) : "This method can only be called when not using s standing plan";
        if (this.DEBUG >= 1) {
            System.out.println("Done. Moves:\n" + this.root + " in " + this.totalTime + " ms, wall time: " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, playouts: " + this.totalLeaves);
        }
        this.script.setDefaultChoices();
        this.script.setChoices(this.root.actions[this.root.bestChild().index].choices);
        return this.script.getAction(this.root.nextPlayerInSimultaneousNode, this.root.gs);
    }

    @Override
    public void computeDuringOneGameFrame() throws Exception {
        long l = this.frameStartTime = System.currentTimeMillis();
        this.frameLeaves = 0;
        if (this.DEBUG >= 2) {
            System.out.println("Search...");
        }
        do {
            this.monteCarloRun();
            long l2 = System.currentTimeMillis();
            this.totalTime += l2 - l;
            l = l2;
            this.frameTime = l2 - this.frameStartTime;
        } while (!this.frameBudgetExpired() && !this.searchDone());
        if (this.searchDone()) {
            this.currentPlan = new Plan(this.root);
            this.root = null;
            if (this.DEBUG >= 1) {
                System.out.println("Done. Updating Plan:\n" + this.currentPlan + " in " + this.totalTime + " ms, wall time: " + (System.currentTimeMillis() - this.lastSearchTime) + " ms, playouts: " + this.totalLeaves);
            }
        }
    }

    void monteCarloRun() throws Exception {
        float f;
        PuppetMCTSNode puppetMCTSNode = this.root.selectLeaf(this.STEP_PLAYOUT_TIME);
        if (!puppetMCTSNode.gs.gameover()) {
            ++this.frameLeaves;
            ++this.totalLeaves;
            this.policy1.reset();
            this.policy2.reset();
            GameState gameState = puppetMCTSNode.gs.clone();
            PuppetSearchMCTS.simulate(gameState, this.policy1, this.policy2, puppetMCTSNode.parent.player(), puppetMCTSNode.player(), this.EVAL_PLAYOUT_TIME);
            f = this.eval.evaluate(puppetMCTSNode.player(), 1 - puppetMCTSNode.player(), gameState);
        } else {
            f = this.eval.evaluate(puppetMCTSNode.player(), 1 - puppetMCTSNode.player(), puppetMCTSNode.gs);
        }
        puppetMCTSNode.update(f, puppetMCTSNode.player());
    }

    boolean searchDone() {
        return this.PLAN && this.planBudgetExpired();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.PLAN_TIME + ", " + this.PLAN_PLAYOUTS + ", " + this.STEP_PLAYOUT_TIME + ", " + this.EVAL_PLAYOUT_TIME + ", " + this.policy1 + ", " + this.script + ", " + this.eval + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlanTimeBudget", Integer.TYPE, 5000));
        arrayList.add(new ParameterSpecification("PlanIterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("StepPlayoutTime", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("EvalPlayoutTime", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("Policy", AI.class, this.policy1));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public int getStepPlayoutTime() {
        return this.STEP_PLAYOUT_TIME;
    }

    public void setStepPlayoutTime(int n) {
        this.STEP_PLAYOUT_TIME = n;
    }

    public int getEvalPlayoutTime() {
        return this.EVAL_PLAYOUT_TIME;
    }

    public void setEvalPlayoutTime(int n) {
        this.EVAL_PLAYOUT_TIME = n;
    }

    public AI getPolicy() {
        return this.policy1;
    }

    public void setPolicy(AI aI) throws Exception {
        this.policy1 = aI.clone();
        this.policy2 = aI.clone();
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.eval;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.eval = evaluationFunction;
    }

    class Plan {
        PuppetMCTSNode node;

        Plan() {
            this.node = null;
        }

        Plan(PuppetMCTSNode puppetMCTSNode) {
            this.node = puppetMCTSNode;
        }

        void update(GameState gameState, int n) {
            while (this.valid() && (gameState.getTime() - this.node.gs.getTime() > PuppetSearchMCTS.this.STEP_PLAYOUT_TIME || this.node.bestChild().player() != n)) {
                this.node = this.node.bestChild();
            }
        }

        Collection<Pair<Integer, Integer>> getChoices() {
            if (this.valid()) {
                return this.node.actions[this.node.bestChild().index].choices;
            }
            return Collections.emptyList();
        }

        boolean valid() {
            return this.node != null && this.node.bestChild() != null;
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

