/*
 * Decompiled with CFR 0.152.
 */
package ai.puppet;

import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.puppet.ConfigurableScript;
import ai.puppet.SingleChoice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;

public class SingleChoiceConfigurableScript
extends ConfigurableScript<SingleChoice> {
    AI[] scripts;

    public SingleChoiceConfigurableScript(PathFinding pathFinding, AI[] aIArray) {
        super(pathFinding);
        this.scripts = aIArray;
        this.choicePoints = new EnumMap(SingleChoice.class);
        this.choices = new EnumMap(SingleChoice.class);
        this.choicePointValues = SingleChoice.values();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        for (AI aI : this.scripts) {
            aI.reset();
        }
    }

    @Override
    public Collection<ConfigurableScript.Options> getApplicableChoicePoints(int n, GameState gameState) {
        return this.getAllChoicePoints();
    }

    @Override
    public void initializeChoices() {
        int[] nArray = new int[this.scripts.length];
        for (int j = 0; j < this.scripts.length; ++j) {
            nArray[j] = j;
        }
        for (SingleChoice singleChoice : (SingleChoice[])this.choicePointValues) {
            switch (singleChoice) {
                case SINGLE: {
                    this.choicePoints.put(singleChoice, new ConfigurableScript.Options(this, singleChoice.ordinal(), nArray));
                }
            }
        }
    }

    @Override
    public ConfigurableScript<SingleChoice> clone() {
        AI[] aIArray = new AI[this.scripts.length];
        for (int j = 0; j < this.scripts.length; ++j) {
            aIArray[j] = this.scripts[j].clone();
        }
        SingleChoiceConfigurableScript singleChoiceConfigurableScript = new SingleChoiceConfigurableScript(this.pf, aIArray);
        singleChoiceConfigurableScript.choices = this.choices.clone();
        singleChoiceConfigurableScript.choicePoints = this.choicePoints.clone();
        singleChoiceConfigurableScript.choicePointValues = (Enum[])((SingleChoice[])this.choicePointValues).clone();
        return singleChoiceConfigurableScript;
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        return this.scripts[(Integer)this.choices.get((Object)SingleChoice.SINGLE)].getAction(n, gameState);
    }

    @Override
    public String toString() {
        String string = "SingleChoicePoint(";
        for (AI aI : this.scripts) {
            string = string + aI.toString() + ",";
        }
        return string + ")";
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new FloodFillPathFinding()));
        arrayList.add(new ParameterSpecification("Scripts", AI[].class, this.scripts));
        return arrayList;
    }
}

